<?php
/**
 * The New/Edit filter view.
 *
 * phpcs:ignorefile WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
 * @see admin.php?page=ajax-load-more-filters&action=new
 * @package ALMFilters
 */

?>
<script>
	/* Pass current filter attributes as JS variable */
	var alm_filters = <?php echo $filter_vue ? wp_json_encode( $filter_vue ) : '""'; ?>;
	var alm_filter_id = <?php echo $filter_vue ? '"' . esc_html( $filter_id ) . '"' : '""'; ?>;
</script>
<?php

// Does this filter contain a facets array.
$has_facets = isset( $filter['facets'] ) && $filter['facets'] === true;

// Set a default filter status if it doesn't exist.
if ( $has_facets && $filter_id ) {
	ALM_Facets::set_default_facet_status( $filter_id );
}
?>

<!-- Start app -->
<div class="ajax-load-more-inner-wrapper" id="app">
	<!-- MAIN COLUMN -->
	<div class="cnkt-main stylefree">
		<div class="alm-filters">
			<?php require ALM_FILTERS_PATH . 'admin/views/includes/navigation.php'; ?>
			<div class="alm-content-wrap">
				<header class="alm-filter--intro">
					<?php if ( ! $editing ) { ?>
					<h2><?php esc_attr_e( 'Add New Filter', 'ajax-load-more-filters' ); ?></h2>
					<p><?php esc_attr_e( 'Create an Ajax Load More filter by customizing the options below.', 'ajax-load-more-filters' ); ?></p>
					<?php } else { ?>
					<div>
						<h2><?php esc_attr_e( 'Filter:', 'ajax-load-more-filters' ); ?> <strong v-cloak>{{ data[0].id }}</strong></h2>
						<p>
							<?php esc_attr_e( 'Edit this filter by adjusting the options below.', 'ajax-load-more-filters' ); ?>
						</p>
					</div>
					<a href="<?php echo esc_attr( get_home_url() ); ?>?alm_filters_preview=<?php echo esc_attr( $filter_id ); ?>" target="_blank" class="button"><?php esc_attr_e( 'Preview Filter', 'ajax-load-more-filters' ); ?></a>
					<?php } ?>
				</header>

				<header class="alm-filter--header">
					<div class="title-area">
						<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 640"><path d="M480 544C515.3 544 544 515.3 544 480L544 160C544 124.7 515.3 96 480 96L160 96C124.7 96 96 124.7 96 160L96 480C96 515.3 124.7 544 160 544L480 544zM480 400C480 413.3 469.3 424 456 424L416 424L416 456C416 469.3 405.3 480 392 480C378.7 480 368 469.3 368 456L368 424L184 424C170.7 424 160 413.3 160 400C160 386.7 170.7 376 184 376L368 376L368 344C368 330.7 378.7 320 392 320C405.3 320 416 330.7 416 344L416 376L456 376C469.3 376 480 386.7 480 400zM456 216C469.3 216 480 226.7 480 240C480 253.3 469.3 264 456 264L272 264L272 296C272 309.3 261.3 320 248 320C234.7 320 224 309.3 224 296L224 264L184 264C170.7 264 160 253.3 160 240C160 226.7 170.7 216 184 216L224 216L224 184C224 170.7 234.7 160 248 160C261.3 160 272 170.7 272 184L272 216L456 216z"/></svg>
						<div>
							<h3><?php esc_html_e( 'Settings', 'ajax-load-more-filters' ); ?></h3>
							<p><?php esc_html_e( 'Configure this filter by providing a unique filter ID and selecting interaction styles.', 'ajax-load-more-filters' ); ?></p>
						</div>
					</div>
				</header>

				<section class="alm-filter--options">

					<!-- Filter ID -->
					<div class="alm-filter--row" id="row-id" v-bind:class="{ done: data[0].id !=='' }">
						<label data-id="id">
							<div class="label">
								<?php esc_attr_e( 'ID', 'ajax-load-more-filters' ); ?>
								<a
									title="<?php esc_attr_e( 'The unique ID for this filter instance. The ID must be lowercase and be without spaces or hyphens.', 'ajax-load-more-filters' ); ?>"
									href="javascript:void(0)"
									class="fa fa-question-circle tooltip" tabindex="-1"
								></a>
							</div>
							<div class="item">
								<input
									type="text"
									id="filter-id"
									class="filter-element"
									:value="data[0].id"
									data-id="id"
									v-on:keyup="optionsChange($event)"
									v-on:keypress="restrictIDChars($event)"
									style="text-transform: lowercase;"
									<?php
									if ( $editing ) {
										echo ' readonly="readonly"'; }
									?>
									>
							</div>
						</label>
					</div>

					<!-- Style -->
					<div class="alm-filter--row" id="row-style" v-bind:class="{ done: data[0].style !=='' }">
						<label data-id="style">
							<div class="label">
								<?php esc_attr_e( 'Style', 'ajax-load-more-filters' ); ?>
								<a title="<?php esc_attr_e( 'Select a user interaction for this filter.', 'ajax-load-more-filters' ); ?>" href="javascript:void(0)" class="fa fa-question-circle tooltip" tabindex="-1"></a>
							</div>
							<div class="item">
								<div class="select-wrapper">
									<select
										id="filter-style"
										class="alm-filter-select"
										data-id="style"
										v-on:change="optionsChange($event)"
									>
										<option value=""<?php echo ! isset( $filter['style'] ) ? esc_attr( $selected ) : ''; ?>>-- <?php esc_attr_e( 'Select Style', 'ajax-load-more-filters' ); ?> --</option>
										<option value="change"<?php echo isset( $filter['style'] ) && $filter['style'] === 'change' ? esc_attr( $selected ) : ''; ?>><?php esc_attr_e( 'Change', 'ajax-load-more-filters' ); ?></option>
										<option value="button"<?php echo isset( $filter['style'] ) && $filter['style'] === 'button' ? esc_attr( $selected ) : ''; ?>><?php esc_attr_e( 'Submit Button', 'ajax-load-more-filters' ); ?></option>
									</select>
								</div>
							</div>
						</label>
					</div>

					<!-- Button Label -->
					<div class="related-filters--wrap" v-if="data[0].style === 'button'">
						<div class="alm-filter--row not-required" id="row-button-text" data-id="button-text">
							<label data-id="button_text">
								<div class="label">
									<?php esc_attr_e( 'Button Label', 'ajax-load-more-filters' ); ?>
									<a title="<?php esc_attr_e( 'Enter a label for the filter submit button.', 'ajax-load-more-filters' ); ?>" href="javascript:void(0)" class="fa fa-question-circle tooltip" tabindex="-1"></a>
								</div>
								<div class="item">
									<input type="text" id="filter-button-text" data-id="button_text" :value="data[0].button_text" v-on:change="optionsChange($event)" placeholder="<?php echo wp_kses_post( apply_filters( 'alm_filters_button_text', esc_attr__( 'Submit', 'ajax-load-more-filters' ) ) ); ?>">
								</div>
							</label>
						</div>
					</div>

					<!-- Facets -->
					<div class="alm-filter--row not-required" id="row-facets">
						<div class="fake-label">
							<div class="label">
								<?php esc_attr_e( 'Facets', 'ajax-load-more-filters' ); ?>
								<a
									title="<?php esc_attr_e( 'Facet filtering refines the available filter options with each user selection.', 'ajax-load-more-filters' ); ?>"
									href="javascript:void(0)"
									class="fa fa-question-circle tooltip" tabindex="-1"
								></a>
							</div>
							<div class="item">
								<div class="checkbox-wrapper">
									<input type="checkbox" id="filter-facets" data-id="facets" value="true" :checked="data[0].facets === true" v-on:change="optionsChange($event)">
									<label class="checkbox" for="filter-facets">
										<span><?php esc_attr_e( 'Enable Facet Filtering', 'ajax-load-more-filters' ); ?></span>
									</label>
								</div>
							</div>
						</div>
					</div>
					<?php
					$pt_args    = [
						'public' => true,
					];
					$post_types = get_post_types( $pt_args );
					if ( $post_types ) {
						?>
					<!-- Facet Post Types -->
					<div class="related-filters--wrap" v-show="data[0].facets === true">
						<div class="alm-filter--row" id="row-facets_post_types" v-bind:class="{ done: data[0].facets_post_types && data[0].facets_post_types.length > 0 }">
							<label data-id="facets_post_types">
								<div class="label align-top">
									<?php esc_attr_e( 'Post Types', 'ajax-load-more-filters' ); ?>
									<a
										title="<?php esc_attr_e( 'The selected Post Types must exactly match the Post Types included in your core Ajax Load More setup.', 'ajax-load-more-filters' ); ?>"
										href="javascript:void(0)"
										class="fa fa-question-circle tooltip" tabindex="-1"
									></a>
								</div>
								<div class="item">
									<div class="select-wrapper">
										<p><?php esc_attr_e( 'Select the Post Types to be include in your facets.', 'ajax-load-more-filters' ); ?></p>
										<select
											id="filter-facets_post_types"
											class="alm-filter-select"
											data-id="facets_post_types"
											v-on:change="optionsChange($event)"
											size="<?php echo esc_attr( count( $post_types ) ); ?>"
											multiple
										>
											<?php
											foreach ( $post_types as $type ) {
												$typeobj = get_post_type_object( $type );
												?>
												<option value="<?php echo esc_attr( $typeobj->name ); ?>" :selected="data[0].facets_post_types && data[0].facets_post_types.indexOf('<?php echo esc_attr( $typeobj->name ); ?>') !== -1">
													<?php echo esc_attr( $typeobj->labels->singular_name ); ?> (<?php echo esc_attr( $typeobj->name ); ?>)
												</option>
											<?php	} ?>
										</select>
										<p class="meta-instructions"><?php echo wp_kses_post( __( '<strong>Tip</strong>: Hold the CMD (Mac) or CTRL (PC) key to select multiple Post Types.', 'ajax-load-more-filters' ) ); ?></p>
									</div>
								</div>
							</label>
						</div>

						<!-- Hide Facets -->
						<div class="alm-filter--row not-required" id="row-facets_hide_inactive">
							<div class="fake-label">
								<label data-id="facets_hide_inactive">
									<div class="label">
										<?php esc_attr_e( 'Inactive Filters', 'ajax-load-more-filters' ); ?>
										<a
											title="<?php esc_attr_e( 'By default, inactive filters are disabled (not hidden) on the frontend.', 'ajax-load-more-filters' ); ?>"
											href="javascript:void(0)"
											class="fa fa-question-circle tooltip" tabindex="-1"
										></a>
									</div>
									<div class="item">
										<div class="checkbox-wrapper">
											<input type="checkbox" id="filter-facets_hide_inactive" data-id="facets_hide_inactive" value="true" :checked="data[0].facets_hide_inactive === true" v-on:change="optionsChange($event)">
											<label class="checkbox" for="filter-facets_hide_inactive">
												<span><?php esc_attr_e( 'Hide Inactive Filter Options', 'ajax-load-more-filters' ); ?></span>
											</label>
										</div>
									</div>
								</label>
							</div>
						</div>
					</div>
					<?php } ?>

					<!-- Filter Reset -->
					<div class="alm-filter--row not-required" id="row-reset_button">
						<div class="fake-label">
							<div class="label">
								<?php esc_attr_e( 'Reset Filters', 'ajax-load-more-filters' ); ?>
								<a
									title="<?php esc_attr_e( 'Add a `Reset Filters` button that clears all currently active filters.', 'ajax-load-more-filters' ); ?>"
									href="javascript:void(0)"
									class="fa fa-question-circle tooltip" tabindex="-1"
								></a>
							</div>
							<div class="item">
								<div class="checkbox-wrapper">
									<input type="checkbox" id="filter-reset_button" data-id="reset_button" value="true" :checked="data[0].reset_button === true" v-on:change="optionsChange($event)">
									<label class="checkbox" for="filter-reset_button">
										<span><?php echo wp_kses_post( __( 'Display <strong>Reset Filters</strong> Button', 'ajax-load-more-filters' ) ); ?></span>
									</label>
								</div>
							</div>
						</div>
					</div>

					<!-- Filter Reset Text -->
					<div class="related-filters--wrap" v-show="data[0].reset_button === true">
						<div class="alm-filter--row not-required" id="row-reset_button_label">
							<label data-id="reset_button_label">
								<div class="label">
									<?php esc_attr_e( 'Reset Button Label', 'ajax-load-more-filters' ); ?>
									<a
										title="<?php esc_attr_e( 'Enter a label for the `Reset Filters` button.', 'ajax-load-more-filters' ); ?>"
										href="javascript:void(0)"
										class="fa fa-question-circle tooltip" tabindex="-1"
									></a>
								</div>
								<div class="item">
									<input type="text" id="filter-reset_button_label" data-id="reset_button_label" :value="data[0].reset_button_label" v-on:change="optionsChange($event)" placeholder="<?php echo esc_attr( apply_filters( 'alm_filters_reset_button_label', __( 'Reset Filters', 'ajax-load-more-filters' ) ) ); ?>">
								</div>
							</label>
						</div>
					</div>
				</section>

				<!-- Header -->
				<header class="alm-filter--header">
					<div class="title-area">
						<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 640"><path d="M33.8 142.8C37.5 133.8 46.3 128 56 128L392 128C401.7 128 410.5 133.8 414.2 142.8C417.9 151.8 415.9 162.1 409 169L280 298L280 488.1C280 497.8 274.2 506.6 265.2 510.3C256.2 514 245.9 512 239 505.1L175 441.1C170.5 436.6 168 430.5 168 424.1L168 297.9L39 169C32.2 162.1 30.1 151.8 33.8 142.8zM480 160C480 142.3 494.3 128 512 128L544 128C561.7 128 576 142.3 576 160C576 177.7 561.7 192 544 192L512 192C494.3 192 480 177.7 480 160zM352 320C352 302.3 366.3 288 384 288L544 288C561.7 288 576 302.3 576 320C576 337.7 561.7 352 544 352L384 352C366.3 352 352 337.7 352 320zM352 480C352 462.3 366.3 448 384 448L544 448C561.7 448 576 462.3 576 480C576 497.7 561.7 512 544 512L384 512C366.3 512 352 497.7 352 480z"/></svg>
						<div>
							<h3><?php esc_html_e( 'Filters', 'ajax-load-more-filters' ); ?></h3>
							<p><?php esc_html_e( 'Create custom filters by adding, removing, and reordering filter blocks.', 'ajax-load-more-filters' ); ?></p>
						</div>
					</div>
					<div class="toggle-controls">
						<button v-on:click="collapseFilters($event)" title="<?php esc_attr_e( 'Collapse Filters', 'ajax-load-more-filters' ); ?>" aria-label="<?php esc_attr_e( 'Collapse Filters', 'ajax-load-more-filters' ); ?>">
							<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 640"><path d="M300.3 440.8C312.9 451 331.4 450.3 343.1 438.6L471.1 310.6C480.3 301.4 483 287.7 478 275.7C473 263.7 461.4 256 448.5 256L192.5 256C179.6 256 167.9 263.8 162.9 275.8C157.9 287.8 160.7 301.5 169.9 310.6L297.9 438.6L300.3 440.8z"/></svg>
						</button>
						<button v-on:click="expandFilters($event)"  title="<?php esc_attr_e( 'Expand Filters', 'ajax-load-more-filters' ); ?>" aria-label="<?php esc_attr_e( 'Expand Filters', 'ajax-load-more-filters' ); ?>">
							<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 640"><path d="M300.3 440.8C312.9 451 331.4 450.3 343.1 438.6L471.1 310.6C480.3 301.4 483 287.7 478 275.7C473 263.7 461.4 256 448.5 256L192.5 256C179.6 256 167.9 263.8 162.9 275.8C157.9 287.8 160.7 301.5 169.9 310.6L297.9 438.6L300.3 440.8z"/></svg>
						</button>
					</div>
				</header>

				<!-- Vue Template -->
				<section class="alm-filter--filters">
					<draggable v-model="filters" @end="onEnd" :options="{animation:250, handle:'.alm-drag'}">
						<filter-template @add-filter="addFilter" v-for="(filter, index) in filters" :key="filter.uniqueid" :data-filter="index" :keys="keys" :field_types="field_types" :taxonomy_operators="taxonomy_operators" :taxonomy_include_children="taxonomy_include_children" :meta_types="meta_types" :meta_operators="meta_operators" :filters="filters" :filter="filter" :index="index"></filter-template>
					</draggable>
				</section>

				<!-- Add Filter -->
				<section class="alm-filter--add">
					<button type="button" v-on:click="addFilter($event)" class="button add-filter">
						<?php esc_html_e( 'Add Filter', 'ajax-load-more-filters' ); ?>
					</button>
				</section>

				<!-- Filter Actions -->
				<section class="alm-filter--actions">
					<div>
						<button type="button" v-on:click="saveFilter($event)" data-baseurl="<?php echo ALM_FILTERS_BASE_URL; ?>" class="buttom button-large button-primary save-filter" :disabled="isEmpty()">
						<?php
						if ( ! $editing ) {
							?>
							{{ create_btn_text }}
							<?php
						} else {
							?>
							{{ update_btn_text }}<?php } ?>
						</button>
						<div class="saving-filter"></div>
					</div>

					<?php
					if ( isset( $filter['date_created'] ) || isset( $filter['date_created'] ) ) {
						echo '<div class="alm-filter--meta">';
						if ( isset( $filter['date_created'] ) ) {
							echo '<div class="col">';
								echo esc_attr__( 'Published', 'ajax-load-more-filters' ) . ': <span>' . wp_kses_post( gmdate( 'Y/m/d h:i:s a', $filter['date_created'] ) ) . '</span>';
							echo '</div>';
						}
						if ( isset( $filter['date_created'] ) ) {
							echo '<div class="col">';
								echo esc_attr__( 'Modified', 'ajax-load-more-filters' ) . ': <span>' . wp_kses_post( gmdate( 'Y/m/d h:i:s a', $filter['date_modified'] ) ) . '</span>';
							echo '</div>';
						}
						echo '</div>';
					}
					?>
				</section>
			</div>

		</div>

	</div>
	<!-- END MAIN COLUMN -->
	<?php require ALM_FILTERS_PATH . 'admin/views/includes/sidebar.php'; ?>
	<?php
	if ( $editing ) {
		include ALM_FILTERS_PATH . 'admin/views/includes/output-php.php';
	}
	?>
</div>
<!-- End #app -->
<?php require_once ALM_FILTERS_PATH . 'admin/views/includes/vue-filter-template.php'; ?>
