<?php
/**
 * The template for displaying the filters navigation.
 *
 * @package ALMFilters
 */

$nav_items = [
	[
		'url'    => ALM_FILTERS_BASE_URL,
		'icon'   => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM96 288a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm32-144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM96 400a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm96-280c-13.3 0-24 10.7-24 24s10.7 24 24 24l160 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-160 0zm0 112c-13.3 0-24 10.7-24 24s10.7 24 24 24l160 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-160 0zm0 112c-13.3 0-24 10.7-24 24s10.7 24 24 24l160 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-160 0z"/></svg>',
		'text'   => __( 'Dashboard', 'ajax-load-more-filters' ),
		'active' => $section === 'dashboard',
	],
	[
		'url'    => ALM_FILTERS_BASE_URL . '&action=new',
		'icon'   => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M58.9 314.6c-10.7 10.7-18.5 24.1-22.6 38.7L.9 481c-2.3 8.3 0 17.3 6.2 23.4s15.1 8.5 23.4 6.2l127.8-35.5c14.6-4.1 27.9-11.8 38.7-22.6L378.1 271.3 412 237.4c-16.6-16.6-51.3-51.3-104-104l-33.9-33.9-33.9 33.9-181.2 181.2zm23.7 51.5c.3-1.1 .7-2.2 1.1-3.3l17.3-6.9c5.3-2.1 11 1.8 11 7.4l0 20.2c0 8.8 7.2 16 16 16l20.2 0c5.7 0 9.5 5.7 7.4 11l-6.9 17.3c-1.1 .4-2.2 .8-3.3 1.1l-86.9 24.1 24.1-86.9zM479.9 169.5l10.9-10.9C504.4 145 512 126.6 512 107.4s-7.6-37.6-21.2-51.1L455.1 20.6C441.6 7 423.2-.6 404-.6S366.4 7 352.9 20.6c-3.5 3.5-18.4 18.4-44.9 44.9 16.6 16.6 51.3 51.3 104 104l33.9 33.9 33.9-33.9zM280 464c-13.3 0-24 10.7-24 24s10.7 24 24 24l272 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-272 0z"/></svg>',
		'text'   => __( 'Add New', 'ajax-load-more-filters' ),
		'active' => $section === 'new',
	],
	[
		'url'    => ALM_FILTERS_BASE_URL . '&action=tools',
		'icon'   => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M509.4 98.6c7.6-7.6 20.3-5.7 24.1 4.3 6.8 17.7 10.5 37 10.5 57.1 0 88.4-71.6 160-160 160-17.5 0-34.4-2.8-50.2-8L146.9 498.9c-28.1 28.1-73.7 28.1-101.8 0s-28.1-73.7 0-101.8L232 210.2c-5.2-15.8-8-32.6-8-50.2 0-88.4 71.6-160 160-160 20.1 0 39.4 3.7 57.1 10.5 10 3.8 11.8 16.5 4.3 24.1l-88.7 88.7c-3 3-4.7 7.1-4.7 11.3l0 41.4c0 8.8 7.2 16 16 16l41.4 0c4.2 0 8.3-1.7 11.3-4.7l88.7-88.7z"/></svg>',
		'text'   => __( 'Tools', 'ajax-load-more-filters' ),
		'active' => $section === 'tools',
	],
];
?>
<ul class="alm-toggle-switch">
	<?php
	foreach ( $nav_items as $item ) {
		$active_class = $item['active'] ? ' class="active"' : '';
		?>
		<li>
			<a href="<?php echo esc_url( $item['url'] ); ?>"<?php echo $active_class; ?>>
				<?php echo $item['icon']; ?>
				<span><?php echo esc_html( $item['text'] ); ?></span>
			</a>
		</li>
		<?php
	}
	?>
</ul>
