function convertToDecimal(odds, format) {
    if (format === 'decimal') {
        return parseFloat(odds);
    } else if (format === 'american') {
        let o = parseFloat(odds);
        return o > 0 ? (o / 100) + 1 : (100 / Math.abs(o)) + 1;
    } else if (format === 'fractional') {
        let parts = odds.split('/');
        return (parseFloat(parts[0]) / parseFloat(parts[1])) + 1;
    }
    return 0;
}

function toggleOutcome3(show) {
    document.getElementById('outcome3-row').style.display = show ? 'block' : 'none';
}

function calculateArbitrage() {
    let odds1 = convertToDecimal(document.getElementById('odds1').value, document.getElementById('format1').value);
    let odds2 = convertToDecimal(document.getElementById('odds2').value, document.getElementById('format2').value);
    let stake = parseFloat(document.getElementById('stake').value);
    let roiThreshold = parseFloat(document.getElementById('roi_threshold').value);
    let isThreeWay = document.getElementById('toggle_3way').checked;

    let inv1 = 1 / odds1;
    let inv2 = 1 / odds2;
    let sumInv = inv1 + inv2;

    let odds3, inv3, bet3 = 0;
    if (isThreeWay) {
        odds3 = convertToDecimal(document.getElementById('odds3').value, document.getElementById('format3').value);
        inv3 = 1 / odds3;
        sumInv += inv3;
    }

    let resultDiv = document.getElementById('arb-result');
    resultDiv.innerHTML = "";

    if (sumInv < 1) {
        let bet1 = stake * (inv1 / sumInv);
        let bet2 = stake * (inv2 / sumInv);
        let profit = (stake / sumInv) - stake;
        let roi = (profit / stake) * 100;

        let resultHTML = `<p class='arb-success'>✅ Arbitrage Opportunity Found!</p>
            <p>Bet $${bet1.toFixed(2)} on Outcome 1</p>
            <p>Bet $${bet2.toFixed(2)} on Outcome 2</p>`;

        if (isThreeWay) {
            bet3 = stake * (inv3 / sumInv);
            resultHTML += `<p>Bet $${bet3.toFixed(2)} on Outcome 3</p>`;
        }

        resultHTML += `<p>Guaranteed Profit: $${profit.toFixed(2)} (${roi.toFixed(2)}% ROI)</p>`;

        if (roi < roiThreshold) {
            resultHTML += `<p class='arb-warning'>⚠️ ROI ${roi.toFixed(2)}% is below your threshold (${roiThreshold}%)</p>`;
        }

        resultDiv.innerHTML = resultHTML;
    } else {
        resultDiv.innerHTML = "<p class='arb-error'>❌ No arbitrage opportunity found.</p>";
    }
}
