<?php
/**
 * Plugin Name: Arbitrage Calculator
 * Description: A simple arbitrage betting calculator with 2-way and 3-way outcomes, odds format conversion, and ROI threshold.
 * Version: 1.4
 * Author: Paul & ChatGPT
 */

add_shortcode('arb_calculator', 'arb_calculator_shortcode');
add_action('wp_enqueue_scripts', 'arb_calculator_enqueue_scripts');

function arb_calculator_enqueue_scripts() {
    wp_enqueue_script('arb-calculator-js', plugins_url('calculator.js', __FILE__), array('jquery'), null, true);
    wp_enqueue_style('arb-calculator-css', plugins_url('style.css', __FILE__));
}

function arb_calculator_shortcode() {
    ob_start(); ?>
    <div id="arb-calculator-wrapper">
        <div id="arb-calculator">
            <h3>Arbitrage Betting Calculator</h3>
            <div class="arb-row">
                <label>Enable 3-Way Outcome: <input type="checkbox" id="toggle_3way" onchange="toggleOutcome3(this.checked)"></label>
            </div>
            <div class="arb-row">
                <label>Outcome 1 Odds:</label>
                <input type="text" id="odds1" />
                <select id="format1">
                    <option value="decimal">Decimal</option>
                    <option value="american">American</option>
                    <option value="fractional">Fractional</option>
                </select>
            </div>
            <div class="arb-row">
                <label>Outcome 2 Odds:</label>
                <input type="text" id="odds2" />
                <select id="format2">
                    <option value="decimal">Decimal</option>
                    <option value="american">American</option>
                    <option value="fractional">Fractional</option>
                </select>
            </div>
            <div class="arb-row" id="outcome3-row" style="display:none;">
                <label>Outcome 3 Odds:</label>
                <input type="text" id="odds3" />
                <select id="format3">
                    <option value="decimal">Decimal</option>
                    <option value="american">American</option>
                    <option value="fractional">Fractional</option>
                </select>
            </div>
            <div class="arb-row">
                <label>Total Stake:</label>
                <input type="number" id="stake" />
            </div>
            <div class="arb-row">
                <label>Minimum ROI %:</label>
                <input type="number" id="roi_threshold" value="1.5" />
            </div>
            <button class="arb-calc-btn" onclick="calculateArbitrage()">Calculate</button>
            <div id="arb-result"></div>
        </div>
    </div>
    <?php
    return ob_get_clean();
}
