<?php
/**
 * Plugin Name: BetPersona AI Promo Bubble
 * Description: Sticky chat bubble with timed, dismissible promo popup (“Meet Our New AI Handicappers”).
 * Version:     1.2.7
 * Author:      Full Throttle Media LLC
 * License:     GPL‑2.0+
 * Text Domain: bpai-bubble
 */

if ( ! defined( 'ABSPATH' ) ) { exit; }

function bpai_bubble_enqueue_assets() {

        $css = "
/* Chat bubble ------------------------------------------------------ */
.bpai-bubble{
        position:fixed; bottom:20px; right:20px;
        width:56px; height:56px; background:#1e1e1e;
        border-radius:50%; display:flex; align-items:center; justify-content:center;
        box-shadow:0 4px 12px rgba(0,0,0,.35);
        cursor:pointer; z-index:9999; transition:transform .2s ease;
        animation:bpai-pulse 10s ease-in-out infinite;
}
.bpai-bubble:hover{transform:scale(1.05);}
.bpai-bubble svg{width:28px; height:28px; fill:#fff;}

.bpai-bubble .bpai-tooltip{
        position:absolute; right:70px; bottom:50%; transform:translateY(50%);
        background:#000; color:#fff; font-size:14px; padding:6px 8px;
        border-radius:4px; white-space:nowrap; opacity:0; visibility:hidden;
        transition:opacity .2s ease;
}
.bpai-bubble:hover .bpai-tooltip,
.bpai-bubble:focus .bpai-tooltip{opacity:1; visibility:visible;}
@media(max-width:600px){.bpai-bubble .bpai-tooltip{display:none;}}
.bpai-bubble.bpai-no-tooltip .bpai-tooltip{display:none;}

@keyframes bpai-pulse{0%,80%{transform:scale(1);}90%{transform:scale(1.15);}100%{transform:scale(1);}}

/* Timed promo box -------------------------------------------------- */
.bpai-popup{
        position:fixed; right:95px; bottom:20px; max-width:260px;
        background:#000; color:#fff; font-size:14px;
        padding:14px 54px 14px 18px;        /* 54 px right pad = text never under × */
        border-radius:6px; box-shadow:0 4px 12px rgba(0,0,0,.35);
        cursor:pointer; opacity:0; visibility:hidden;
        transition:opacity .25s ease; z-index:9998;
}
.bpai-popup.bpai-show{opacity:1; visibility:visible;}

/* Close button – final fix ---------------------------------------- */
.bpai-close-btn{
        position:absolute; top:-10px; right:-10px;
        width:24px; height:24px;
        box-sizing:border-box; padding:0;
        border:none; border-radius:50%;
        background:#ff3b3b; color:#fff;
        font-size:18px; font-weight:bold; line-height:1;
        display:flex; align-items:center; justify-content:center;
        cursor:pointer;
}

/* Mobile tweaks ---------------------------------------------------- */
@media(max-width:600px){
        .bpai-bubble{width:50px; height:50px; bottom:15px; right:15px;}
        .bpai-popup{right:80px; bottom:15px;}
}";

        wp_register_style( 'bpai-bubble-style', false, [], null );
        wp_enqueue_style( 'bpai-bubble-style' );
        wp_add_inline_style( 'bpai-bubble-style', $css );

        /* ----------  JS (unchanged) ---------- */
        $js = "
(function(){
        var popup  = document.querySelector('.bpai-popup');
        var bubble = document.querySelector('.bpai-bubble');
        if(!popup || !bubble) return;

        if(!sessionStorage.getItem('bpaiBubbleDismissed')){
                setTimeout(function(){
                        popup.classList.add('bpai-show');
                        bubble.classList.add('bpai-no-tooltip');
                }, 3000);
        }

        popup.addEventListener('click', function(e){
                if(e.target.closest('.bpai-close-btn')){
                        popup.classList.remove('bpai-show');
                        bubble.classList.remove('bpai-no-tooltip');
                        sessionStorage.setItem('bpaiBubbleDismissed','1');
                        e.stopPropagation();
                        return;
                }
                window.open('https://betpersona-ai.gr-site.com/','_blank','noopener');
        });
})();";

        wp_register_script( 'bpai-bubble-js', false, [], null, true );
        wp_enqueue_script( 'bpai-bubble-js' );
        wp_add_inline_script( 'bpai-bubble-js', $js );
}
add_action( 'wp_enqueue_scripts', 'bpai_bubble_enqueue_assets' );

/* ------------------------------------------------------------------ */
function bpai_bubble_render() { ?>
        <a href="https://betpersona-ai.gr-site.com/" class="bpai-bubble"
           target="_blank" rel="noopener noreferrer"
           aria-label="Meet Our New AI Handicappers">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" aria-hidden="true" focusable="false">
                        <path d="M4 2h16a2 2 0 012 2v14a2 2 0 01-2 2H7l-5 4V4a2 2 0 012-2z"/>
                </svg>
                <span class="bpai-tooltip">Shhh… The Future of Handicapping Just Arrived"</span>
        </a>

        <div class="bpai-popup" role="dialog" aria-live="polite">
                Shhh… The Future of Handicapping Just Arrived"
                <button class="bpai-close-btn" aria-label="Dismiss">&times;</button>
        </div>
<?php }
add_action( 'wp_footer', 'bpai_bubble_render' );
