
<?php
require_once __DIR__ . '/vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

$personality = $_GET['personality'] ?? 'A';

$templates = [
  'A' => 'analyst-report-template-clean.html',
  'B' => 'the-analyst-report-template-clean.html',
  'C' => 'the-risk-taker-report-template-clean.html',
  'D' => 'the-grinder-report-template-clean.html',
  'E' => 'the-gut-player-report-template-clean.html'
];

$templateFile = __DIR__ . '/' . ($templates[$personality] ?? $templates['A']);

if (!file_exists($templateFile)) {
  die("Template not found.");
}

$html = file_get_contents($templateFile);

$options = new Options();
$options->set('isRemoteEnabled', true);

$dompdf = new Dompdf($options);
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();

$filename = 'betting-style-report.pdf';
$dompdf->stream($filename, ["Attachment" => false]);
exit;
?>
