<?php
if (!function_exists('themeSetup')) {
    /**
     * Sets up theme defaults and registers support for various WordPress features.
     *
     * Note that this function is hooked into the after_setup_theme hook, which
     * runs before the init hook. The init hook is too late for some features, such
     * as indicating support for post thumbnails.
     */

    function themeSetup()
    {
        /*
         * Make theme available for translation.
         * Translations can be filed in the /languages/ directory.
         * If you're building a theme based on test, use a find and replace
         * to change 'test' to the name of your theme in all the template files.
         */
        load_theme_textdomain('ftm_base', get_template_directory() . '/languages');

        // Add default posts and comments RSS feed links to head.
        //add_theme_support('automatic-feed-links');

        /*
         * Let WordPress manage the document title.
         * By adding theme support, we declare that this theme does not use a
         * hard-coded <title> tag in the document head, and expect WordPress to
         * provide it for us.
         */
        add_theme_support('title-tag');

        /*
         * Enable support for Post Thumbnails on posts and pages.
         *
         * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
         */
        add_theme_support('post-thumbnails');

        //NEED TO BE CUSTOMIZED
        /*
            add_image_size('large', 700, '', true); // Large Thumbnail
            add_image_size('medium', 250, '', true); // Medium Thumbnail
            add_image_size('small', 120, '', true); // Small Thumbnail
            add_image_size('custom-size', 700, 200, true); // Custom Thumbnail Size call using the_post_thumbnail('custom-size');
        */

        //MENUS
        register_nav_menus(
            array(
                'main-menu' => __('Main Menu', 'ftm_base'),
                'secondary-menu' => __('Secondary Menu', 'ftm_base')
            )
        );

        /*
         * Switch default core markup for search form, comment form, and comments
         * to output valid HTML5.
         */
        add_theme_support('html5', array(
            'search-form',
            'comment-form',
            'comment-list',
            'gallery',
            'caption',
        ));

        // Set up the WordPress core custom background feature.
        add_theme_support('custom-background', apply_filters('test_custom_background_args', array(
            'default-color' => 'ffffff',
            'default-image' => '',
        )));

        // Add theme support for selective refresh for widgets.
        add_theme_support('customize-selective-refresh-widgets');

        /**
         * Add support for core custom logo.
         *
         * @link https://codex.wordpress.org/Theme_Logo
         */

        //NEED TO BE CUSTOMIZED
        add_theme_support('custom-logo', array(
            'height' => 250,
            'width' => 250,
            'flex-width' => true,
            'flex-height' => true,
        ));

    }//end of themeSetup function

} //end of if

add_action('after_setup_theme', 'themeSetup');

function webpack($file, $buildDirectory = 'dist'){
    static $manifest;
    static $manifestPath;

    if (is_null($manifest) || $manifestPath !== $buildDirectory) {
        $manifest = json_decode(
            file_get_contents(get_template_directory_uri() . "/" . $buildDirectory . '/manifest.json'),
            true
        );

        $manifestPath = $buildDirectory;
    }

    if (isset($manifest[$file])) {
        return get_template_directory_uri() . "/" . trim($buildDirectory . '/' . $manifest[$file], '/');
    }

    throw new InvalidArgumentException("File {$file} not defined in asset manifest.");
}

add_action('wp_enqueue_scripts', 'ftm_base_add_css');

function ftm_base_add_css(){

    wp_enqueue_style('ftm-base', webpack('ftm_base.css'), array(), "1.0.0");

}