<?php

if (!function_exists('themeSetup')) {
    /**
     * Sets up theme defaults and registers support for various WordPress features.
     *
     * Note that this function is hooked into the after_setup_theme hook, which
     * runs before the init hook. The init hook is too late for some features, such
     * as indicating support for post thumbnails.
     */

    function themeSetup()
    {
        /*
         * Make theme available for translation.
         * Translations can be filed in the /languages/ directory.
         * If you're building a theme based on test, use a find and replace
         * to change 'test' to the name of your theme in all the template files.
         */
        load_theme_textdomain('ftm_base', get_template_directory() . '/languages');

        // Add default posts and comments RSS feed links to head.
        //add_theme_support('automatic-feed-links');

        /*
         * Let WordPress manage the document title.
         * By adding theme support, we declare that this theme does not use a
         * hard-coded <title> tag in the document head, and expect WordPress to
         * provide it for us.
         */
        add_theme_support('title-tag');

        /*
         * Enable support for Post Thumbnails on posts and pages.
         *
         * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
         */
        add_theme_support('post-thumbnails');

        //NEED TO BE CUSTOMIZED
        /*
            add_image_size('large', 700, '', true); // Large Thumbnail
            add_image_size('medium', 250, '', true); // Medium Thumbnail
            add_image_size('small', 120, '', true); // Small Thumbnail
            add_image_size('custom-size', 700, 200, true); // Custom Thumbnail Size call using the_post_thumbnail('custom-size');
        */

        //MENUS
        register_nav_menus(
            array(
                'main-menu' => __('Main Menu', 'ftm_base'),
                'secondary-menu' => __('Secondary Menu', 'ftm_base')
            )
        );

        //SIDEBARS
        register_sidebar(
            array(
                'name' => 'Right Sidebar',
                'id'   => 'right-sidebar'
            )
        );

        /*
         * Switch default core markup for search form, comment form, and comments
         * to output valid HTML5.
         */
        add_theme_support('html5', array(
            'search-form',
            'comment-form',
            'comment-list',
            'gallery',
            'caption',
        ));

        // Set up the WordPress core custom background feature.
        add_theme_support('custom-background', apply_filters('test_custom_background_args', array(
            'default-color' => 'ffffff',
            'default-image' => '',
        )));

        // Add theme support for selective refresh for widgets.
        add_theme_support('customize-selective-refresh-widgets');

        /**
         * Add support for core custom logo.
         *
         * @link https://codex.wordpress.org/Theme_Logo
         */

        //NEED TO BE CUSTOMIZED
        add_theme_support('custom-logo', array(
            'height' => 250,
            'width' => 250,
            'flex-width' => true,
            'flex-height' => true,
        ));
    } //end of themeSetup function

} //end of if

add_action('after_setup_theme', 'themeSetup');

add_action('wp_enqueue_scripts', 'ftm_base_add_css');
add_action('wp_enqueue_scripts', 'ftm_base_add_js');

function ftm_base_add_css()
{
    wp_enqueue_style('ftm-base-variables', FTM_BASE_CSS_CUSTOMIZER_FILE_URI, array(), "1.0.0");
    wp_enqueue_style('ftm-base-css', webpack('ftm_base.css'), array(), "1.0.0");
    if( is_singular( 'reviews' )){
        wp_enqueue_style('ftm-swiper-css',  get_stylesheet_directory_uri() . '/assets/sass/swiper.css', array(), "1.0.0");
    }    
}

function ftm_base_add_js(){

    if( is_singular( 'reviews' )){
        wp_enqueue_script('ftm-swiper-js', get_stylesheet_directory_uri() . '/assets/js/swiper.js' , array(), "1.0.0", true );    
    }
    wp_enqueue_script('ftm-base-js', webpack('ftm_base.js'), array(), "1.0.0", true );    
    wp_localize_script('ftm-base-js', 'pw_script_vars', array(
        'ajaxurl' => admin_url('admin-ajax.php'),    
       )
   );
}

//SETUP CUSTOM POSTS TYPES
function create_reviews_post_type() {
    // Check if the customizer variable 'ftm-site-has-reviews' is set to true
    $site_has_reviews = get_theme_mod('ftm-site-has-reviews', false);

    if ($site_has_reviews) {
        register_post_type('reviews',
            array(
                'labels' => array(
                    'name' => __('Reviews'),
                    'singular_name' => __('Review'),
                ),
                'public' => true,
                'has_archive' => false,
                'rewrite' => array('slug' => 'review'),
                'supports' => array('title', 'editor', 'thumbnail', 'custom-fields', 'page-attributes','revisions'),
                'menu_icon' => 'dashicons-star-half', 
                'show_in_rest' => true
            )
        );    

        //Then add the necesary ACF fields group to act on the Reviews custom post type just created
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_652429296bf0d',
                'title' => 'FTM Reviews Fields',
                'fields' => array(
                    array(
                        'key' => 'field_652433d02d465',
                        'label' => 'Site Name',
                        'name' => 'site_name',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_6524299956e7d',
                        'label' => 'Site Logo',
                        'name' => 'site_logo_url',
                        'type' => 'image',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'return_format' => 'url',
                        'library' => 'all',
                        'min_width' => '',
                        'min_height' => '',
                        'min_size' => '',
                        'max_width' => '',
                        'max_height' => '',
                        'max_size' => '',
                        'mime_types' => '',
                        'preview_size' => 'thumbnail',
                    ),
                    array(
                        'key' => 'field_65242a0e56e7e',
                        'label' => 'Site Welcome Bonus',
                        'name' => 'site_welcome_bonus',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_65242e1156e7f',
                        'label' => 'Site Bonus Code',
                        'name' => 'site_bonus_code',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_6524302256e80',
                        'label' => 'Site Rating',
                        'name' => 'site_rating',
                        'type' => 'number',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '3.5',
                        'min' => 0,
                        'max' => 5,
                        'placeholder' => '',
                        'step' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_6524292956e7c',
                        'label' => 'Review Top Content',
                        'name' => 'review_top_content',
                        'type' => 'wysiwyg',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'delay' => 0,
                        'tabs' => 'all',
                        'toolbar' => 'full',
                        'media_upload' => 1,
                    ),
                    array(
                        'key' => 'field_6524341ddd93f',
                        'label' => 'Site Key Features',
                        'name' => 'site_key_features',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'row',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_65243436dd940',
                                'label' => 'Key Feature Name',
                                'name' => 'key_feature_name',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_6524341ddd93f',
                            ),
                            array(
                                'key' => 'field_65243451dd941',
                                'label' => 'Key Feature Value',
                                'name' => 'key_feature_value',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_6524341ddd93f',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_652cf5ff18713',
                        'label' => 'Site Gallery',
                        'name' => 'site_gallery',
                        'type' => 'gallery',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'return_format' => 'array',
                        'library' => 'all',
                        'min' => '',
                        'max' => '',
                        'min_width' => '',
                        'min_height' => '',
                        'min_size' => '',
                        'max_width' => '',
                        'max_height' => '',
                        'max_size' => '',
                        'mime_types' => '',
                        'insert' => 'append',
                        'preview_size' => 'medium',
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'post_type',
                            'operator' => '==',
                            'value' => 'reviews',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'acf_after_title',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
                'show_in_rest' => 0,
            ));
            
        endif;		
    }
}
add_action('init', 'create_reviews_post_type');


//SETUP CUSTOM FIELDS AND GROUPS
//Add Default ACF groups and fields necessary for the theme from the get-go
if( function_exists('acf_add_local_field_group') ):

    acf_add_local_field_group(array(
        'key' => 'group_650121c094d8b',
        'title' => 'FTM Base Blog Posts',
        'fields' => array(
            array(
                'key' => 'field_650121c246476',
                'label' => 'Most Popular',
                'name' => 'most_popular',
                'type' => 'true_false',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'message' => 'If selected, this post might show up on the top 3 most popular posts on the blog hub template',
                'default_value' => 0,
                'ui_on_text' => '',
                'ui_off_text' => '',
                'ui' => 0,
            ),
        ),
        'location' => array(
            array(
                array(
                    'param' => 'post_type',
                    'operator' => '==',
                    'value' => 'post',
                ),
            ),
        ),
        'menu_order' => 0,
        'position' => 'normal',
        'style' => 'default',
        'label_placement' => 'top',
        'instruction_placement' => 'label',
        'hide_on_screen' => '',
        'active' => true,
        'description' => '',
        'show_in_rest' => 0,
    ));

    acf_add_local_field_group(array(
        'key' => 'group_6511de1e3c7a8',
        'title' => 'FTM Blog Hub Settings',
        'fields' => array(
            array(
                'key' => 'field_6511de1e18e2a',
                'label' => 'Most Popular Title',
                'name' => 'most_popular_title',
                'type' => 'text',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'default_value' => 'Most popular',
                'maxlength' => '',
                'placeholder' => '',
                'prepend' => '',
                'append' => '',
            ),
            array(
                'key' => 'field_6511de5818e2b',
                'label' => 'Latest Blogs Title',
                'name' => 'latest_blogs_title',
                'type' => 'text',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'default_value' => 'Latest',
                'maxlength' => '',
                'placeholder' => '',
                'prepend' => '',
                'append' => '',
            ),
        ),
        'location' => array(
            array(
                array(
                    'param' => 'page_template',
                    'operator' => '==',
                    'value' => 'templates/blog-home.php',
                ),
                array(
                    'param' => 'post_template',
                    'operator' => '==',
                    'value' => 'templates/blog-home.php',
                ),
            ),
        ),
        'menu_order' => 0,
        'position' => 'normal',
        'style' => 'default',
        'label_placement' => 'top',
        'instruction_placement' => 'label',
        'hide_on_screen' => '',
        'active' => true,
        'description' => '',
        'show_in_rest' => 0,
    ));

endif;			