<?php
/**
 * Template Name: Blog Hub Home
 *
 * @package WordPress
 * @subpackage FTM Base
 * @since FTM Base 1.0.1
 */

	$show_sidebar  = false;
	$wrapper_class = 'ftm_blog_hub_content_wrapper';
	$most_popular_title = "Most Popular";
	$latest_posts_title = "Latest";
	get_header();
?>

	<?php do_action('ftm_before_content_hook'); ?>
	<div class="<?php echo $wrapper_class; ?> ftm_blog_content_wrapper">
		<div class="content_panel">
			<?php if ( have_posts() ) : while ( have_posts() ) : the_post();
			
			//Set title values if set
			if(get_post_meta(get_the_ID(), 'most_popular_title', true)){
				$most_popular_title = get_post_meta(get_the_ID(), 'most_popular_title', true);
			}

			if(get_post_meta(get_the_ID(), 'latest_blogs_title', true)){
				$latest_posts_title = get_post_meta(get_the_ID(), 'latest_blogs_title', true);
			}


			echo "<h1>" . get_the_title() . "</h1>";
			the_content();
			
			endwhile; ?>

			<div class="top_posts">
				<?php endif; 			
				//TOP STORIES SECTION
				// Query the first five blog posts ordered by date
				$args = array(
					'post_type'      => 'post',
					'posts_per_page' => 5,
					'orderby'        => 'date',
					'order'          => 'DESC',
					'post_status'	 => 'publish',
				);

				$query = new WP_Query($args);
				$count = 0;

				if ($query->have_posts()) :
					while ($query->have_posts()) : $query->the_post();		
					$count++;		
				?>
						<article <?php if( $count == 1) : echo ' class="main-post" '; endif; ?>>
							<?php if (has_post_thumbnail()) : ?>
								<div class="post-thumbnail">
									<a href="<?php the_permalink(); ?>">
									<?php if( $count == 1) : //First Post Only?>
										<?php the_post_thumbnail('full'); ?>
									<?php else: ?>
										<?php the_post_thumbnail('medium'); ?>
									<?php endif; ?>			
									</a>
								</div>
							<?php endif; ?>
							<div class="article-info">
								<h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
								<?php if( $count == 1) : //First Post Only?>
									<div class="post_excerpt">
										<?php echo ftm_get_text_excerpt(get_the_content(),40) ; ?>
									</div>
								<?php endif; ?>
								<div class="post_meta">
									<span class="author">By: <?php echo get_the_author_meta( 'nicename'); ?> | </span>
									<span class="post-date"><?php echo get_the_modified_date(); ?></span>
								</div>
							</div>
						</article>
				<?php
					endwhile;
					wp_reset_postdata();
				endif;			
				?>
			</div>

			<div class="most_popular">
				<h2><?php echo $most_popular_title; ?></h2>
				<div class="posts_wrapper">
					<?php	
					$args = array(
						'post_type'      => 'post',
						'posts_per_page' => 3,
						'meta_key'       => 'most_popular', // Custom field name
						'meta_value'     => true,           // Custom field value
						'orderby'        => 'date',
						'order'          => 'DESC',
						'post_status'	 => 'publish',
					);

					$query = new WP_Query($args);

					if ($query->have_posts()) :
						while ($query->have_posts()) : $query->the_post();
					?>
							<article>
								<?php if (has_post_thumbnail()) : ?>
									<div class="post-thumbnail">
										<a href="<?php the_permalink(); ?>">
											<?php the_post_thumbnail('medium'); ?>
										</a>
									</div>
								<?php endif; ?>

								<div class="post-info">
									<h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
									<div class="post_meta">
										<span class="post-date"><?php echo get_the_modified_date(); ?></span>
										<span class="post-time-to-read"><?php echo ftm_get_estimated_time_to_read(get_the_content()); ?></span>
									</div>
								</div>
							</article>
					<?php
						endwhile;
						wp_reset_postdata();
					endif;
					?>
				</div>
			</div>

			<div class="latest" id="latest_post_wrapper">
			<h2><?php echo $latest_posts_title; ?></h2>
				<?php
					$initial_latest_posts_offset = 5;
					$args = array(
						'post_type'      => 'post',
						'post_status'	 => 'publish',
						'posts_per_page' => 9,
						'orderby'        => 'date',
						'order'          => 'DESC',
						'offset'         => $initial_latest_posts_offset, // Skip the first five posts
					);

					$query = new WP_Query($args);

					if($query->found_posts < $initial_latest_posts_offset){
						$initial_latest_posts_offset = $query->found_posts;
					}
					
					if ($query->have_posts()) :
						while ($query->have_posts()) : $query->the_post();
					?>
							<article>
								<?php if (has_post_thumbnail()) : ?>
									<div class="post-thumbnail">
										<a href="<?php the_permalink(); ?>">
											<?php the_post_thumbnail('medium'); ?>
											<div class="post_meta">
												<span class="author">By: <?php echo get_the_author_meta( 'nicename'); ?>&nbsp;|&nbsp;</span>
												<span class="post-date"><?php echo get_the_modified_date(); ?></span>
											</div>
										</a>
									</div>
								<?php endif; ?>

								<h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
								<div class="post_excerpt">
									<?php echo ftm_get_text_excerpt(get_the_content(),25) ; ?>
								</div>
								
							</article>
					<?php
						endwhile;
						wp_reset_postdata();
					endif;
				?>
			</div>
			<input id="latest_posts_offset" name="latest_posts_offset" value="<?php echo $initial_latest_posts_offset; ?>" type="hidden" />
			<div class="ftm_load_more"><div></div><div></div><div></div></div>			
		</div>
	</div>		
<?php get_footer(); ?>