<?php

	$show_sidebar  = false;
	$wrapper_class = 'ftm_blog_content_wrapper';
	if ( is_post_type_archive() ){
		$wrapper_class = 'ftm_archive_content_wrapper';
		$show_sidebar  = get_theme_mod('ftm_general_site_archives_show_sidebar', false);
	}
	else{
		$show_sidebar  = get_theme_mod('ftm_general_site_blog_show_sidebar', false);
	}

	if($show_sidebar){
		$wrapper_class .= ' has_sidebar';
	}

	get_header();
?>

	<?php do_action('ftm_before_content_hook'); ?>
	<div class="<?php echo $wrapper_class; ?> site_content_wrapper">
		<div class="content_panel">
			<?php if ( have_posts() ) : while ( have_posts() ) : the_post();
			echo "<h1>" . get_the_title() . "</h1>";
			the_content();
			endwhile; else: ?>
			<p>Sorry, no posts matched your criteria.</p>
			<?php endif; ?>
			<?php comments_template(); ?>
		</div>
		<?php if($show_sidebar): ?>
			<div class="sidebar_panel">
				<?php if (is_active_sidebar('right-sidebar')) {
					dynamic_sidebar('right-sidebar');
				}?>
			</div>
		<?php endif; ?>
	</div>		
<?php get_footer(); ?>