<?php
/**
 * Template Name: Site Review
 * Template Post Type: reviews
 *
 * @package WordPress
 * @subpackage FTM Base
 * @since FTM Base 1.0.1
 */

    // Get the value of the Sticky_top setting
    $sticky_top = get_theme_mod('ftm-site-reviews-sticky-top');


    $sticky_top_class = ( $sticky_top == true )? 'class="sticky"':'';
	$wrapper_class = 'ftm_review_content_wrapper';
	
	get_header();
?>

	<?php do_action('ftm_before_content_hook'); ?>
	<div class="<?php echo $wrapper_class; ?> site_content_wrapper">
		<div class="content_panel">
			<?php if ( have_posts() ) : while ( have_posts() ) : the_post();
			
                //VARIABLES SET
                $site_name_value    = get_post_meta(get_the_ID(), 'site_name', true);
                $site_logo_value    = get_field('site_logo_url');
                $site_welcome_bonus = get_field('site_welcome_bonus');
                $site_bonus_code    = get_field('site_bonus_code');
                $site_rating        = get_field('site_rating');


                //Set title values if set			
                echo "<h1>" . get_the_title() . "</h1>";

                //TOP REVIEWS BAR
                ?>
                <div id="ftm-reviews-top-bar" <?php echo $sticky_top_class ?>>
                    <div class="site-logo">
                        <?php                      
                        if(!empty($site_logo_value)){
                            echo '<img src="' . esc_url($site_logo_value) . '" alt="' . $site_name_value . '" />';
                        }
                        ?>
                    </div>
                    <div class="site-bonus">
                        <?php 
                        //Welcome Bonus if applicable
                         if(!empty($site_welcome_bonus)){
                            echo '<div class="welcome-bonus-line-one">'.$site_welcome_bonus.'</div>';
                         }


                         if(!empty($site_bonus_code)){
                            echo '<div class="welcome-bonus-line-two">'.$site_bonus_code.'</div>';
                         }                         
                        ?>
                    </div>
                    <div class="site-rating">
                        <div class="just-stars">
                            <?php                                                    
                                $rating_percentage = 0;
                                if(!empty($site_rating)){
                                    $rating_floor =  floor($site_rating);
                                    $rating_percentage = $rating_floor * 20;

                                    if($rating_floor < $site_rating){//Decimal calculation
                                        $decimnal_value = $site_rating - $rating_floor;
                                        // Define the value that represents 100% on your scale
                                        $valueFor100Percent = 20;

                                        // Map a value from 0-1 scale to a percentage
                                        $decimal_percentage = $decimnal_value * 100;

                                        // Calculate the value on the original scale
                                        $scaleValueOnOriginalScale = ($decimal_percentage / 100) * $valueFor100Percent;
                                        $rating_percentage += $scaleValueOnOriginalScale;
                                    }
                                }                                
                            ?>
                            <div class="star-rating__overlay" style="width: <?php echo $rating_percentage; ?>%"></div>
                            <div class="star-rating__underlay"></div>
                        </div>
                        <div class="text-rating"><?php echo $site_rating . ' / 5'; ?> </div>
                    </div>
                    <div class="site-button">
                        <a class="visit_button" href="">Play Now</a>
                    </div>
                </div>

                <div class="ftm-reviews-content">
                    <?php echo get_field('review_top_content'); ?>
                </div>

                <div id="ftm-reviews-second-bar">
                    <div class="left-panel">
                        <?php 
                            // Get the images from the ACF Gallery field
                            $images = get_field('site_gallery');

                            if ($images) :?>
                                <!-- Slider main container -->
                                <div class="swiper">
                                    <!-- Additional required wrapper -->
                                    <div class="swiper-wrapper">
                                        <!-- Slides -->
                                        <?php
                                            foreach ($images as $image) {
                                                echo '<div class="swiper-slide"><img src="' . esc_url($image['url']) . '" alt="' . esc_attr($image['alt']) . '" /></div>';
                                            }
                                        ?>
                                    </div>

                                    <!-- If we need navigation buttons -->
                                    <div class="swiper-button-prev"></div>
                                    <div class="swiper-button-next"></div>
                                </div>
                        
                        <?php    
                            endif;
                        ?>                        
                    </div>
                    <div class="right-panel">
                        <?php 
                            // Get the repeater field values
                            $keyFeatures = get_field('site_key_features');

                            if ($keyFeatures) {
                                echo '<div class="key-features-wrapper">';
                                echo '<table class="key-features-table">';
                                foreach ($keyFeatures as $keyFeature) {
                                    echo '<tr>';
                                    echo '<td class="key-feature-name">' . esc_html($keyFeature['key_feature_name']) . '</td>';
                                    echo '<td class="key-feature-value">' . esc_html($keyFeature['key_feature_value']) . '</td>';
                                    echo '</tr>';
                                }
                                echo '</table>';
                                echo '</div>';
                            }
                        ?>
                    </div>
                </div>

                <div class="ftm-reviews-content">
                <?php                
                    the_content();
                ?>
                </div>
                
                <?php			
			endwhile; 
            endif;
        ?>
		</div>
	</div>		
    
<?php get_footer(); ?>