console.log('global init');
window.addEventListener('DOMContentLoaded', function(){ 
    
    const menuTrigger = document.getElementById('ftm-mobile-menu-trigger');
    const siteNavigation = document.getElementById('site-navigation');
    const menuItems = document.querySelectorAll('li.menu-item.menu-item-has-children');

    // Add a click event listener to the button
    menuTrigger.addEventListener('click', () => {
      // Toggle the 'show' class on the siteNavigation element
      siteNavigation.classList.toggle('show');
      menuTrigger.classList.toggle('show');
    });

    menuItems.forEach(menuItem => {
        menuItem.addEventListener('click', (e) => {
          // Toggle the 'show' class on the corresponding submenu
          e.preventDefault();
          e.stopPropagation();
          menuItem.classList.toggle('show');
        });
      });

    try{
        MicroModal.init({
         awaitCloseAnimation: true,
         disableScroll: true,
         onClose: function(modal){
            const selectedValue = getSelectedValue();
            setCookie('currState', selectedValue);
            
            // Reload the page after setting the cookie
            location.reload();
         }
        });
       }
       catch(e){
        console.log('micromodal error: ',e);
       }
});


 // Function to set the cookie
 function setCookie(name, value) {
    document.cookie = `${encodeURIComponent(name)}=${encodeURIComponent(value)}`;
  }

  // Function to get the selected value of the select element
  function getSelectedValue() {
    const selectElement = document.getElementById('ftm-header__state');
    return selectElement.value;
  }