<?php

$upload_dir   = wp_upload_dir();

define('FTM_BASE_CSS_CUSTOMIZER_CSS_DIR', $upload_dir['basedir'] . "/ftm-base/css/");
define('FTM_BASE_CSS_CUSTOMIZER_FILE_URI', $upload_dir['baseurl'] . "/ftm-base/css/ftm_base_variables.css");
define('FTM_BASE_CSS_CUSTOMIZER_FILE_PATH', $upload_dir['basedir'] . "/ftm-base/css/ftm_base_variables.css");

// Register Features section in the Customizer
function custom_theme_customizer_features($wp_customize)
{
    // Add a new section for Features
    $wp_customize->add_section('features_section', array(
        'title' => 'Features',
        'priority' => 30,
    ));

    // Add settings and controls for each feature

    // Example feature
    $wp_customize->add_setting('feature_theme_debug', array(
        'default' => '',
        'transport' => 'refresh',
    ));
    $wp_customize->add_control('feature_theme_debug_control', array(
        'label' => 'Theme Debug',
        'section' => 'features_section',
        'settings' => 'feature_theme_debug',
        'type' => 'checkbox',
    ));
}

function ftm_customizer_footer($wp_customize)
{

    /* 
     * ==================================================
     * FOOTER PANEL START
     * ==================================================
     */
    $wp_customize->add_panel('footer_section', array(
        'title'      => __('Footer', 'ftm_base'),
        'capability'     => 'edit_theme_options',
        'priority'   => 30,
    ));

    /*
     * COLORS SECTION START
     */

    //COLOR SECTION
    $wp_customize->add_section('footer_colors_section', array(
        'title'      => __('Colors', 'ftm_base'),
        'priority'   => 30,
        'panel'      => 'footer_section',
    ));

    //COLOR SETTINGS
    $wp_customize->add_setting('footer_color_main', array(
        'default'     => '#0A152D',
        'transport'   => 'refresh',
    ));

    $wp_customize->add_setting('footer_color_secondary', array(
        'default'     => '#F8F8FC',
        'transport'   => 'refresh',
    ));

    $wp_customize->add_setting('footer_color_text', array(
        'default'     => '#ffffff',
        'transport'   => 'refresh',
    ));

    $wp_customize->add_setting('footer_color_text_hover', array(
        'default'     => '#d6d6d6',
        'transport'   => 'refresh',
    ));

    //COLOR CONTROLS
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'footer_color_main', array(
        'label'        => __('Main Footer Color', 'ftm-base'),
        'section'    => 'footer_colors_section',
        'settings'   => 'footer_color_main',
    )));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'footer_color_secondary', array(
        'label'        => __('Secondary Footer Color', 'ftm-base'),
        'section'    => 'footer_colors_section',
        'settings'   => 'footer_color_secondary',
    )));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'footer_color_text', array(
        'label'        => __('Text Color', 'ftm-base'),
        'section'    => 'footer_colors_section',
        'settings'   => 'footer_color_text',
    )));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'footer_color_text_hover', array(
        'label'        => __('Text Hover Color', 'ftm-base'),
        'section'    => 'footer_colors_section',
        'settings'   => 'footer_color_text_hover',
    )));

    /*
     * COLORS SECTION END
     */

    /*
     * SOCIAL SECTION START
     */
    $wp_customize->add_section('footer_social_section', array(
        'title'      => __('Socials', 'ftm_base'),
        'priority'   => 30,
        'panel'      => 'footer_section',
    ));

    //SOCIAL TITLE
    $wp_customize->add_setting('footer_social_title', array(
        'default' => 'Never miss a moment',
        'transport' => 'refresh',
    ));

    //TWITTER SETTINGS
    $wp_customize->add_setting('footer_social_twitter', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_social_twitter_link', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    //YOUTUBE SETTINGS
    $wp_customize->add_setting('footer_social_youtube', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_social_youtube_link', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    //INSTAGRAM SETTINGS
    $wp_customize->add_setting('footer_social_ig', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_social_ig_link', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    //FB SETTINGS
    $wp_customize->add_setting('footer_social_fb', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_social_fb_link', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    //SOCIAL TITLE CONTROL
    $wp_customize->add_control('footer_social_title_control', array(
        'label' => 'Title',
        'section' => 'footer_social_section',
        'settings' => 'footer_social_title',
        'type' => 'text',
    ));

    //TWITTER CONTROLS
    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer_social_twitter_control', array(
        'label' => 'Twitter Icon',
        'section' => 'footer_social_section',
        'settings' => 'footer_social_twitter',
    )));

    $wp_customize->add_control('footer_social_twitter_link', array(
        'label' => 'Twitter Link',
        'section' => 'footer_social_section',
        'settings' => 'footer_social_twitter_link',
        'type' => 'text',
    ));

    //YOUTUBE CONTROLS
    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer_social_youtube_control', array(
        'label' => 'Youtube Icon',
        'section' => 'footer_social_section',
        'settings' => 'footer_social_youtube',
    )));

    $wp_customize->add_control('footer_social_youtube_link', array(
        'label' => 'Youtube Link',
        'section' => 'footer_social_section',
        'settings' => 'footer_social_youtube_link',
        'type' => 'text',
    ));

    //INSTAGRAM CONTROLS
    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer_social_ig_control', array(
        'label' => 'Instagram Icon',
        'section' => 'footer_social_section',
        'settings' => 'footer_social_ig',
    )));

    $wp_customize->add_control('footer_social_ig_link', array(
        'label' => 'Instagram Link',
        'section' => 'footer_social_section',
        'settings' => 'footer_social_ig_link',
        'type' => 'text',
    ));

    //INSTAGRAM CONTROLS
    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer_social_fb_control', array(
        'label' => 'Facebook Icon',
        'section' => 'footer_social_section',
        'settings' => 'footer_social_fb',
    )));

    $wp_customize->add_control('footer_social_fb_link', array(
        'label' => 'Facebook Link',
        'section' => 'footer_social_section',
        'settings' => 'footer_social_fb_link',
        'type' => 'text',
    ));

    /*
     * SOCIAL SECTION END
     */


    /*
     * BOTTOM SECTION START
     */
    $wp_customize->add_section('footer_bottom_section', array(
        'title'      => __('Bottom', 'ftm_base'),
        'priority'   => 32,
        'panel'      => 'footer_section',
    ));

    //BOTTOM SETTINGS
    $wp_customize->add_setting('footer_bottom_title', array(
        'default' => 'GamblingSite.com is certified by:',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_bottom_logo1', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_bottom_logo2', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_bottom_logo3', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_bottom_logo4', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    //BOTTOM CONTROLS
    $wp_customize->add_control('footer_bottom_title_control', array(
        'label' => 'Bottom Title',
        'section' => 'footer_bottom_section',
        'settings' => 'footer_bottom_title',
        'type' => 'text',
    ));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer_bottom_logo1', array(
        'label' => 'Logo 1',
        'section' => 'footer_bottom_section',
        'settings' => 'footer_bottom_logo1',
    )));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer_bottom_logo2', array(
        'label' => 'Logo 2',
        'section' => 'footer_bottom_section',
        'settings' => 'footer_bottom_logo2',
    )));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer_bottom_logo3', array(
        'label' => 'Logo 3',
        'section' => 'footer_bottom_section',
        'settings' => 'footer_bottom_logo3',
    )));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer_bottom_logo4', array(
        'label' => 'Logo 4',
        'section' => 'footer_bottom_section',
        'settings' => 'footer_bottom_logo4',
    )));

    /*
     * BOTTOM SECTION END
     */

    /*
     * FEATURED SECTION START
     */
    $wp_customize->add_section('footer_featured_section', array(
        'title'      => __('Featured', 'ftm_base'),
        'priority'   => 10,
        'panel'      => 'footer_section',
    ));

    //BOTTOM SETTINGS
    $wp_customize->add_setting('footer_featured_title', array(
        'default' => 'AS FEATURED ON:',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_featured_logo1', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_featured_logo2', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_featured_logo3', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_featured_logo4', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_featured_logo5', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_featured_logo6', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    //FEATURED CONTROLS
    $wp_customize->add_control('footer_featured_title_control', array(
        'label' => 'Featured Title',
        'section' => 'footer_featured_section',
        'settings' => 'footer_featured_title',
        'type' => 'text',
    ));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer_featured_logo1', array(
        'label' => 'Logo 1',
        'section' => 'footer_featured_section',
        'settings' => 'footer_featured_logo1',
    )));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer_featured_logo2', array(
        'label' => 'Logo 2',
        'section' => 'footer_featured_section',
        'settings' => 'footer_featured_logo2',
    )));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer_featured_logo3', array(
        'label' => 'Logo 3',
        'section' => 'footer_featured_section',
        'settings' => 'footer_featured_logo3',
    )));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer_featured_logo4', array(
        'label' => 'Logo 4',
        'section' => 'footer_featured_section',
        'settings' => 'footer_featured_logo4',
    )));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer_featured_logo5', array(
        'label' => 'Logo 5',
        'section' => 'footer_featured_section',
        'settings' => 'footer_featured_logo5',
    )));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer_featured_logo6', array(
        'label' => 'Logo 6',
        'section' => 'footer_featured_section',
        'settings' => 'footer_featured_logo6',
    )));

    /*
     * FEATURED SECTION END
     */


    /*
     * MORE LOGOS SECTION START
     */
    $wp_customize->add_section('footer_more_section', array(
        'title'      => __('More Logos', 'ftm_base'),
        'priority'   => 31,
        'panel'      => 'footer_section',
    ));

    //MORE TITLE
    $wp_customize->add_setting('footer_more_title', array(
        'default' => 'We want you to play responsibly',
        'transport' => 'refresh',
    ));

    //MORE SETTINGS
    $wp_customize->add_setting('footer_more_logo1', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_more_logo1_link', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_more_logo2', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_more_logo2_link', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_more_logo3', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_more_logo3_link', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_more_logo4', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_more_logo4_link', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    //MORE CONTROLS
    $wp_customize->add_control('footer_more_title_control', array(
        'label' => 'Title',
        'section' => 'footer_more_section',
        'settings' => 'footer_more_title',
        'type' => 'text',
    ));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer_more_logo1_control', array(
        'label' => 'Logo 1',
        'section' => 'footer_more_section',
        'settings' => 'footer_more_logo1',
    )));

    $wp_customize->add_control('footer_more_logo1_link', array(
        'label' => 'Logo 1 Link',
        'section' => 'footer_more_section',
        'settings' => 'footer_more_logo1_link',
        'type' => 'text',
    ));

    //YOUTUBE CONTROLS
    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer_more_logo2_control', array(
        'label' => 'Logo 2',
        'section' => 'footer_more_section',
        'settings' => 'footer_more_logo2',
    )));

    $wp_customize->add_control('footer_more_logo2', array(
        'label' => 'Logo 2 Link',
        'section' => 'footer_more_section',
        'settings' => 'footer_more_logo2_link',
        'type' => 'text',
    ));

    //INSTAGRAM CONTROLS
    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer_more_logo3_control', array(
        'label' => 'Logo 3',
        'section' => 'footer_more_section',
        'settings' => 'footer_more_logo3',
    )));

    $wp_customize->add_control('footer_more_logo3_link', array(
        'label' => 'Logo 3 Link',
        'section' => 'footer_more_section',
        'settings' => 'footer_more_logo3_link',
        'type' => 'text',
    ));

    //INSTAGRAM CONTROLS
    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer_more_logo4_control', array(
        'label' => 'Logo 4',
        'section' => 'footer_more_section',
        'settings' => 'footer_more_logo4',
    )));

    $wp_customize->add_control('footer_more_logo4_link', array(
        'label' => 'Logo 4 Link',
        'section' => 'footer_more_section',
        'settings' => 'footer_more_logo4_link',
        'type' => 'text',
    ));

    /*
     * MORE LOGOS SECTION END
     */

    /*
     * MENUS SECTION START
     */

    $menus = get_terms('nav_menu', array('hide_empty' => true));
    $menu_choices = array();
    foreach ($menus as $menu) {
        $menu_choices[$menu->term_id] = $menu->name;
    }

    $wp_customize->add_section('footer_menu_section', array(
        'title'      => __('Menus', 'ftm_base'),
        'priority'   => 11,
        'panel'      => 'footer_section',
    ));

    $wp_customize->add_setting('menu1_setting', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('menu2_setting', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('menu3_setting', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('menu4_setting', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('menu5_setting', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'menu1_control', array(
        'label' => 'Menu 1',
        'section' => 'footer_menu_section',
        'settings' => 'menu1_setting',
        'type' => 'select',
        'choices' => $menu_choices,
    )));

    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'menu2_control', array(
        'label' => 'Menu 2',
        'section' => 'footer_menu_section',
        'settings' => 'menu2_setting',
        'type' => 'select',
        'choices' => $menu_choices,
    )));

    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'menu3_control', array(
        'label' => 'Menu 3',
        'section' => 'footer_menu_section',
        'settings' => 'menu3_setting',
        'type' => 'select',
        'choices' => $menu_choices,
    )));

    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'menu4_control', array(
        'label' => 'Menu 4',
        'section' => 'footer_menu_section',
        'settings' => 'menu4_setting',
        'type' => 'select',
        'choices' => $menu_choices,
    )));

    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'menu5_control', array(
        'label' => 'Menu 5 (Horizontal)',
        'section' => 'footer_menu_section',
        'settings' => 'menu5_setting',
        'type' => 'select',
        'choices' => $menu_choices,
    )));

    /*
     * MENUS SECTION END
     */

    /*
     * DETAILS SECTION START
     */

    $wp_customize->add_section('footer_details_section', array(
        'title'      => __('Details', 'ftm_base'),
        'priority'   => 32,
        'panel'      => 'footer_section',
    ));

    $wp_customize->add_setting('footer_email_setting', array(
        'default' => 'contact@gamblingsite.com',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_copyright_setting', array(
        'default' => '© Copyright 2023 GamblingSite.com',
        'transport' => 'refresh',
    ));

    $wp_customize->add_control('footer_email_control', array(
        'label' => 'Email',
        'section' => 'footer_details_section',
        'settings' => 'footer_email_setting',
        'type' => 'text',
    ));

    $wp_customize->add_control('footer_copyright_control', array(
        'label' => 'Email',
        'section' => 'footer_details_section',
        'settings' => 'footer_copyright_setting',
        'type' => 'text',
    ));

    /*
     * DETAILS SECTION END
     */


    /* 
     * ==================================================
     * FOOTER PANEL END
     * ==================================================
     */
}

add_action('customize_register', 'custom_theme_customizer_features');
add_action('customize_register', 'ftm_customizer_footer');

add_action('customize_save_after', 'ftm_customizer_settings');

function ftm_customizer_settings($wp_customize)
{
    //Site General Settings
    $css_variables["--body-background-color"]             = '#' . get_background_color();
    
    //Header Variables    
    $css_variables["--head-wapper-max-width"]             = get_theme_mod('ftm_head_customizer_max_width_setting', '1140') . 'px';
    $css_variables["--head-logo-max-width"]               = get_theme_mod('ftm_head_customizer_logo_max_width_setting', '150') . 'px';
    $css_variables["--sub-menu-max-width"]                =  get_theme_mod('ftm_head_customizer_sub_menu_max_width_setting', '300') . 'px';    
    $css_variables["--head-background-color"]             =  get_theme_mod('ftm_head_customizer_color_background_color_setting', '#ffffff');
    $css_variables["--head-nav-text-color"]               =  get_theme_mod('ftm_head_customizer_color_nav_text_color_setting', '#ffffff');
    $css_variables["--head-nav-hover-color"]              =  get_theme_mod('ftm_head_customizer_color_nav_text_color_hover_setting', '#ffffff');

    //First level Sub Menu
    $css_variables["--first_sub-nav-text-color"]          =  get_theme_mod('ftm_head_customizer_color_first_sub_nav_text_color_setting', '#000000');
    $css_variables["--first_sub-nav-hover-color"]         =  get_theme_mod('ftm_head_customizer_color_first_sub_nav_text_color_hover_setting', '#000000');
    $css_variables["--first_sub-nav-background-color"]    =  get_theme_mod('ftm_head_customizer_color_first_sub_nav_background_color_setting', '#ffffff');

    //Second level Sub Menu
    $css_variables["--second_sub-nav-text-color"]         =  get_theme_mod('ftm_head_customizer_color_second_sub_nav_text_color_setting', '#000000');
    $css_variables["--second_sub-nav-hover-color"]        =  get_theme_mod('ftm_head_customizer_color_second_sub_nav_text_color_hover_setting', '#000000');
    $css_variables["--second_sub-nav-background-color"]   =  get_theme_mod('ftm_head_customizer_color_second_sub_nav_background_color_setting', '#ffffff');

    //Footer variables
    $css_variables["--footer_color_main"]       = get_theme_mod('footer_color_main', '#0A152D');
    $css_variables["--footer_color_secondary"]  = get_theme_mod('footer_color_secondary', '#F8F8FC');
    $css_variables["--footer_text_color"]       = get_theme_mod('footer_color_text', '#dfddd7');
    $css_variables["--footer_text_color_hover"] = get_theme_mod('footer_color_text_hover', '#D6D6D6');

    ftm_write_css($css_variables); 
}

function custom_theme_header_customizer_features($wp_customize) {

    //Add the Head panel
    $wp_customize->add_panel('ftm_head_customizer_panel',
        array(
            'priority'    => 100,
            'title'       => __('Header', 'ftm-theme-customizer'),
            'description' => __('All header related settings', 'ftm-theme-customizer')
        )
    );
    // Add a new section for general settings
    $wp_customize->add_section('ftm_head_customizer_general_section', array(
        'title'    => 'General',
        'priority' => 1,
        'panel'    => 'ftm_head_customizer_panel'
    ));
    // Add a new section for colors
    $wp_customize->add_section('ftm_head_customizer_color_section', array(
        'title'    => 'Colors',
        'priority' => 2,
        'panel'    => 'ftm_head_customizer_panel'
    ));

    // Add settings and controls for each feature

    // Header Features    
    $wp_customize->add_setting('ftm_head_customizer_logo_max_width_setting', array(
        'default' => '150',
        'transport' => 'refresh',
    ));    

    $wp_customize->add_control('ftm_head_customizer_general_logo_max_width_control', array(
        'label'       => 'Logo Max. Width (px)',
        'section'     => 'ftm_head_customizer_general_section',
        'settings'    => 'ftm_head_customizer_logo_max_width_setting',
        'description' => 'In pixels',
        'type'        => 'text',
    ));

    $wp_customize->add_setting('ftm_head_customizer_max_width_setting', array(
        'default' => '1140',
        'transport' => 'refresh',
    ));    

    $wp_customize->add_control('ftm_head_customizer_general_wrapper_max_width_control', array(
        'label'       => 'Header Max. Width (px)',
        'section'     => 'ftm_head_customizer_general_section',
        'settings'    => 'ftm_head_customizer_max_width_setting',
        'description' => 'In pixels',
        'type'        => 'text',
    ));

    $wp_customize->add_setting('ftm_head_customizer_sub_menu_max_width_setting', array(
        'default' => '300',
        'transport' => 'refresh',
    ));    

    $wp_customize->add_control('ftm_head_customizer_sub_menu_max_width_control', array(
        'label'       => 'Sub Menu Max. Width (px)',
        'section'     => 'ftm_head_customizer_general_section',
        'settings'    => 'ftm_head_customizer_sub_menu_max_width_setting',
        'description' => 'In pixels',
        'type'        => 'text',
    ));

    // Header Color Features
    $wp_customize->add_setting('ftm_head_customizer_color_background_color_setting', array(
        'default' => 'ffffff',
        'transport' => 'refresh',
    ));

    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ftm_head_customizer_color_background_color_control', array(
        'label' => 'Header Background Color',
        'section' => 'ftm_head_customizer_color_section',
        'settings' => 'ftm_head_customizer_color_background_color_setting',
    )));

    $wp_customize->add_setting('ftm_head_customizer_color_nav_text_color_setting', array(
        'default' => 'ffffff',
        'transport' => 'refresh',
    ));

    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ftm_head_customizer_color_nav_text_color_control', array(
        'label' => 'Header Nav. Text Color',
        'section' => 'ftm_head_customizer_color_section',
        'settings' => 'ftm_head_customizer_color_nav_text_color_setting',
    )));

    $wp_customize->add_setting('ftm_head_customizer_color_nav_text_color_hover_setting', array(
        'default' => 'ffffff',
        'transport' => 'refresh',
    ));

    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ftm_head_customizer_color_nav_text_color_hover_control', array(
        'label' => 'Header Nav. Hover Color',
        'section' => 'ftm_head_customizer_color_section',
        'settings' => 'ftm_head_customizer_color_nav_text_color_hover_setting',
    )));

    //FIRST SUB MENU
    $wp_customize->add_setting('ftm_head_customizer_color_first_sub_nav_text_color_setting', array(
        'default' => '000000',
        'transport' => 'refresh',
    ));

    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ftm_head_customizer_color_first_sub_nav_text_color_control', array(
        'label' => 'First Sub-Nav. Text Color',
        'section' => 'ftm_head_customizer_color_section',
        'settings' => 'ftm_head_customizer_color_first_sub_nav_text_color_setting',
    )));

    $wp_customize->add_setting('ftm_head_customizer_color_first_sub_nav_text_color_hover_setting', array(
        'default' => '000000',
        'transport' => 'refresh',
    ));

    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ftm_head_customizer_color_first_sub_nav_text_color_hover_control', array(
        'label' => 'First Sub-Nav. Hover Color',
        'section' => 'ftm_head_customizer_color_section',
        'settings' => 'ftm_head_customizer_color_first_sub_nav_text_color_hover_setting',
    )));

    $wp_customize->add_setting('ftm_head_customizer_color_first_sub_nav_background_color_setting', array(
        'default' => 'ffffff',
        'transport' => 'refresh',
    ));

    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ftm_head_customizer_color_first_sub_nav_background_color_control', array(
        'label' => 'First Nav. Background Color',
        'section' => 'ftm_head_customizer_color_section',
        'settings' => 'ftm_head_customizer_color_first_sub_nav_background_color_setting',
    )));

    //SECOND SUB MENU
    $wp_customize->add_setting('ftm_head_customizer_color_second_sub_nav_text_color_setting', array(
        'default' => '000000',
        'transport' => 'refresh',
    ));

    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ftm_head_customizer_color_second_sub_nav_text_color_control', array(
        'label' => 'Second Sub-Nav. Text Color',
        'section' => 'ftm_head_customizer_color_section',
        'settings' => 'ftm_head_customizer_color_second_sub_nav_text_color_setting',
    )));

    $wp_customize->add_setting('ftm_head_customizer_color_second_sub_nav_text_color_hover_setting', array(
        'default' => '000000',
        'transport' => 'refresh',
    ));

    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ftm_head_customizer_color_second_sub_nav_text_color_hover_control', array(
        'label' => 'Second Sub-Nav. Hover Color',
        'section' => 'ftm_head_customizer_color_section',
        'settings' => 'ftm_head_customizer_color_second_sub_nav_text_color_hover_setting',
    )));

    $wp_customize->add_setting('ftm_head_customizer_color_second_sub_nav_background_color_setting', array(
        'default' => 'ffffff',
        'transport' => 'refresh',
    ));

    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ftm_head_customizer_color_second_sub_nav_background_color_control', array(
        'label' => 'Second Nav. Background Color',
        'section' => 'ftm_head_customizer_color_section',
        'settings' => 'ftm_head_customizer_color_second_sub_nav_background_color_setting',
    )));


    // Add more features here...

}
add_action('customize_register', 'custom_theme_header_customizer_features');
