<?php
function ftm_write_css($css_fields)
{

    //BASIC REQUIRED VARIABLES
    $counter = 1;
    $temp = $temp_latest = "";
    $css_fields_quantity = count($css_fields);
    $file_name = FTM_BASE_CSS_CUSTOMIZER_FILE_PATH;

    foreach ($css_fields as $field => $key) {

        if ($counter == 1) {
            $temp .= ":root{" . $field . ": " . $key . ";";
        } elseif ($counter == $css_fields_quantity) {
            $temp .= $field . ": " . $key . ";}";
        } else {
            $temp .= $field . ": " . $key . ";";
        }

        $counter++;
    }

    if (!is_dir(FTM_BASE_CSS_CUSTOMIZER_CSS_DIR)) {
        wp_mkdir_p(FTM_BASE_CSS_CUSTOMIZER_CSS_DIR);
    }

    //Get current CSS file
    if (file_exists($file_name)) {

        $latest_file = fopen($file_name, "r");
        $temp_latest = fgets($latest_file);
        fclose($latest_file);
    }

    //Check if there's any difference and write the new css file if it does
    if ($temp_latest != $temp) {

        $css_file = fopen($file_name, "w+");
        fwrite($css_file, $temp);
        fclose($css_file);
    }    
}

function webpack($file, $buildDirectory = 'dist'){
    static $manifest;
    static $manifestPath;

    if (is_null($manifest) || $manifestPath !== $buildDirectory) {
        $manifest = json_decode(
            file_get_contents(get_template_directory_uri() . "/" . $buildDirectory . '/manifest.json'),
            true
        );

        $manifestPath = $buildDirectory;
    }

    if (isset($manifest[$file])) {
        return get_template_directory_uri() . "/" . trim($buildDirectory . '/' . $manifest[$file], '/');
    }

    throw new InvalidArgumentException("File {$file} not defined in asset manifest.");
}

function get_states_list(){
    $usStates = array(
        'AL' => 'Alabama',
        'AK' => 'Alaska',
        'AZ' => 'Arizona',
        'AR' => 'Arkansas',
        'CA' => 'California',
        'CO' => 'Colorado',
        'CT' => 'Connecticut',
        'DE' => 'Delaware',
        'FL' => 'Florida',
        'GA' => 'Georgia',
        'HI' => 'Hawaii',
        'ID' => 'Idaho',
        'IL' => 'Illinois',
        'IN' => 'Indiana',
        'IA' => 'Iowa',
        'KS' => 'Kansas',
        'KY' => 'Kentucky',
        'LA' => 'Louisiana',
        'ME' => 'Maine',
        'MD' => 'Maryland',
        'MA' => 'Massachusetts',
        'MI' => 'Michigan',
        'MN' => 'Minnesota',
        'MS' => 'Mississippi',
        'MO' => 'Missouri',
        'MT' => 'Montana',
        'NE' => 'Nebraska',
        'NV' => 'Nevada',
        'NH' => 'New Hampshire',
        'NJ' => 'New Jersey',
        'NM' => 'New Mexico',
        'NY' => 'New York',
        'NC' => 'North Carolina',
        'ND' => 'North Dakota',
        'OH' => 'Ohio',
        'OK' => 'Oklahoma',
        'OR' => 'Oregon',
        'PA' => 'Pennsylvania',
        'RI' => 'Rhode Island',
        'SC' => 'South Carolina',
        'SD' => 'South Dakota',
        'TN' => 'Tennessee',
        'TX' => 'Texas',
        'UT' => 'Utah',
        'VT' => 'Vermont',
        'VA' => 'Virginia',
        'WA' => 'Washington',
        'WV' => 'West Virginia',
        'WI' => 'Wisconsin',
        'WY' => 'Wyoming'
    );

    return $usStates;
}

function get_current_state(){
    // Check if the "currState" cookie is set
    if (isset($_COOKIE['currState'])) {
        $currStateValue = $_COOKIE['currState'];
        return $currStateValue;
      } else {
        return null;
      }
}

function add_geo_meta_tag() {
    $currentState =  get_current_state();

    if(! is_null($currentState)){
        echo '<meta name="geo.region" content="'.$currentState.'" />';
    }    
}
add_action( 'wp_head', 'add_geo_meta_tag' );
