<?php
global $post;

$permalink = get_permalink($post->ID);

// Get the last updated date of the post
$last_updated_date = get_the_modified_date('', $post->ID);

$show_sidebar  = false;
$wrapper_class = 'ftm_single_content_wrapper';
if (is_post_type_archive()) {
	$wrapper_class = 'ftm_archive_content_wrapper';
	$show_sidebar  = get_theme_mod('ftm_general_site_archives_show_sidebar', false);
} else {
	$show_sidebar  = get_theme_mod('ftm_general_site_blog_show_sidebar', false);
}

if ($show_sidebar) {
	$wrapper_class .= ' has_sidebar';
}

get_header();
?>
<?php do_action('ftm_before_content_hook'); ?>
<div class="<?php echo $wrapper_class; ?> site_content_wrapper">
	<?php do_action('ftm_before_content_panel_hook'); ?>
	<div class="content_panel">
		<?php if (have_posts()) : while (have_posts()) : the_post();
				do_action('ftm_before_single_title_hook');
				echo "<h1>" . get_the_title() . "</h1>"; ?>
				<p class="post-meta">Article By <?php echo get_the_author(); ?> | Last Updated : <?php echo $last_updated_date; ?></p>
				<?php do_action('ftm_after_single_title_hook'); ?>
				<?php
				if (has_post_thumbnail()) {
					$thumbnail_id 	= get_post_thumbnail_id(get_the_ID());
					$alt_text 		= get_post_meta($thumbnail_id, '_wp_attachment_image_alt', true);
					$thumbnail_url 	= get_the_post_thumbnail_url(get_the_ID(), 'full');

					echo '<img src="' . esc_url($thumbnail_url) . '" alt="' . esc_attr($alt_text) . '">';
				}
				?>
			<?php
				the_content();
			endwhile;
			do_action('ftm_after_single_content_hook');
		else : ?>
			<p>Sorry, no posts matched your criteria.</p>
		<?php endif; ?>
		<?php comments_template(); ?>
	</div>
	<?php if ($show_sidebar) : ?>
		<div class="sidebar_panel">
			<?php if (is_active_sidebar('right-sidebar')) {
				dynamic_sidebar('right-sidebar');
			} ?>
		</div>
	<?php endif; ?>
</div>
<?php get_footer(); ?>