<?php

// REMOVE FEEDS
remove_action('wp_head', 'feed_links_extra', 3); // Remove Every Extra Links to Rss Feeds.
remove_action('wp_head', 'feed_links', 2);
remove_action('wp_head', 'wc_products_rss_feed');

add_filter( 'xmlrpc_enabled', '__return_false' );
remove_action('wp_head', 'rsd_link');

/**
 * REMOVE DEFAULT SCRIPTS
 */
function remove_default_scripts(&$scripts)
{
    if (!is_admin()) {
        //$scripts->remove( 'jquery');
        //$scripts->add( 'jquery', false, array( 'jquery-core' ), '1.12.4' );
    }
}

add_filter('wp_default_scripts', 'remove_default_scripts');

/**
 * REMOVE SCRIPTS AND STYLES
 */
function remove_scripts_style()
{

    wp_dequeue_style('core-block-supports');
    //REMOVE wp-json API links
    remove_action('wp_head', 'rest_output_link_wp_head');
    remove_action('wp_head', 'wp_oembed_add_discovery_links');
    //REMOVE wlwmanifest.xml file
    remove_action('wp_head', 'wlwmanifest_link');
    //REMOVE classic-themes.css file
    wp_dequeue_style( 'classic-theme-styles' );
    //REMOVE INLINE GLOBAL STYLES
    wp_dequeue_style( 'global-styles' );

    //REMOVE FOR ALLL USERS BUT ADMIN
    if (!is_admin()) {
        wp_dequeue_style('NAME'); //
    } else {
        //IN CASE WE WANT TO REMOVE SOMETHING FOR ADMIN
        wp_dequeue_style('NAME'); //
    }

    //REMOVE ANY EXTRA SCRIPTS FROM HOMEPAGE
    if (is_front_page()) {
        wp_dequeue_style('NAME'); //

    }

    //ANY OTHER CUSTOM REMOVE SHOULD GO HERE

}

add_action('wp_enqueue_scripts', 'remove_scripts_style', 999);

add_action('wp_footer', function () {
    wp_dequeue_style('core-block-supports');
});