<?php
/**
 * Template Name: Custom Category Template
 */
$show_sidebar  = false;
$wrapper_class = 'ftm_category_hub_content_wrapper';
get_header();
?>

<?php do_action('ftm_before_content_hook'); ?>
	<div class="<?php echo $wrapper_class; ?> site_content_wrapper">
		<div class="content_panel">
            <h1><?php single_cat_title(); ?></h1>
            <?php
            $category_description = category_description();
            if (!empty($category_description)) {
                echo '<div class="category-description">' . wpautop($category_description) . '</div>';
            }
            ?>
            <div class="latest" id="latest_post_wrapper">
                <?php

                $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;                
                $args = array(
                    'cat' => get_query_var('cat'),
                    'paged' => $paged,
                );
                $query = new WP_Query($args);                

                if ($query->have_posts()) :
                    while ($query->have_posts()) :
                        $query->the_post();?>
                            <article>
								<?php if (has_post_thumbnail()) : ?>
									<div class="post-thumbnail">
										<a href="<?php the_permalink(); ?>">
											<?php the_post_thumbnail('medium'); ?>
											<div class="post_meta">
												<span class="author">By: <?php echo get_the_author_meta( 'nicename'); ?>&nbsp;|&nbsp;</span>
												<span class="post-date"><?php echo get_the_modified_date(); ?></span>
											</div>
										</a>
									</div>
								<?php endif; ?>

								<h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
								<div class="post_excerpt">
									<?php echo ftm_get_text_excerpt(get_the_content(),25) ; ?>
								</div>								
							</article>
                    <?php
                    endwhile;

                    // Pagination
                    ftm_custom_pagination($query);

                    wp_reset_postdata();
                else :
                    echo 'No posts found.';
                endif;
                ?>
            </div>
        </div>
    </div>		
<?php get_footer(); ?>