<?php

$upload_dir   = wp_upload_dir();

define('FTM_BASE_CSS_CUSTOMIZER_CSS_DIR', $upload_dir['basedir'] . "/ftm-base/css/");
define('FTM_BASE_CSS_CUSTOMIZER_FILE_URI', $upload_dir['baseurl'] . "/ftm-base/css/ftm_base_variables.css");
define('FTM_BASE_CSS_CUSTOMIZER_FILE_PATH', $upload_dir['basedir'] . "/ftm-base/css/ftm_base_variables.css");

// Register Features section in the Customizer
function custom_theme_customizer_features($wp_customize)
{
    // Add a new section for Features
    $wp_customize->add_section('features_section', array(
        'title' => 'Features',
        'priority' => 30,
    ));

    // Add settings and controls for each feature

    // Example feature
    $wp_customize->add_setting('feature_theme_debug', array(
        'default' => '',
        'transport' => 'refresh',
    ));
    $wp_customize->add_control('feature_theme_debug_control', array(
        'label' => 'Theme Debug',
        'section' => 'features_section',
        'settings' => 'feature_theme_debug',
        'type' => 'checkbox',
    ));

    // Add a control for the 'ftm-site-has-reviews' option
    $wp_customize->add_setting('ftm-site-has-reviews', array(
        'default' => true, // Set the default value to true
        'sanitize_callback' => 'wp_validate_boolean', // Ensure the value is a boolean
    ));

    $wp_customize->add_control('ftm-site-has-reviews-control', array(
        'label' => __('Enable Reviews', 'ftm-base-theme'),
        'section' => 'features_section',
        'type' => 'checkbox',
        'settings' => 'ftm-site-has-reviews'
    ));

    // Add a control for the 'ftm-site-header-sticky-top' option
    $wp_customize->add_setting('ftm-site-header-sticky-top', array(
        'default' => false, // Set the default value to false
        'sanitize_callback' => 'wp_validate_boolean', // Ensure the value is a boolean
    ));

    $wp_customize->add_control('ftm-site-header-sticky-top-option', array(
        'label' => __('Header Sticky Top', 'ftm-base-theme'),
        'section' => 'features_section',
        'type' => 'checkbox',
        'settings' => 'ftm-site-header-sticky-top'
    ));

    // Add a control for the 'ftm-site-reviews-sticky-top' option
    $wp_customize->add_setting('ftm-site-reviews-sticky-top', array(
        'default' => false, // Set the default value to false
        'sanitize_callback' => 'wp_validate_boolean', // Ensure the value is a boolean
    ));

    $wp_customize->add_control('ftm-site-reviews-sticky-top-option', array(
        'label' => __('Reviews Sticky Top', 'ftm-base-theme'),
        'section' => 'features_section',
        'type' => 'checkbox',
        'settings' => 'ftm-site-reviews-sticky-top'
    ));

    $wp_customize->add_setting('features_affiliates', array(
        'default' => 'Our team of experts diligently research and review all of the products and services we recommend. If you buy through our links, we may receive a commission. Learn more here.',
        'transport' => 'refresh',
    ));

    $wp_customize->add_control('features_affiliates_text', array(
        'label' => 'Affiliate Disclosure Text',
        'section' => 'features_section',
        'settings' => 'features_affiliates',
        'description' => 'Shortcode: [affiliate_disclosure]',
        'type' => 'textarea',
    ));
}

function ftm_customizer_footer($wp_customize)
{

    /* 
     * ==================================================
     * FOOTER PANEL START
     * ==================================================
     */
    $wp_customize->add_panel('footer_section', array(
        'title'      => __('Footer', 'ftm_base'),
        'capability'     => 'edit_theme_options',
        'priority'   => 30,
    ));

    /*
     * COLORS SECTION START
     */

    //COLOR SECTION
    $wp_customize->add_section('footer_colors_section', array(
        'title'      => __('Colors', 'ftm_base'),
        'priority'   => 30,
        'panel'      => 'footer_section',
    ));

    //COLOR SETTINGS
    $wp_customize->add_setting('footer_color_main', array(
        'default'     => '#0A152D',
        'transport'   => 'refresh',
    ));

    $wp_customize->add_setting('footer_color_secondary', array(
        'default'     => '#F8F8FC',
        'transport'   => 'refresh',
    ));

    $wp_customize->add_setting('footer_color_text', array(
        'default'     => '#ffffff',
        'transport'   => 'refresh',
    ));

    $wp_customize->add_setting('footer_color_text_hover', array(
        'default'     => '#d6d6d6',
        'transport'   => 'refresh',
    ));

    //COLOR CONTROLS
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'footer_color_main', array(
        'label'        => __('Main Footer Color', 'ftm-base'),
        'section'    => 'footer_colors_section',
        'settings'   => 'footer_color_main',
    )));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'footer_color_secondary', array(
        'label'        => __('Secondary Footer Color', 'ftm-base'),
        'section'    => 'footer_colors_section',
        'settings'   => 'footer_color_secondary',
    )));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'footer_color_text', array(
        'label'        => __('Text Color', 'ftm-base'),
        'section'    => 'footer_colors_section',
        'settings'   => 'footer_color_text',
    )));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'footer_color_text_hover', array(
        'label'        => __('Text Hover Color', 'ftm-base'),
        'section'    => 'footer_colors_section',
        'settings'   => 'footer_color_text_hover',
    )));

    /*
     * COLORS SECTION END
     */

    /*
     * SOCIAL SECTION START
     */
    $wp_customize->add_section('footer_social_section', array(
        'title'      => __('Socials', 'ftm_base'),
        'priority'   => 30,
        'panel'      => 'footer_section',
    ));

    //SOCIAL TITLE
    $wp_customize->add_setting('footer_social_title', array(
        'default' => 'Never miss a moment',
        'transport' => 'refresh',
    ));

    //TWITTER SETTINGS
    $wp_customize->add_setting('footer_social_twitter', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_social_twitter_link', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    //YOUTUBE SETTINGS
    $wp_customize->add_setting('footer_social_youtube', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_social_youtube_link', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    //INSTAGRAM SETTINGS
    $wp_customize->add_setting('footer_social_ig', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_social_ig_link', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    //FB SETTINGS
    $wp_customize->add_setting('footer_social_fb', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_social_fb_link', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    //SOCIAL TITLE CONTROL
    $wp_customize->add_control('footer_social_title_control', array(
        'label' => 'Title',
        'section' => 'footer_social_section',
        'settings' => 'footer_social_title',
        'type' => 'text',
    ));

    //TWITTER CONTROLS
    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer_social_twitter_control', array(
        'label' => 'Twitter Icon',
        'section' => 'footer_social_section',
        'settings' => 'footer_social_twitter',
    )));

    $wp_customize->add_control('footer_social_twitter_link', array(
        'label' => 'Twitter Link',
        'section' => 'footer_social_section',
        'settings' => 'footer_social_twitter_link',
        'type' => 'text',
    ));

    //YOUTUBE CONTROLS
    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer_social_youtube_control', array(
        'label' => 'Youtube Icon',
        'section' => 'footer_social_section',
        'settings' => 'footer_social_youtube',
    )));

    $wp_customize->add_control('footer_social_youtube_link', array(
        'label' => 'Youtube Link',
        'section' => 'footer_social_section',
        'settings' => 'footer_social_youtube_link',
        'type' => 'text',
    ));

    //INSTAGRAM CONTROLS
    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer_social_ig_control', array(
        'label' => 'Instagram Icon',
        'section' => 'footer_social_section',
        'settings' => 'footer_social_ig',
    )));

    $wp_customize->add_control('footer_social_ig_link', array(
        'label' => 'Instagram Link',
        'section' => 'footer_social_section',
        'settings' => 'footer_social_ig_link',
        'type' => 'text',
    ));

    //INSTAGRAM CONTROLS
    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer_social_fb_control', array(
        'label' => 'Facebook Icon',
        'section' => 'footer_social_section',
        'settings' => 'footer_social_fb',
    )));

    $wp_customize->add_control('footer_social_fb_link', array(
        'label' => 'Facebook Link',
        'section' => 'footer_social_section',
        'settings' => 'footer_social_fb_link',
        'type' => 'text',
    ));

    /*
     * SOCIAL SECTION END
     */


    /*
     * BOTTOM SECTION START
     */
    $wp_customize->add_section('footer_bottom_section', array(
        'title'      => __('Bottom', 'ftm_base'),
        'priority'   => 32,
        'panel'      => 'footer_section',
    ));

    //BOTTOM SETTINGS
    $wp_customize->add_setting('footer_bottom_title', array(
        'default' => 'GamblingSite.com is certified by:',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_bottom_logo1', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_bottom_logo2', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_bottom_logo3', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_bottom_logo4', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    //BOTTOM CONTROLS
    $wp_customize->add_control('footer_bottom_title_control', array(
        'label' => 'Bottom Title',
        'section' => 'footer_bottom_section',
        'settings' => 'footer_bottom_title',
        'type' => 'text',
    ));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer_bottom_logo1', array(
        'label' => 'Logo 1',
        'section' => 'footer_bottom_section',
        'settings' => 'footer_bottom_logo1',
    )));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer_bottom_logo2', array(
        'label' => 'Logo 2',
        'section' => 'footer_bottom_section',
        'settings' => 'footer_bottom_logo2',
    )));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer_bottom_logo3', array(
        'label' => 'Logo 3',
        'section' => 'footer_bottom_section',
        'settings' => 'footer_bottom_logo3',
    )));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer_bottom_logo4', array(
        'label' => 'Logo 4',
        'section' => 'footer_bottom_section',
        'settings' => 'footer_bottom_logo4',
    )));

    /*
     * BOTTOM SECTION END
     */

    /*
     * FEATURED SECTION START
     */
    $wp_customize->add_section('footer_featured_section', array(
        'title'      => __('Featured', 'ftm_base'),
        'priority'   => 10,
        'panel'      => 'footer_section',
    ));

    //BOTTOM SETTINGS
    $wp_customize->add_setting('footer_featured_title', array(
        'default' => 'AS FEATURED ON:',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_featured_logo1', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_featured_logo2', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_featured_logo3', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_featured_logo4', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_featured_logo5', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_featured_logo6', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    //FEATURED CONTROLS
    $wp_customize->add_control('footer_featured_title_control', array(
        'label' => 'Featured Title',
        'section' => 'footer_featured_section',
        'settings' => 'footer_featured_title',
        'type' => 'text',
    ));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer_featured_logo1', array(
        'label' => 'Logo 1',
        'section' => 'footer_featured_section',
        'settings' => 'footer_featured_logo1',
    )));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer_featured_logo2', array(
        'label' => 'Logo 2',
        'section' => 'footer_featured_section',
        'settings' => 'footer_featured_logo2',
    )));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer_featured_logo3', array(
        'label' => 'Logo 3',
        'section' => 'footer_featured_section',
        'settings' => 'footer_featured_logo3',
    )));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer_featured_logo4', array(
        'label' => 'Logo 4',
        'section' => 'footer_featured_section',
        'settings' => 'footer_featured_logo4',
    )));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer_featured_logo5', array(
        'label' => 'Logo 5',
        'section' => 'footer_featured_section',
        'settings' => 'footer_featured_logo5',
    )));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer_featured_logo6', array(
        'label' => 'Logo 6',
        'section' => 'footer_featured_section',
        'settings' => 'footer_featured_logo6',
    )));

    /*
     * FEATURED SECTION END
     */


    /*
     * MORE LOGOS SECTION START
     */
    $wp_customize->add_section('footer_more_section', array(
        'title'      => __('More Logos', 'ftm_base'),
        'priority'   => 31,
        'panel'      => 'footer_section',
    ));

    //MORE TITLE
    $wp_customize->add_setting('footer_more_title', array(
        'default' => 'We want you to play responsibly',
        'transport' => 'refresh',
    ));

    //MORE SETTINGS
    $wp_customize->add_setting('footer_more_logo1', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_more_logo1_link', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_more_logo2', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_more_logo2_link', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_more_logo3', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_more_logo3_link', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_more_logo4', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_more_logo4_link', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    //MORE CONTROLS
    $wp_customize->add_control('footer_more_title_control', array(
        'label' => 'Title',
        'section' => 'footer_more_section',
        'settings' => 'footer_more_title',
        'type' => 'text',
    ));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer_more_logo1_control', array(
        'label' => 'Logo 1',
        'section' => 'footer_more_section',
        'settings' => 'footer_more_logo1',
    )));

    $wp_customize->add_control('footer_more_logo1_link', array(
        'label' => 'Logo 1 Link',
        'section' => 'footer_more_section',
        'settings' => 'footer_more_logo1_link',
        'type' => 'text',
    ));

    //YOUTUBE CONTROLS
    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer_more_logo2_control', array(
        'label' => 'Logo 2',
        'section' => 'footer_more_section',
        'settings' => 'footer_more_logo2',
    )));

    $wp_customize->add_control('footer_more_logo2', array(
        'label' => 'Logo 2 Link',
        'section' => 'footer_more_section',
        'settings' => 'footer_more_logo2_link',
        'type' => 'text',
    ));

    //INSTAGRAM CONTROLS
    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer_more_logo3_control', array(
        'label' => 'Logo 3',
        'section' => 'footer_more_section',
        'settings' => 'footer_more_logo3',
    )));

    $wp_customize->add_control('footer_more_logo3_link', array(
        'label' => 'Logo 3 Link',
        'section' => 'footer_more_section',
        'settings' => 'footer_more_logo3_link',
        'type' => 'text',
    ));

    //INSTAGRAM CONTROLS
    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer_more_logo4_control', array(
        'label' => 'Logo 4',
        'section' => 'footer_more_section',
        'settings' => 'footer_more_logo4',
    )));

    $wp_customize->add_control('footer_more_logo4_link', array(
        'label' => 'Logo 4 Link',
        'section' => 'footer_more_section',
        'settings' => 'footer_more_logo4_link',
        'type' => 'text',
    ));

    /*
     * MORE LOGOS SECTION END
     */

    /*
     * MENUS SECTION START
     */

    $menus = get_terms('nav_menu', array('hide_empty' => true));
    $menu_choices = array();
    foreach ($menus as $menu) {
        $menu_choices[$menu->term_id] = $menu->name;
    }

    $wp_customize->add_section('footer_menu_section', array(
        'title'      => __('Menus', 'ftm_base'),
        'priority'   => 11,
        'panel'      => 'footer_section',
    ));

    $wp_customize->add_setting('menu1_setting', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('menu2_setting', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('menu3_setting', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('menu4_setting', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('menu5_setting', array(
        'default' => '',
        'transport' => 'refresh',
    ));

    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'menu1_control', array(
        'label' => 'Menu 1',
        'section' => 'footer_menu_section',
        'settings' => 'menu1_setting',
        'type' => 'select',
        'choices' => $menu_choices,
    )));

    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'menu2_control', array(
        'label' => 'Menu 2',
        'section' => 'footer_menu_section',
        'settings' => 'menu2_setting',
        'type' => 'select',
        'choices' => $menu_choices,
    )));

    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'menu3_control', array(
        'label' => 'Menu 3',
        'section' => 'footer_menu_section',
        'settings' => 'menu3_setting',
        'type' => 'select',
        'choices' => $menu_choices,
    )));

    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'menu4_control', array(
        'label' => 'Menu 4',
        'section' => 'footer_menu_section',
        'settings' => 'menu4_setting',
        'type' => 'select',
        'choices' => $menu_choices,
    )));

    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'menu5_control', array(
        'label' => 'Menu 5 (Horizontal)',
        'section' => 'footer_menu_section',
        'settings' => 'menu5_setting',
        'type' => 'select',
        'choices' => $menu_choices,
    )));

    /*
     * MENUS SECTION END
     */

    /*
     * DETAILS SECTION START
     */

    $wp_customize->add_section('footer_details_section', array(
        'title'      => __('Details', 'ftm_base'),
        'priority'   => 32,
        'panel'      => 'footer_section',
    ));

    $wp_customize->add_setting('footer_email_setting', array(
        'default' => 'contact@gamblingsite.com',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('footer_copyright_setting', array(
        'default' => '© Copyright 2023 GamblingSite.com',
        'transport' => 'refresh',
    ));

    $wp_customize->add_control('footer_email_control', array(
        'label' => 'Email',
        'section' => 'footer_details_section',
        'settings' => 'footer_email_setting',
        'type' => 'text',
    ));

    $wp_customize->add_control('footer_copyright_control', array(
        'label' => 'Email',
        'section' => 'footer_details_section',
        'settings' => 'footer_copyright_setting',
        'type' => 'text',
    ));

    /*
     * DETAILS SECTION END
     */


    /* 
     * ==================================================
     * FOOTER PANEL END
     * ==================================================
     */
}

function ftm_customizer_content($wp_customize)
{


    // Add a new section for Features
    $wp_customize->add_section('ftm_general_section', array(
        'title' => 'General',
        'priority' => 10,
    ));

    // Add settings and controls for each feature

    // Example feature
    $wp_customize->add_setting('ftm_general_site_pages_content_width', array(
        'default' => '1124',
        'transport' => 'refresh',
    ));
    $wp_customize->add_control('ftm_general_site_content_width_control', array(
        'label' => 'Page Width in PX',
        'section' => 'ftm_general_section',
        'settings' => 'ftm_general_site_pages_content_width',
        'type' => 'text',
    ));

    $wp_customize->add_setting('ftm_general_site_blog_content_width', array(
        'default' => '1124',
        'transport' => 'refresh',
    ));

    $wp_customize->add_control('ftm_general_site_blog_content_width_control', array(
        'label' => 'Blog Width in PX',
        'section' => 'ftm_general_section',
        'settings' => 'ftm_general_site_blog_content_width',
        'type' => 'text',
    ));

    // Add a control for show sidebar
    $wp_customize->add_setting('ftm_general_site_blog_show_sidebar', array(
        'default' => false,
        'transport' => 'refresh',
    ));

    $wp_customize->add_control('ftm_general_site_blog_show_sidebar_control', array(
        'type'     => 'checkbox',
        'label'    => __('Show Sidebar for Blog Posts', 'custom-theme'),
        'section'  => 'ftm_general_section',
        'settings' => 'ftm_general_site_blog_show_sidebar',
    ));

    $wp_customize->add_setting('ftm_general_site_archives_content_width', array(
        'default' => '1124',
        'transport' => 'refresh',
    ));
    $wp_customize->add_control('ftm_general_site_archives_content_width_control', array(
        'label' => 'Archive Width in PX',
        'section' => 'ftm_general_section',
        'settings' => 'ftm_general_site_archives_content_width',
        'type' => 'text',
    ));

    // Add a control for show sidebar
    $wp_customize->add_setting('ftm_general_site_archives_show_sidebar', array(
        'default' => false,
        'transport' => 'refresh',
    ));

    $wp_customize->add_control('ftm_general_site_archives_show_sidebar_control', array(
        'type'     => 'checkbox',
        'label'    => __('Show Sidebar for Archives', 'custom-theme'),
        'section'  => 'ftm_general_section',
        'settings' => 'ftm_general_site_archives_show_sidebar',
    ));

    $wp_customize->add_setting('ftm_general_site_related_posts_post_type', array(
        'default' => false,
        'transport' => 'refresh',
    ));

    $wp_customize->add_control('ftm_general_site_related_posts_post_type_control', array(
        'type'     => 'select',
        'label'    => __('Related Posts - Post Type', 'custom-theme'),
        'section'  => 'ftm_general_section',
        'settings' => 'ftm_general_site_related_posts_post_type',
        'choices'  => get_public_post_types()
    ));

    $wp_customize->add_setting('ftm_general_blog_hub_post_type', array(
        'default' => false,
        'transport' => 'refresh',
    ));

    $wp_customize->add_control('ftm_general_blog_hub_post_type_control', array(
        'type'     => 'select',
        'label'    => __('Blog Hub - Post Type', 'custom-theme'),
        'section'  => 'ftm_general_section',
        'settings' => 'ftm_general_blog_hub_post_type',
        'choices'  => get_public_post_types()
    ));

    //Add a new section for the site general typography

    $systemFonts = array(
        "Arial" => "Arial",
        "Helvetica" => "Helvetica",
        "Times New Roman" => "Times New Roman",
        "Courier New" => "Courier New",
        "Verdana" => "Verdana",
        "Georgia" => "Georgia",
        "Palatino" => "Palatino",
        "Garamond" => "Garamond",
        "Bookman" => "Bookman",
        "Trebuchet MS" => "Trebuchet MS",
        "Arial Black" => "Arial Black",
        "Impact" => "Impact",
        "Comic Sans MS" => "Comic Sans MS",
    );

    $wp_customize->add_section('ftm_custom_typography_section', array(
        'title'    => __('Typography', 'custom-theme'),
        'priority' => 30,
    ));

    //Add the font sizes settings
    $wp_customize->add_setting('ftm_custom_h1_font_size_setting', array(
        'default' => '18',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('ftm_custom_h2_font_size_setting', array(
        'default' => '16',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('ftm_custom_h3_font_size_setting', array(
        'default' => '14',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('ftm_custom_h4_font_size_setting', array(
        'default' => '13',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('ftm_custom_h5_font_size_setting', array(
        'default' => '13',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('ftm_custom_h6_font_size_setting', array(
        'default' => '13',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('ftm_custom_p_font_size_setting', array(
        'default' => '12',
        'transport' => 'refresh',
    ));

    // Add a control for font size
    $wp_customize->add_control('ftm_custom_h1_font_size_control', array(
        'type'        => 'number',
        'label'       => __('Generla H1 Font Size', 'ftm-base-theme'),
        'section'     => 'ftm_custom_typography_section',
        'settings'    => 'ftm_custom_h1_font_size_setting',
        'input_attrs' => array(
            'min'   => 10,
            'max'   => 100,
            'step'  => 1,
        ),
        'default'     => 18, // Default font size value
    ));

    $wp_customize->add_control('ftm_custom_h2_font_size_control', array(
        'type'        => 'number',
        'label'       => __('Generla H2 Font Size', 'ftm-base-theme'),
        'section'     => 'ftm_custom_typography_section',
        'settings'    => 'ftm_custom_h2_font_size_setting',
        'input_attrs' => array(
            'min'   => 10,
            'max'   => 100,
            'step'  => 1,
        ),
        'default'     => 16, // Default font size value
    ));

    $wp_customize->add_control('ftm_custom_h3_font_size_control', array(
        'type'        => 'number',
        'label'       => __('Generla H3 Font Size', 'ftm-base-theme'),
        'section'     => 'ftm_custom_typography_section',
        'settings'    => 'ftm_custom_h3_font_size_setting',
        'input_attrs' => array(
            'min'   => 10,
            'max'   => 100,
            'step'  => 1,
        ),
        'default'     => 14, // Default font size value
    ));

    $wp_customize->add_control('ftm_custom_h4_font_size_control', array(
        'type'        => 'number',
        'label'       => __('Generla H4 Font Size', 'ftm-base-theme'),
        'section'     => 'ftm_custom_typography_section',
        'settings'    => 'ftm_custom_h4_font_size_setting',
        'input_attrs' => array(
            'min'   => 10,
            'max'   => 100,
            'step'  => 1,
        ),
        'default'     => 13, // Default font size value
    ));

    $wp_customize->add_control('ftm_custom_h5_font_size_control', array(
        'type'        => 'number',
        'label'       => __('Generla H5 Font Size', 'ftm-base-theme'),
        'section'     => 'ftm_custom_typography_section',
        'settings'    => 'ftm_custom_h5_font_size_setting',
        'input_attrs' => array(
            'min'   => 10,
            'max'   => 100,
            'step'  => 1,
        ),
        'default'     => 13, // Default font size value
    ));

    $wp_customize->add_control('ftm_custom_h6_font_size_control', array(
        'type'        => 'number',
        'label'       => __('Generla H6 Font Size', 'ftm-base-theme'),
        'section'     => 'ftm_custom_typography_section',
        'settings'    => 'ftm_custom_h6_font_size_setting',
        'input_attrs' => array(
            'min'   => 10,
            'max'   => 100,
            'step'  => 1,
        ),
        'default'     => 13, // Default font size value
    ));

    $wp_customize->add_control('ftm_custom_p_font_size_control', array(
        'type'        => 'number',
        'label'       => __('Generla P Font Size', 'ftm-base-theme'),
        'section'     => 'ftm_custom_typography_section',
        'settings'    => 'ftm_custom_p_font_size_setting',
        'input_attrs' => array(
            'min'   => 10,
            'max'   => 100,
            'step'  => 1,
        ),
        'default'     => 13, // Default font size value
    ));

    //Add the font settings
    $wp_customize->add_setting('ftm_custom_h1_font', array(
        'capability' => 'edit_theme_options',
        'default' => 'Arial',
    ));

    $wp_customize->add_setting('ftm_custom_h2_font', array(
        'capability' => 'edit_theme_options',
        'default' => 'Arial',
    ));

    $wp_customize->add_setting('ftm_custom_h3_font', array(
        'capability' => 'edit_theme_options',
        'default' => 'Arial',
    ));

    $wp_customize->add_setting('ftm_custom_h4_font', array(
        'capability' => 'edit_theme_options',
        'default' => 'Arial',
    ));

    $wp_customize->add_setting('ftm_custom_h5_font', array(
        'capability' => 'edit_theme_options',
        'default' => 'Arial',
    ));

    $wp_customize->add_setting('ftm_custom_h6_font', array(
        'capability' => 'edit_theme_options',
        'default' => 'Arial',
    ));

    $wp_customize->add_setting('ftm_custom_p_font', array(
        'capability' => 'edit_theme_options',
        'default' => 'Arial',
    ));

    // Add a control for font
    $wp_customize->add_control('ftm_custom_h1_font_control', array(
        'type'     => 'select',
        'section'  => 'ftm_custom_typography_section',
        'label'    => 'General H1 Font',
        'settings' => 'ftm_custom_h1_font',
        'choices'  => $systemFonts,
    ));


    $wp_customize->add_control('ftm_custom_h2_font_control', array(
        'type'     => 'select',
        'section'  => 'ftm_custom_typography_section',
        'label'    => 'General H2 Font',
        'settings' => 'ftm_custom_h2_font',
        'choices'  => $systemFonts,
    ));

    $wp_customize->add_control('ftm_custom_h3_font_control', array(
        'type'     => 'select',
        'section'  => 'ftm_custom_typography_section',
        'label'    => 'General H3 Font',
        'settings' => 'ftm_custom_h3_font',
        'choices'  => $systemFonts,
    ));

    $wp_customize->add_control('ftm_custom_h4_font_control', array(
        'type'     => 'select',
        'section'  => 'ftm_custom_typography_section',
        'label'    => 'General H4 Font',
        'settings' => 'ftm_custom_h4_font',
        'choices'  => $systemFonts,
    ));

    $wp_customize->add_control('ftm_custom_h5_font_control', array(
        'type'     => 'select',
        'section'  => 'ftm_custom_typography_section',
        'label'    => 'General H5 Font',
        'settings' => 'ftm_custom_h5_font',
        'choices'  => $systemFonts,
    ));

    $wp_customize->add_control('ftm_custom_h6_font_control', array(
        'type'     => 'select',
        'section'  => 'ftm_custom_typography_section',
        'label'    => 'General H6 Font',
        'settings' => 'ftm_custom_h6_font',
        'choices'  => $systemFonts,
    ));

    $wp_customize->add_control('ftm_custom_p_font_control', array(
        'type'     => 'select',
        'section'  => 'ftm_custom_typography_section',
        'label'    => 'General P Font',
        'settings' => 'ftm_custom_p_font',
        'choices'  => $systemFonts,
    ));




    //Add the font color settings
    $wp_customize->add_setting('ftm_custom_h1_color', array(
        'default' => '#000000',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('ftm_custom_h2_color', array(
        'default' => '#000000',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('ftm_custom_h3_color', array(
        'default' => '#000000',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('ftm_custom_h4_color', array(
        'default' => '#000000',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('ftm_custom_h5_color', array(
        'default' => '#000000',
        'transport' => 'refresh',
    ));


    $wp_customize->add_setting('ftm_custom_h6_color', array(
        'default' => '#000000',
        'transport' => 'refresh',
    ));


    $wp_customize->add_setting('ftm_custom_p_color', array(
        'default' => '#000000',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('ftm_custom_a_color', array(
        'default' => '#2364AA',
        'transport' => 'refresh',
    ));

    $wp_customize->add_setting('ftm_custom_a_hover_color', array(
        'default' => '#ABB8C3',
        'transport' => 'refresh',
    ));

    // Add a control for font color
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'ftm_general_site_content_h1_color_control', array(
        'label' => 'General H1 Color',
        'section' => 'ftm_custom_typography_section',
        'settings' => 'ftm_custom_h1_color',
    )));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'ftm_general_site_content_h2_color_control', array(
        'label' => 'General H2 Color',
        'section' => 'ftm_custom_typography_section',
        'settings' => 'ftm_custom_h2_color',
    )));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'ftm_general_site_content_h3_color_control', array(
        'label' => 'General H3 Color',
        'section' => 'ftm_custom_typography_section',
        'settings' => 'ftm_custom_h3_color',
    )));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'ftm_general_site_content_h4_color_control', array(
        'label' => 'General H4 Color',
        'section' => 'ftm_custom_typography_section',
        'settings' => 'ftm_custom_h4_color',
    )));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'ftm_general_site_content_h5_color_control', array(
        'label' => 'General H5 Color',
        'section' => 'ftm_custom_typography_section',
        'settings' => 'ftm_custom_h5_color',
    )));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'ftm_general_site_content_h6_color_control', array(
        'label' => 'General H6 Color',
        'section' => 'ftm_custom_typography_section',
        'settings' => 'ftm_custom_h6_color',
    )));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'ftm_general_site_content_p_color_control', array(
        'label' => 'General P Color',
        'section' => 'ftm_custom_typography_section',
        'settings' => 'ftm_custom_p_color',
    )));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'ftm_general_site_content_a_color_control', array(
        'label' => 'General A Color',
        'section' => 'ftm_custom_typography_section',
        'settings' => 'ftm_custom_a_color',
    )));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'ftm_general_site_content_a_hover_color_control', array(
        'label' => 'General A Hover Color',
        'section' => 'ftm_custom_typography_section',
        'settings' => 'ftm_custom_a_hover_color',
    )));
}

function custom_theme_header_customizer_features($wp_customize)
{

    //Add the Head panel
    $wp_customize->add_panel(
        'ftm_head_customizer_panel',
        array(
            'priority'    => 100,
            'title'       => __('Header', 'ftm-theme-customizer'),
            'description' => __('All header related settings', 'ftm-theme-customizer')
        )
    );
    // Add a new section for general settings
    $wp_customize->add_section('ftm_head_customizer_general_section', array(
        'title'    => 'General',
        'priority' => 1,
        'panel'    => 'ftm_head_customizer_panel'
    ));
    // Add a new section for colors
    $wp_customize->add_section('ftm_head_customizer_color_section', array(
        'title'    => 'Colors',
        'priority' => 2,
        'panel'    => 'ftm_head_customizer_panel'
    ));

    // Add settings and controls for each feature

    // Header Features    
    $wp_customize->add_setting('ftm_head_customizer_logo_max_width_setting', array(
        'default' => '150',
        'transport' => 'refresh',
    ));

    $wp_customize->add_control('ftm_head_customizer_general_logo_max_width_control', array(
        'label'       => 'Logo Max. Width (px)',
        'section'     => 'ftm_head_customizer_general_section',
        'settings'    => 'ftm_head_customizer_logo_max_width_setting',
        'description' => 'In pixels',
        'type'        => 'text',
    ));

    $wp_customize->add_setting('ftm_head_customizer_max_width_setting', array(
        'default' => '1140',
        'transport' => 'refresh',
    ));

    $wp_customize->add_control('ftm_head_customizer_general_wrapper_max_width_control', array(
        'label'       => 'Header Max. Width (px)',
        'section'     => 'ftm_head_customizer_general_section',
        'settings'    => 'ftm_head_customizer_max_width_setting',
        'description' => 'In pixels',
        'type'        => 'text',
    ));

    $wp_customize->add_setting('ftm_head_customizer_sub_menu_max_width_setting', array(
        'default' => '300',
        'transport' => 'refresh',
    ));

    $wp_customize->add_control('ftm_head_customizer_sub_menu_max_width_control', array(
        'label'       => 'Sub Menu Max. Width (px)',
        'section'     => 'ftm_head_customizer_general_section',
        'settings'    => 'ftm_head_customizer_sub_menu_max_width_setting',
        'description' => 'In pixels',
        'type'        => 'text',
    ));

    // Header Color Features
    $wp_customize->add_setting('ftm_head_customizer_color_background_color_setting', array(
        'default' => '#ffffff',
        'transport' => 'refresh',
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'ftm_head_customizer_color_background_color_control', array(
        'label' => 'Header Background Color',
        'section' => 'ftm_head_customizer_color_section',
        'settings' => 'ftm_head_customizer_color_background_color_setting',
    )));

    $wp_customize->add_setting('ftm_head_customizer_color_nav_text_color_setting', array(
        'default' => '#ffffff',
        'transport' => 'refresh',
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'ftm_head_customizer_color_nav_text_color_control', array(
        'label' => 'Header Nav. Text Color',
        'section' => 'ftm_head_customizer_color_section',
        'settings' => 'ftm_head_customizer_color_nav_text_color_setting',
    )));

    $wp_customize->add_setting('ftm_head_customizer_color_nav_text_color_hover_setting', array(
        'default' => '#ffffff',
        'transport' => 'refresh',
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'ftm_head_customizer_color_nav_text_color_hover_control', array(
        'label' => 'Header Nav. Hover Color',
        'section' => 'ftm_head_customizer_color_section',
        'settings' => 'ftm_head_customizer_color_nav_text_color_hover_setting',
    )));

    //FIRST SUB MENU
    $wp_customize->add_setting('ftm_head_customizer_color_first_sub_nav_text_color_setting', array(
        'default' => '#000000',
        'transport' => 'refresh',
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'ftm_head_customizer_color_first_sub_nav_text_color_control', array(
        'label' => 'First Sub-Nav. Text Color',
        'section' => 'ftm_head_customizer_color_section',
        'settings' => 'ftm_head_customizer_color_first_sub_nav_text_color_setting',
    )));

    $wp_customize->add_setting('ftm_head_customizer_color_first_sub_nav_text_color_hover_setting', array(
        'default' => '#000000',
        'transport' => 'refresh',
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'ftm_head_customizer_color_first_sub_nav_text_color_hover_control', array(
        'label' => 'First Sub-Nav. Hover Color',
        'section' => 'ftm_head_customizer_color_section',
        'settings' => 'ftm_head_customizer_color_first_sub_nav_text_color_hover_setting',
    )));

    $wp_customize->add_setting('ftm_head_customizer_color_first_sub_nav_background_color_setting', array(
        'default' => '#ffffff',
        'transport' => 'refresh',
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'ftm_head_customizer_color_first_sub_nav_background_color_control', array(
        'label' => 'First Nav. Background Color',
        'section' => 'ftm_head_customizer_color_section',
        'settings' => 'ftm_head_customizer_color_first_sub_nav_background_color_setting',
    )));

    //SECOND SUB MENU
    $wp_customize->add_setting('ftm_head_customizer_color_second_sub_nav_text_color_setting', array(
        'default' => '#000000',
        'transport' => 'refresh',
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'ftm_head_customizer_color_second_sub_nav_text_color_control', array(
        'label' => 'Second Sub-Nav. Text Color',
        'section' => 'ftm_head_customizer_color_section',
        'settings' => 'ftm_head_customizer_color_second_sub_nav_text_color_setting',
    )));

    $wp_customize->add_setting('ftm_head_customizer_color_second_sub_nav_text_color_hover_setting', array(
        'default' => '#000000',
        'transport' => 'refresh',
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'ftm_head_customizer_color_second_sub_nav_text_color_hover_control', array(
        'label' => 'Second Sub-Nav. Hover Color',
        'section' => 'ftm_head_customizer_color_section',
        'settings' => 'ftm_head_customizer_color_second_sub_nav_text_color_hover_setting',
    )));

    $wp_customize->add_setting('ftm_head_customizer_color_second_sub_nav_background_color_setting', array(
        'default' => '#ffffff',
        'transport' => 'refresh',
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'ftm_head_customizer_color_second_sub_nav_background_color_control', array(
        'label' => 'Second Nav. Background Color',
        'section' => 'ftm_head_customizer_color_section',
        'settings' => 'ftm_head_customizer_color_second_sub_nav_background_color_setting',
    )));


    // Add more features here...

}


add_action('customize_register', 'custom_theme_header_customizer_features');
add_action('customize_register', 'ftm_customizer_content');
add_action('customize_register', 'custom_theme_customizer_features');
add_action('customize_register', 'ftm_customizer_footer');


function ftm_customizer_settings($wp_customize)
{
    //Site General Settings
    $css_variables["--body-background-color"]             = '#' . get_background_color();

    //Header Variables    
    $css_variables["--head-wapper-max-width"]             =  get_theme_mod('ftm_head_customizer_max_width_setting', '1140') . 'px';
    $css_variables["--head-logo-max-width"]               =  get_theme_mod('ftm_head_customizer_logo_max_width_setting', '150') . 'px';
    $css_variables["--sub-menu-max-width"]                =  get_theme_mod('ftm_head_customizer_sub_menu_max_width_setting', '300') . 'px';
    $css_variables["--head-background-color"]             =  get_theme_mod('ftm_head_customizer_color_background_color_setting', '#ffffff');
    $css_variables["--head-nav-text-color"]               =  get_theme_mod('ftm_head_customizer_color_nav_text_color_setting', '#ffffff');
    $css_variables["--head-nav-hover-color"]              =  get_theme_mod('ftm_head_customizer_color_nav_text_color_hover_setting', '#ffffff');

    //First level Sub Menu
    $css_variables["--first_sub-nav-text-color"]          =  get_theme_mod('ftm_head_customizer_color_first_sub_nav_text_color_setting', '#000000');
    $css_variables["--first_sub-nav-hover-color"]         =  get_theme_mod('ftm_head_customizer_color_first_sub_nav_text_color_hover_setting', '#000000');
    $css_variables["--first_sub-nav-background-color"]    =  get_theme_mod('ftm_head_customizer_color_first_sub_nav_background_color_setting', '#ffffff');

    //Second level Sub Menu
    $css_variables["--second_sub-nav-text-color"]         =  get_theme_mod('ftm_head_customizer_color_second_sub_nav_text_color_setting', '#000000');
    $css_variables["--second_sub-nav-hover-color"]        =  get_theme_mod('ftm_head_customizer_color_second_sub_nav_text_color_hover_setting', '#000000');
    $css_variables["--second_sub-nav-background-color"]   =  get_theme_mod('ftm_head_customizer_color_second_sub_nav_background_color_setting', '#ffffff');

    //Footer variables
    $css_variables["--footer_color_main"]       = get_theme_mod('footer_color_main', '#0A152D');
    $css_variables["--footer_color_secondary"]  = get_theme_mod('footer_color_secondary', '#F8F8FC');
    $css_variables["--footer_text_color"]       = get_theme_mod('footer_color_text', '#dfddd7');
    $css_variables["--footer_text_color_hover"] = get_theme_mod('footer_color_text_hover', '#D6D6D6');

    //General Content Variables
    $css_variables["--pages_content_width"]     = get_theme_mod('ftm_general_site_pages_content_width', '1124') . 'px';
    $css_variables["--blog_content_width"]      = get_theme_mod('ftm_general_site_blog_content_width', '1124') . 'px';
    $css_variables["--archives_content_width"]  = get_theme_mod('ftm_general_site_archives_content_width', '1124') . 'px';

    //General Typography Variables
    //General H1
    $css_variables["--ftm_h1_font_size_setting"]  = get_theme_mod('ftm_custom_h1_font_size_setting', '24') . 'px';
    $css_variables["--ftm_h1_font"]               = get_theme_mod('ftm_custom_h1_font', 'arial');
    $css_variables["--ftm_h1_color"]              = get_theme_mod('ftm_custom_h1_color', '#000000');
    //General H2
    $css_variables["--ftm_h2_font_size_setting"]  = get_theme_mod('ftm_custom_h2_font_size_setting', '18') . 'px';
    $css_variables["--ftm_h2_font"]               = get_theme_mod('ftm_custom_h2_font', 'arial');
    $css_variables["--ftm_h2_color"]              = get_theme_mod('ftm_custom_h2_color', '#000000');
    //General H3
    $css_variables["--ftm_h3_font_size_setting"]  = get_theme_mod('ftm_custom_h3_font_size_setting', '15') . 'px';
    $css_variables["--ftm_h3_font"]               = get_theme_mod('ftm_custom_h3_font', 'arial');
    $css_variables["--ftm_h3_color"]              = get_theme_mod('ftm_custom_h3_color', '#000000');
    //General H4
    $css_variables["--ftm_h4_font_size_setting"]  = get_theme_mod('ftm_custom_h4_font_size_setting', '13') . 'px';
    $css_variables["--ftm_h4_font"]               = get_theme_mod('ftm_custom_h4_font', 'arial');
    $css_variables["--ftm_h4_color"]              = get_theme_mod('ftm_custom_h4_color', '#000000');
    //General H5
    $css_variables["--ftm_h5_font_size_setting"]  = get_theme_mod('ftm_custom_h5_font_size_setting', '13') . 'px';
    $css_variables["--ftm_h5_font"]               = get_theme_mod('ftm_custom_h5_font', 'arial');
    $css_variables["--ftm_h5_color"]              = get_theme_mod('ftm_custom_h5_color', '#000000');
    //General H6
    $css_variables["--ftm_h6_font_size_setting"]  = get_theme_mod('ftm_custom_h6_font_size_setting', '13') . 'px';
    $css_variables["--ftm_h6_font"]               = get_theme_mod('ftm_custom_h6_font', 'arial');
    $css_variables["--ftm_h6_color"]              = get_theme_mod('ftm_custom_h6_color', '#000000');
    //General P
    $css_variables["--ftm_p_font_size_setting"]  = get_theme_mod('ftm_custom_p_font_size_setting', '13') . 'px';
    $css_variables["--ftm_p_font"]               = get_theme_mod('ftm_custom_p_font', 'arial');
    $css_variables["--ftm_p_color"]              = get_theme_mod('ftm_custom_p_color', '#000000');
    //General A
    $css_variables["--ftm_a_color"]               = get_theme_mod('ftm_custom_a_color', '#2364AA');
    $css_variables["--ftm_a_hover_color"]         = get_theme_mod('ftm_custom_a_hover_color', '#ABB8C3');

    ftm_write_css($css_variables);
}
add_action('customize_save_after', 'ftm_customizer_settings');
