<!doctype html>
<html <?php language_attributes(); ?>>

<head>
	<meta charset="<?php bloginfo('charset'); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<!-- wrapper -->
	<div class="wrapper" id="main_wrapper">
		<!-- header -->
		<?php
		// Get the value of the Sticky_top setting
		$sticky_header = get_theme_mod('ftm-site-header-sticky-top');
		$sticky_header_class = ($sticky_header == true) ? 'class="sticky-header"' : '';
		?>
		<header <?php echo $sticky_header_class; ?>>
			<div class="ftm-header-content-wrapper">
				<div class="ftm-mobile-menu-trigger-wrapper">
					<button id="ftm-mobile-menu-trigger"></button>
				</div>
				<div class="ftm-site-logo-wrapper">
					<?php
					$custom_logo_id = get_theme_mod('custom_logo');
					$image = wp_get_attachment_image_src($custom_logo_id, 'medium');
					?>
					<a href="<?php echo get_home_url(); ?>"><img class="ftm-site-logo" src="<?php echo $image[0]; ?>" alt="<?php echo get_bloginfo('name'); ?>" /></a>
				</div>
				<nav id="site-navigation" class="main-navigation" role="navigation">
					<?php wp_nav_menu(array('theme_location' => 'main-menu')); ?>
				</nav><!-- #site-navigation -->
				<?php
					$display_state_filter = get_theme_mod('ftm_general_state_filter_display', false);
					if($display_state_filter){
				?>
					<div class="ftm-state-filter">
						<?php
						$currState 	   =  get_current_state();
						$statesList 	   = get_states_list();
						$currentStateData = array();

						if (is_null($currState)) {
							$currState = "AL";
						}

						$currentStateData["code"] = $currState;
						$currentStateData["name"] = $statesList[$currState];
						$currentStateData["flag"] = "/app/themes/ftm-base/assets/state_flags/" . str_replace(' ', '_', $currentStateData["name"]) . '.svg';


						?>
						<button class="current_state_btn" data-micromodal-trigger="ftm-states-modal">
							<span class="state_name"><?php echo $currentStateData["name"]; ?></span>
							<span class="state_code"><?php echo $currentStateData["code"]; ?></span>
							<img src="<?php echo $currentStateData["flag"]; ?>" alt="<?php echo $currentStateData["name"]; ?>" />
						</button>
					</div>
					<div class="modal micromodal-slide" id="ftm-states-modal" aria-hidden="true">
						<div class="modal__overlay" tabindex="-1" data-micromodal-close>
							<div class="modal__container" role="dialog" aria-modal="true" aria-labelledby="modal-1-title">
								<div class="modal__header">
									<div class="geo-title">
										<img class=" lazyloaded" data-src="/app/themes/ftm-base/assets/images/world-logo.svg" src="/app/themes/ftm-base/assets/images/world-logo.svg">
										Select Location
									</div>
								</div>
								<div class="modal__content" id="modal-1-content">
									<select id="ftm-header__state" name="ftm-header__state" class="custom_select">
										<?php
										foreach ($statesList as $code => $name) { ?>
											<option <?php if ($currState == $code) {
														echo "selected";
													} ?> value="<?php echo $code; ?>"><?php echo $name; ?></option>
										<?php }
										?>
									</select>
								</div>
								<div class="modal__footer">
									<button class="modal__btn modal__btn-primary" data-micromodal-close aria-label="Close this dialog window">Update Location</button>
								</div>
							</div>
						</div>
					</div>
				<?php } ?>
			</div>
		</header>
		<!-- /header -->