<?php
$show_sidebar  = false;
$wrapper_class = 'ftm_blog_content_wrapper ftm_search_template';
if ( is_post_type_archive() ){
    $wrapper_class = 'ftm_archive_content_wrapper';
    $show_sidebar  = get_theme_mod('ftm_general_site_archives_show_sidebar', false);
}
else{
    $show_sidebar  = get_theme_mod('ftm_general_site_blog_show_sidebar', false);
}

if($show_sidebar){
    $wrapper_class .= ' has_sidebar';
}

get_header();
?>

    <?php do_action('ftm_before_content_hook'); ?>
    <div class="<?php echo $wrapper_class; ?> site_content_wrapper">
        <div class="content_panel">
            <?php echo "<h1>Search Results for: " . get_search_query() . "</h1>"; ?>
            <div class="latest" id="latest_post_wrapper">
            <?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>      
                <article>
                    <?php if (has_post_thumbnail()) : ?>
                        <div class="post-thumbnail">
                            <a href="<?php the_permalink(); ?>">
                                <?php the_post_thumbnail('medium'); ?>
                                <div class="post_meta">
                                    <span class="author">By: <?php echo get_the_author_meta('display_name'); ?>&nbsp;|&nbsp;</span>
                                    <span class="post-date"><?php echo the_date(); ?></span>
                                </div>
                            </a>
                        </div>
                    <?php endif; ?>

                    <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                    <div class="post_excerpt">
                        <?php echo ftm_get_text_excerpt(get_the_content(), 25); ?>
                    </div>
                </article>
            <?php endwhile; else: ?>
            <p>Sorry, no posts matched your criteria.</p>
            <?php endif; ?>
            </div>
            <?php comments_template(); ?>
        </div>
        <?php if($show_sidebar): ?>
            <div class="sidebar_panel">
                <?php if (is_active_sidebar('right-sidebar')) {
                    dynamic_sidebar('right-sidebar');
                }?>
            </div>
        <?php endif; ?>
    </div>      
<?php get_footer(); ?>
