<?php
$social_title           = get_theme_mod('footer_social_title', 'Never miss a moment');
$social_twitter         = get_theme_mod('footer_social_twitter');
$social_twitter_link    = get_theme_mod('footer_social_twitter_link');
$social_youtube         = get_theme_mod('footer_social_youtube');
$social_youtube_link    = get_theme_mod('footer_social_youtube_link');
$social_instagram       = get_theme_mod('footer_social_ig');
$social_instagram_link  = get_theme_mod('footer_social_ig_link');
$social_facebook        = get_theme_mod('footer_social_fb');
$social_facebook_link   = get_theme_mod('footer_social_fb_link');

$social_link_rel = [];
$social_link_noreferrer = (get_theme_mod('footer_social_link_noreferrer') == true) ? array_push($social_link_rel, 'noreferrer') : '';
$social_link_noopener   = (get_theme_mod('footer_social_link_noopener') == true) ? array_push($social_link_rel, 'noopener') : '';
$social_link_nofollow   = (get_theme_mod('footer_social_link_nofollow') == true) ? array_push($social_link_rel, 'nofollow') : '';
$social_link_rel = (!empty($social_link_rel)) ? 'rel="' . implode(" ", $social_link_rel) . '"' : '';

$bottom_title           = get_theme_mod('footer_bottom_title', 'Certified by:');
$featured_title         = get_theme_mod('footer_featured_title', 'As featured on');
$more_title             = get_theme_mod('footer_more_title', 'We want you to play responsibly');
$menu1_id               = get_theme_mod('menu1_setting');
$menu1_object           = wp_get_nav_menu_object($menu1_id);
$menu1_items            = wp_get_nav_menu_items($menu1_id);
$menu2_id               = get_theme_mod('menu2_setting');
$menu2_object           = wp_get_nav_menu_object($menu2_id);
$menu2_items            = wp_get_nav_menu_items($menu2_id);
$menu3_id               = get_theme_mod('menu3_setting');
$menu3_object           = wp_get_nav_menu_object($menu3_id);
$menu3_items            = wp_get_nav_menu_items($menu3_id);
$menu4_id               = get_theme_mod('menu4_setting');
$menu4_object           = wp_get_nav_menu_object($menu4_id);
$menu4_items            = wp_get_nav_menu_items($menu4_id);
$menu5_id               = get_theme_mod('menu5_setting');
$menu5_object           = wp_get_nav_menu_object($menu5_id);
$menu5_items            = wp_get_nav_menu_items($menu5_id);
$footer_email           = get_theme_mod('footer_email_setting', 'contact@gamblingsite.com');
$copyright              = get_theme_mod('footer_copyright_setting', '© Copyright ' . date('Y') . ' GamblingSite.com');
?>
<!-- footer -->
<footer class="footer">
    <div class="footer__main">
        <div class="footer__as-featured-on">
            <div class="container badge__container">
                <div class="badge badge--light">
                    <?php echo strtoupper($featured_title); ?>
                </div>
                <div class="footer__brands">
                    <?php
                    for ($index = 1; $index <= 6; $index++) {
                        if (!empty(get_theme_mod('footer_featured_logo' . $index))) {
                            $featured_logo      = get_theme_mod('footer_featured_logo' . $index);
                            $featured_logo_alt  = get_post_meta(attachment_url_to_postid($featured_logo), '_wp_attachment_image_alt', TRUE);
                    ?>
                            <img src="<?php echo $featured_logo ?>" alt="<?php echo $featured_logo_alt; ?>">
                    <?php
                        }
                    }
                    ?>
                </div>
            </div>
        </div>
        <div class="container">
            <div class="footer__menu row">
                <div class="footer__menu-column col-md-3">
                    <?php
                    if ($menu1_object) {
                        echo '<span>' . $menu1_object->name . '</span>';
                    }

                    if ($menu1_items) {
                        echo '<ul class="footer-menu">';
                        foreach ($menu1_items as $menu_item) {
                            echo '<li class="footer-menu__item"><a href="' . $menu_item->url . '">' . $menu_item->title . '</a></li>';
                        }
                        echo '</ul>';
                    }
                    ?>
                </div>
                <div class="footer__menu-column col-md-3">
                    <?php
                    if ($menu2_object) {
                        echo '<span>' . $menu2_object->name . '</span>';
                    }

                    if ($menu2_items) {
                        echo '<ul class="footer-menu">';
                        foreach ($menu2_items as $menu_item) {
                            echo '<li class="footer-menu__item"><a href="' . $menu_item->url . '">' . $menu_item->title . '</a></li>';
                        }
                        echo '</ul>';
                    }
                    ?>
                </div>
                <div class="footer__menu-column col-md-3">
                    <?php
                    if ($menu3_object) {
                        echo '<span>' . $menu3_object->name . '</span>';
                    }

                    if ($menu3_items) {
                        echo '<ul class="footer-menu">';
                        foreach ($menu3_items as $menu_item) {
                            echo '<li class="footer-menu__item"><a href="' . $menu_item->url . '">' . $menu_item->title . '</a></li>';
                        }
                        echo '</ul>';
                    }
                    ?>
                </div>
                <div class="footer__menu-column col-md-3">
                    <?php
                    if ($menu4_object) {
                        echo '<span>' . $menu4_object->name . '</span>';
                    }

                    if ($menu4_items) {
                        echo '<ul class="footer-menu">';
                        foreach ($menu4_items as $menu_item) {
                            echo '<li class="footer-menu__item"><a href="' . $menu_item->url . '">' . $menu_item->title . '</a></li>';
                        }
                        echo '</ul>';
                    }
                    ?>
                </div>
            </div>
            <div class="row">
                <div class="col-md-8">
                    <div class="footer__responsibility badge__container">
                        <div class="badge badge--primary">
                            <?php echo strtoupper($more_title); ?>
                        </div>
                        <?php
                        for ($index = 1; $index <= 4; $index++) {
                            if (!empty(get_theme_mod('footer_more_logo' . $index))) {
                                $more_logo      = get_theme_mod('footer_more_logo' . $index);
                                $more_logo_alt  = get_post_meta(attachment_url_to_postid($more_logo), '_wp_attachment_image_alt', TRUE);
                                $more_logo_link = get_theme_mod('footer_more_logo' . $index . "_link");
                                if (!empty($more_logo_link)) {
                        ?>
                                    <a href="<?php echo $more_logo_link ?>" target="_blank" <?php echo $social_link_rel; ?> class="footer__responsibility-item">
                                        <img src="<?php echo $more_logo ?>" alt="<?php echo $more_logo_alt; ?>">
                                    </a>
                                <?php
                                } else {
                                ?>
                                    <img src="<?php echo $more_logo ?>" alt="<?php echo $more_logo_alt; ?>">
                        <?php
                                }
                            }
                        }
                        ?>
                    </div>
                </div>
                <div class="col-md-1 footer__spacer"></div>
                <div class="col-md-3">
                    <div class="footer__social badge__container">
                        <div class="badge badge--primary">
                            <?php echo strtoupper($social_title); ?>
                        </div>
                        <?php
                        if (!empty($social_twitter)) {
                        ?>
                            <a href="<?php echo $social_twitter_link ?>" target="_blank" <?php echo $social_link_rel; ?> class="footer__social-item">
                                <span class="icon icon--svg" style="background-image: url('<?php echo $social_twitter; ?>');"></span>
                            </a>
                        <?php
                        }
                        ?>
                        <?php
                        if (!empty($social_facebook)) {
                        ?>
                            <a href="<?php echo $social_facebook_link ?>" target="_blank" <?php echo $social_link_rel; ?> class="footer__social-item">
                                <span class="icon icon--svg" style="background-image: url('<?php echo $social_facebook; ?>');"></span>
                            </a>
                        <?php
                        }
                        ?>
                        <?php
                        if (!empty($social_instagram)) {
                        ?>
                            <a href="<?php echo $social_instagram_link ?>" target="_blank" <?php echo $social_link_rel; ?> class="footer__social-item">
                                <span class="icon icon--svg" style="background-image: url('<?php echo $social_instagram; ?>');"></span>
                            </a>
                        <?php
                        }
                        ?>
                        <?php
                        if (!empty($social_youtube)) {
                        ?>
                            <a href="<?php echo $social_youtube_link ?>" target="_blank" <?php echo $social_link_rel; ?> class="footer__social-item">
                                <span class="icon icon--svg" style="background-image: url('<?php echo $social_youtube; ?>');"></span>
                            </a>
                        <?php
                        }
                        ?>
                    </div>
                </div>
            </div>
            <div class="footer__links">
                <div>
                    <?php
                    if ($menu5_items) {
                        foreach ($menu5_items as $menu_item) {
                            echo '<a href="' . $menu_item->url . '">' . $menu_item->title . '</a>';
                        }
                    }
                    ?>
                </div>
                <div>
                    <a href="mailto:<?php echo $footer_email; ?>">
                        <?php echo $footer_email; ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
    <div class="footer__bottom">
        <div class="container">
            <div class="footer__bottom-label">
                <?php echo $bottom_title; ?>
            </div>
            <div class="footer__bottom-logotypes">
                <?php
                for ($index = 1; $index <= 4; $index++) {
                    if (!empty(get_theme_mod('footer_bottom_logo' . $index))) {
                        $bottom_logo      = get_theme_mod('footer_bottom_logo' . $index);
                        $bottom_logo_alt  = get_post_meta(attachment_url_to_postid($bottom_logo), '_wp_attachment_image_alt', TRUE);
                ?>
                        <div>
                            <img src="<?php echo $bottom_logo ?>" alt="<?php echo $bottom_logo_alt; ?>">
                        </div>
                <?php
                    }
                }
                ?>
            </div>
            <div class="footer__bottom-copyright">
                <?php echo $copyright; ?>
            </div>
        </div>
    </div>
</footer>
<!-- /footer -->
</div>
<!-- /wrapper -->
<?php wp_footer(); ?>
</body>

</html>