
<?php
/**
 * Template Name: Author Profile
 *
 * @package WordPress
 * @subpackage FTM Base
 * @since FTM Base 1.0.1
 */

	$show_sidebar       = false;
	$wrapper_class      = 'ftm_author_content_wrapper';
	$latest_posts_title = "Posts by ";
    get_header();
?>

<?php do_action('ftm_before_content_hook'); ?>
	<div class="<?php echo $wrapper_class; ?> site_content_wrapper">
		<div class="content_panel">
			<?php if ( have_posts() ) : while ( have_posts() ) : the_post();
		
            $author_name            = get_field('author_name');
            $wordpress_user_account = get_field('wordpress_user_account');
            $display_joined_date    = (get_field('display_author_joined_date')) ? get_field('display_author_joined_date'):false;
            $display_contact_link   = (get_field('display_author_contact_link')) ? get_field('display_author_contact_link'):false;
            $author_role            = get_field('author_role');
            $author_joined          = get_field('author_joined');
            $author_contact_link    = get_field('author_contact_link');
            $author_favorites       = get_field('author_favorites');
            $author_socials         = get_field('author_socials');

            $latest_posts_title = $latest_posts_title . $author_name;
            ?>

            <div class="ftm-author-top">
                <div class="author-avatar-wrapper">
                <?php
                    $image = get_user_meta($wordpress_user_account, 'ftm_custom_profile_picture', true);
                    if ($image) {
                        echo '<img class="avatar" src="' . $image . '" alt="'.$author_name.'" />';
                    }
                ?>
                </div>
                <div class="author-info-wrapper">                    
                    <div class="top-info">
                        <h1><?php echo $author_name; ?></h1>
                        <div class="sub-info">
                            <label>Expertise:</label><span><?php echo $author_role; ?></span>
                            <?php if( $display_joined_date == true ): ?>
                                <label>Joined:</label><span><?php echo $author_joined; ?></span>
                            <?php endif;?>
                        </div>
			        </div>
                    <div class="general-info-wrapper">
                        <div class="left-panel">
                            <?php the_content(); ?>
                            <div class="bottom-buttons">
                                <?php if ($display_contact_link == true): ?>
                                    <div class="contact-link">                                    
                                        <a class="default" href="<?php echo $author_contact_link ?>"><span class="dashicons dashicons-email"></span> Click to Contact <?php echo $author_name ?></a>                                    
                                    </div>
                                <?php endif; ?>
                                <div class="author-media-links">
                                    <?php 
                                        // Check if the repeater field has values
                                        if ($author_socials) {
                                            foreach ($author_socials as $social) {
                                                $social_media_site = $social['social_media_site'];
                                                $social_media_url = $social['social_media_url'];

                                                // Output the link with the image
                                                echo '<a href="' . esc_url($social_media_url) . '" target="_blank" rel="nofollow noopener" >';
                                                echo '<span class="dashicons dashicons-'.esc_attr($social_media_site).'"></span>';
                                                echo '</a>';
                                            }
                                        }
                                    ?>
                                </div>
                            </div>
                        </div>
                        <div class="right-panel">
                            <div class="favorites-title">Favorites</div>
                            <div class="favorites-list">
                                <?php 
                                    // Check if the repeater field has values
                                    if ($author_favorites) {
                                        foreach ($author_favorites as $favorite) {
                                            $favorite_item_name = $favorite['favorite_item_name'];
                                            $favorite_item_value = $favorite['favorite_item_value'];

                                            // Output the label and span for each repeater item
                                            echo '<div>';
                                            echo '<label for="' . esc_attr($favorite_item_name) . '">' . esc_html($favorite_item_name) . ':</label>';
                                            echo '<span>' . esc_html($favorite_item_value) . '</span>';
                                            echo '</div>';
                                        }
                                    }
                                ?>
                            </div>
                        </div>
                    </div>
                </div>                
            </div>

            <div class="latest-posts-title">
                <h3><?php echo $latest_posts_title; ?></h3>
            </div>
			
            <?php
			endwhile; endif; ?>

			<div class="latest" id="latest_post_wrapper">			
				<?php
					$initial_latest_posts_offset = 0;
					$post_type = (!empty(get_theme_mod('ftm_general_author_related_post_type'))) ? get_theme_mod('ftm_general_author_related_post_type') : 'post';
					
                    $args = array(
						'post_type'      => $post_type,
						'post_status'	 => 'publish',
						'posts_per_page' => 9,
						'orderby'        => 'date',
						'order'          => 'DESC',
                        'author'        => $wordpress_user_account
					);

					$query = new WP_Query($args);

					if($query->found_posts < $initial_latest_posts_offset) {
						$initial_latest_posts_offset = $query->found_posts;
					}
					
					if ($query->have_posts()) :
						while ($query->have_posts()) : $query->the_post();
					?>
							<article>
								<?php if (has_post_thumbnail()) : ?>
									<div class="post-thumbnail">
										<a href="<?php the_permalink(); ?>">
											<?php the_post_thumbnail('medium'); ?>
											<div class="post_meta">
												<span class="author">By: <?php echo get_the_author_meta( 'display_name'); ?>&nbsp;|&nbsp;</span>
												<span class="post-date"><?php echo get_the_modified_date(); ?></span>
											</div>
										</a>
									</div>
								<?php endif; ?>

								<h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
								<div class="post_excerpt">
									<?php echo ftm_get_text_excerpt(get_the_content(),25) ; ?>
								</div>
								
							</article>
					<?php
						endwhile;
						wp_reset_postdata();
					endif;
				?>
			</div>
			<input id="latest_posts_offset" name="latest_posts_offset" value="<?php echo $initial_latest_posts_offset; ?>" type="hidden" />
			<div class="ftm_load_more" data-user-id="<?php echo $wordpress_user_account; ?>"><div></div><div></div><div></div></div>			
		</div>
	</div>		
<?php get_footer(); ?>