(function (wp) {
  var createElement = wp.element.createElement;
  var Fragment = wp.element.Fragment;
  var ToggleControl = wp.components.ToggleControl;
  var addFilter = wp.hooks.addFilter;
  var __ = wp.i18n.__;
  var InspectorControls = wp.blockEditor
    ? wp.blockEditor.InspectorControls
    : wp.editor.InspectorControls; // Compatibility

  // Add new attribute for target blank functionality
  function addAttributes(settings) {
    if (settings.name !== "core/social-links") {
      // Corrected block name
      return settings;
    }

    // Use lodash.assign to safely add to existing attributes
    settings.attributes = lodash.assign(settings.attributes, {
      enableTargetBlank: {
        type: "boolean",
        default: false,
      },
    });

    return settings;
  }

  // Create HOC to add checkbox control in the inspector
  var withInspectorControl = wp.compose.createHigherOrderComponent(function (
    BlockEdit
  ) {
    return function (props) {
      if (props.name !== "core/social-links") {
        return createElement(BlockEdit, props);
      }

      return createElement(
        Fragment,
        {},
        createElement(BlockEdit, props),
        createElement(
          InspectorControls,
          {},
          createElement(ToggleControl, {
            label: __("Enable target blank only", "text-domain"),
            checked: props.attributes.enableTargetBlank,
            onChange: function (newValue) {
              props.setAttributes({ enableTargetBlank: newValue });
            },
          })
        )
      );
    };
  },
  "withInspectorControl");

  // Apply filters
  addFilter(
    "blocks.registerBlockType",
    "my-custom-extensions/add-attributes",
    addAttributes
  );

  addFilter(
    "editor.BlockEdit",
    "my-custom-extensions/with-inspector-control",
    withInspectorControl
  );
})(window.wp);
