<?php

/**
 * Template Name: Author Profile
 *
 * @package WordPress
 * @subpackage FTM Base
 * @since FTM Base 1.0.1
 */

$show_sidebar       = false;
$wrapper_class      = 'ftm_author_content_wrapper';
$latest_posts_title = "Posts by ";
$wordpress_user_account = get_the_author_meta('ID');
get_header();
?>
<?php do_action('ftm_before_content_hook'); ?>
<div class="<?php echo $wrapper_class; ?> site_content_wrapper">
    <div class="content_panel">
        <?php
        $author_name = get_the_author();
        $latest_posts_title = $latest_posts_title . $author_name;
        ?>
        <div class="latest-posts-title">
            <h1><?php echo $latest_posts_title; ?></h1>
        </div>
        <div class="latest" id="latest_post_wrapper">
            <?php
            $initial_latest_posts_offset = 0;
            $post_type = (!empty(get_theme_mod('ftm_general_author_related_post_type'))) ? get_theme_mod('ftm_general_author_related_post_type') : 'post';

            $args = array(
                'post_type'      => $post_type,
                'post_status'     => 'publish',
                'posts_per_page' => 9,
                'orderby'        => 'date',
                'order'          => 'DESC',
                'author'        => $wordpress_user_account
            );

            $query = new WP_Query($args);

            if ($query->found_posts < $initial_latest_posts_offset) {
                $initial_latest_posts_offset = $query->found_posts;
            }

            if ($query->have_posts()) :
                while ($query->have_posts()) : $query->the_post();
                
            ?>
                    <article>
                        <?php if (has_post_thumbnail()) : ?>
                            <div class="post-thumbnail">
                                <a href="<?php the_permalink(); ?>">
                                    <?php the_post_thumbnail('medium', array('alt' => $author_name)); ?>
                                    <div class="post_meta">
                                        <span class="author">By: <?php echo get_the_author_meta('display_name'); ?>&nbsp;|&nbsp;</span>
                                        <span class="post-date"><?php echo get_the_modified_date(); ?></span>
                                    </div>
                                </a>
                            </div>
                        <?php endif; ?>

                        <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                        <div class="post_excerpt">
                            <?php echo ftm_get_text_excerpt(get_the_content(), 25); ?>
                        </div>

                    </article>
            <?php
                endwhile;
                wp_reset_postdata();
            endif;
            ?>
        </div>
        <input id="latest_posts_offset" name="latest_posts_offset" value="<?php echo $initial_latest_posts_offset; ?>" type="hidden" />
        <div class="ftm_load_more" data-user-id="<?php echo $wordpress_user_account; ?>">
            <div></div>
            <div></div>
            <div></div>
        </div>
    </div>
</div>
<?php get_footer(); ?>