<?php
/**
 * Block Name: Reviews Hub
 *
 * This is the template that displays the reviews hub block.
 */

 //Set Block ACF Field Values

$block_title          = get_field('block_title');
$display_search_value = get_field('display_search');
$reviews_per_page     = get_field('reviews_per_page');
$reviews_categories   = get_field('reviews_category');
$specific_reviews_opt = get_field('specific_reviews');
$select_reviews       = get_field('select_reviews');
$display_search       = isset($display_search_value) ? $display_search_value : false;

//Check if the specific reviews option is checked
$specific_reviews_value = '-1';
$review_types_selected = 'all';

if ($specific_reviews_opt) {
    $specific_reviews_value = implode(',', $select_reviews);
}

if (is_array($reviews_categories) ) {
    $review_types_selected = implode(',', $reviews_categories);
}

// create id attribute for specific styling
$id = 'reviews-hub-' . rand();

// create align class ("alignwide") from block setting ("wide")
$align_class = $block['align'] ? 'align' . $block['align'] : '';

?>
<div id="<?php echo $id; ?>" class="review-hub-wrapper <?php echo $align_class; ?>" data-hub-id="<?php echo $id; ?>" data-ppp="<?php echo $reviews_per_page; ?>" data-page="1" data-reviews-cat="<?php echo $review_types_selected; ?>" data-specifc-reviews="<?php echo $specific_reviews_value; ?>">
    <div class="review-hub">
        <div class="search-box <?php echo ($display_search != true)? 'hidden':''; ?>">
            <span><?php echo $block_title; ?></span>
            <div class="search_controls">
                <input type="text" placeholder="Search...">
                <button class="search_button"><span>Search</span></button>
            </div>
        </div>
        <div class="reviews-list-wrapper">            
        </div>
        <div class="pagination-container"></div>
        <div class="lds-ftm-base"><div></div><div></div><div></div></div>
    </div>
</div>