<?php
//BASIC SECURITY MEASURES
remove_action('wp_head', 'wp_generator'); // Display the XHTML generator that is generated on the wp_head hook, WP version

// Remove Filters
//remove_filter('the_excerpt', 'wpautop'); // Remove <p> tags from Excerpt altogether
//remove_filter( 'the_content', 'wpautop' );

// Remove the REST API endpoint.
remove_action('rest_api_init', 'wp_oembed_register_route');

// Turn off oEmbed auto discovery.
add_filter('embed_oembed_discover', '__return_false');

// Don't filter oEmbed results.
remove_filter('oembed_dataparse', 'wp_filter_oembed_result', 10);

// Remove oEmbed discovery links.
remove_action('wp_head', 'wp_oembed_add_discovery_links');

// Remove oEmbed-specific JavaScript from the front-end and back-end.
remove_action('wp_head', 'wp_oembed_add_host_js');

// Disable XML-RPC
add_filter('xmlrpc_enabled', '__return_false');

// Remove Emoji Styles and Scripts
remove_action('wp_head', 'print_emoji_detection_script', 7);
remove_action('admin_print_scripts', 'print_emoji_detection_script');
remove_action('wp_print_styles', 'print_emoji_styles');
remove_action('admin_print_styles', 'print_emoji_styles');


function disable_wp_feeds()
{
    if (is_feed()) {
        // Option 1: Redirect feed requests to the homepage
        // wp_redirect(home_url(), 302);
        //exit();

        // Option 2: Display a message and terminate
        printf(__('Feeds are not available on this website. Please visit our homepage.'));
        exit();
    }
}
add_action('do_feed', 'disable_wp_feeds', 1);
add_action('do_feed_rdf', 'disable_wp_feeds', 1);
add_action('do_feed_rss', 'disable_wp_feeds', 1);
add_action('do_feed_rss2', 'disable_wp_feeds', 1);
add_action('do_feed_atom', 'disable_wp_feeds', 1);
add_action('do_feed_rss2_comments', 'disable_wp_feeds', 1);
add_action('do_feed_atom_comments', 'disable_wp_feeds', 1);

remove_action('wp_head', 'feed_links', 2);
remove_action('wp_head', 'feed_links_extra', 3);
