<?php

/**
 * FTM-Blocks
 *
 * @package       FTMBLOCKS
 * @author        IT
 * @version       1.0.0
 *
 * @wordpress-plugin
 * Plugin Name:   FTM-Blocks
 * Plugin URI:    https://www.ftmedia.com
 * Description:   FTM Blocks for sites
 * Version:       1.0.0
 * Author:        IT
 * Author URI:    https://www.ftmedia.com
 * Text Domain:   ftm-blocks
 * Domain Path:   /languages
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

/**
 * HELPER COMMENT START
 * 
 * This file contains the main information about the plugin.
 * It is used to register all components necessary to run the plugin.
 * 
 * The comment above contains all information about the plugin 
 * that are used by WordPress to differenciate the plugin and register it properly.
 * It also contains further PHPDocs parameter for a better documentation
 * 
 * The function FTMBLOCKS() is the main function that you will be able to 
 * use throughout your plugin to extend the logic. Further information
 * about that is available within the sub classes.
 * 
 * HELPER COMMENT END
 */

// Plugin name
define('FTMBLOCKS_NAME',			'FTM-Blocks');

// Plugin version
define('FTMBLOCKS_VERSION',		'1.0.0');

// Plugin Root File
define('FTMBLOCKS_PLUGIN_FILE',	__FILE__);

// Plugin base
define('FTMBLOCKS_PLUGIN_BASE',	plugin_basename(FTMBLOCKS_PLUGIN_FILE));

// Plugin Folder Path
define('FTMBLOCKS_PLUGIN_DIR',	plugin_dir_path(FTMBLOCKS_PLUGIN_FILE));

// Plugin Folder URL
define('FTMBLOCKS_PLUGIN_URL',	plugin_dir_url(FTMBLOCKS_PLUGIN_FILE));

/**
 * Load the main class for the core functionality
 */
require_once FTMBLOCKS_PLUGIN_DIR . 'core/class-ftm-blocks.php';

/**
 * The main function to load the only instance
 * of our master class.
 *
 * @author  IT
 * @since   1.0.0
 * @return  object|Ftm_Blocks
 */
function FTMBLOCKS()
{
	return Ftm_Blocks::instance();
}

FTMBLOCKS();
