<?php
// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class FTM_Blocks_List_Icon
{
    private $block_name = 'list-icon';
    private $block_folder_name = 'list-icon';
    private $block_css_manifest_key = 'ftm_list_icon';
    private $block_title = 'List - Icon';
    private $block_description = '';
    private $block_icon = 'editor-ul';
    private $block_keywords = ['ftm', 'custom', 'list', 'icon'];
    private $block_mode = 'preview';
    private $block_category = "ftm-blocks";
    private $ftm_blocks_helper;

    public function init()
    {
        $this->ftm_blocks_helper = new Ftm_Blocks_Helpers();
        $this->register_block();
        $this->register_fields();
    }

    public function get_block_name()
    {
        return $this->block_name;
    }

    public function load_assets()
    {
        wp_enqueue_style('ftm_block_list_icon', $this->ftm_blocks_helper->webpack($this->block_css_manifest_key . '.css'));
        wp_enqueue_style('ftm_blocks_icons');
    }

    private function register_block()
    {
        if (function_exists('acf_register_block_type')) {

            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => FTMBLOCKS_PLUGIN_DIR . "/blocks/" . $this->block_folder_name . "/render.php",
                'enqueue_assets' => array($this, 'load_assets'),
                'supports' => [
                    'jsx' => true,
                    'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
                'example'  => array(
                    'attributes' => array(
                        'mode' => 'preview',
                        'data' => array(
                            'preview_image_help' => FTMBLOCKS_PLUGIN_URL . "/blocks/" . $this->block_folder_name . "/preview.jpg",
                        )
                    )
                )
            ]);
        }
    }

    private function register_fields()
    {
        if (function_exists('acf_add_local_field_group')) :

            acf_add_local_field_group(array(
                'key' => 'group_63927125a30b8',
                'title' => 'List-Icon',
                'fields' => array(
                    array(
                        'key' => 'field_639271253347c',
                        'label' => 'Icon',
                        'name' => 'ftm_list_icon_type',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'heart-empty' => 'Heart Empty',
                            'heart' => 'Heart',
                            'ok-circled' => 'Circle OK',
                            'check' => 'Check',
                            'ok-circled2' => 'Cicle',
                            'minus' => 'Minus',
                            'plus' => 'Plus',
                            'plus-squared' => 'Plus Squared',
                        ),
                        'default_value' => false,
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_63934b222c449',
                        'label' => 'Icon Color',
                        'name' => 'ftm_list_icon_icon_color',
                        'type' => 'color_picker',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'enable_opacity' => 0,
                        'return_format' => 'string',
                    ),
                    array(
                        'key' => 'field_6392754bbd325',
                        'label' => 'Number of columns',
                        'name' => 'ftm_list_icon_columns',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            1 => 'One',
                            2 => 'Two',
                            3 => 'Three',
                            4 => 'Four',
                        ),
                        'default_value' => false,
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_639271333347d',
                        'label' => 'Items',
                        'name' => 'ftm_list_icon_items',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'table',
                        'pagination' => 0,
                        'min' => 1,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_639273ed3347e',
                                'label' => 'Item',
                                'name' => 'ftm_list_icon_item',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_639271333347d',
                            ),
                            array(
                                'key' => 'field_63933fb4cb176',
                                'label' => 'Link Target',
                                'name' => 'ftm_list_icon_link_target',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_639271333347d',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/list-icon',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
                'show_in_rest' => 0,
            ));

        endif;
    }
}

$ftm_blocks_list_icon_class = new FTM_Blocks_List_Icon();
$ftm_blocks_list_icon_class->init();

return $ftm_blocks_list_icon_class;
