<?php
if (isset($block['data']['preview_image_help'])) {    /* rendering in inserter preview  */
    echo '<img src="' . $block['data']['preview_image_help'] . '" style="width:100%; height:auto;">';
} else {
    $block["class"]->load_css($block);
    $block_id = (empty($block["data"]["ftm_block_id"])) ? get_field("ftm_block_id") : $block["data"]["ftm_block_id"];
?>
    <?php

    $box_title                    = get_field('title');
    $box_title_tag                = get_field('title_tag');
    $title_alignment              = get_field('title_alignment');
    $description                  = get_field('text_description');
    $list_items_icon              = get_field('list_items_icon');
    $cta_button_text              = get_field('cta_button_text');
    $cta_button_url               = get_field('cta_button_url');

    $box_background_css = "";
    if (have_rows('box_background')) {
        while (have_rows('box_background')) : the_row();
            $box_background_type    = get_sub_field('box_background_type');
            $box_background_color   = get_sub_field('box_background_color');
            $box_background_image   = get_sub_field('box_background_image');

            switch ($box_background_type) {
                case "solid":
                    $box_class = "box-bg-color";
                    break;
                case "image":
                    $box_background_css = 'background:url(' . $box_background_image . '); ';
                    break;
                case "default":
                    $box_class = "default";
                    break;
            }
        endwhile;
    }
    ?>
    <div id="<?php echo $block_id; ?>" class="ftm_informative_cta box-width-max box-width-min <?php echo $box_class; ?>">
        <?php
        //TITLE
        if (!empty($box_title)) {

            if (!empty($box_title_tag)) {
                $title_html = '<' . $box_title_tag . ' class="ftm_informative_cta_title title-color title-size ' . $title_alignment . '" >' . $box_title . '</' . $box_title_tag . '>';
                echo $title_html;
            } else {
                $title_html = '<h2 class="ftm_informative_cta_title title-color title-size ' . $title_alignment . '" >' . $box_title . '</h2>';
                echo $title_html;
            }
        }
        if (!empty($description)) {
            echo '<div class="desc-color">' . $description . '</div>';
        }
        ?>
        <?php
        if (have_rows('list_items')) {

            if ($list_items_icon == "default") {
                $list_items_icon = "icon-ok-circled";
            }

        ?>
            <ul class="item-color item-size">
                <?php
                while (have_rows('list_items')) : the_row();
                    $item_content  = get_sub_field('item_content');
                ?>
                    <li>
                        <i class="<?php echo $list_items_icon; ?> icon-color"></i>
                        <?php echo $item_content ?>
                    </li>
                <?php
                endwhile;
                ?>
            </ul>
        <?php
        }
        ?>
        <?php //CTA BUTTON 
        if (!empty($cta_button_text)) {
            $cta_html = '<a class="ftm_informative_cta_button cta-color btn-bg-color btn-bg-color-hover" ';

            if (!empty($cta_button_url)) {
                $cta_html .= 'href="' . $cta_button_url . '" ';
            }

            $cta_html .= '>' . $cta_button_text . '</a>';

            echo $cta_html;
        }
        ?>
    </div>
<?php
}
?>