<?php

/**
 * Registration logic for the new ACF field type.
 */

if (!defined('ABSPATH')) {
	exit;
}
add_action('init', 'ftm_include_acf_field_ftm_block_id', 5);

/**
 * Registers the ACF field type.
 */
function ftm_include_acf_field_ftm_block_id()
{

	if (!function_exists('acf_register_field_type')) {
		return;
	}

	require_once __DIR__ . '/class-ftm-acf-field-ftm-block-id.php';

	acf_register_field_type('ftm_acf_field_ftm_block_id');
}

add_action('acf/init', 'register_block_id_field');

function register_block_id_field()
{
	if (function_exists('acf_add_local_field_group')) :

		acf_add_local_field_group(array(
			'key' => 'group_63dbe4e1d6f04',
			'title' => 'FTM-BLOCKS',
			'fields' => array(
				array(
					'key' => 'field_63dbe4e36646e',
					'label' => 'FTM Block ID',
					'name' => 'ftm_block_id',
					'aria-label' => '',
					'type' => 'ftm_block_id',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
				),
			),
			'location' => array(
				array(
					array(
						'param' => 'block',
						'operator' => '==',
						'value' => 'acf/informative-cta',
					),
				),
			),
			'menu_order' => 0,
			'position' => 'normal',
			'style' => 'default',
			'label_placement' => 'top',
			'instruction_placement' => 'label',
			'hide_on_screen' => '',
			'active' => true,
			'description' => '',
			'show_in_rest' => 0,
		));

	endif;
}
