<?php

$data = array(
    'display_author'        => get_field('ftm_post_meta_display_author'),
    'display_last_updated'  => get_field('ftm_post_meta_display_last_update'),
    'author_prefix'         => get_field('ftm_post_meta_author_prefix'),
    'last_updated_prefix'   => get_field('ftm_post_meta_last_update_prefix'),
    'separator'             => get_field('ftm_post_meta_separator'),
    'wrapper_class'         => 'ftm-post-meta'
);

// Get the flexible content field data from the ACF group
$wrapper_class        = $data['wrapper_class'];
$display_author       = ( $data['display_author'] ? $data['display_author'] : false );
$display_last_updated = ( $data['display_last_updated'] ? $data['display_last_updated'] : false );
$author_prefix        = ($data['author_prefix']  ? $data['author_prefix'] : __('By: ', 'ftm-blocks') );
$last_updated_prefix  = ($data['last_updated_prefix']  ? $data['last_updated_prefix'] : __('Last Updated: ', 'ftm-blocks') );
$separator            = ($data['separator']  ? $data['separator'] : '' );
$post_author = get_the_author();

$html_output = "";

// Start outputting the HTML table
$html_output  = '<div class="'. $wrapper_class .'">';

if( $display_author ){
    $html_output .= '<div class="ftm-post-meta-autor-block">';
    $html_output .= '<div class="ftm-post-meta-author-prefix">' . $author_prefix . '</div>';
    $html_output .= '<div class="ftm-post-meta-author-name"><a href="'. get_author_posts_url( get_the_author_meta( 'ID' ) ) .'"> ' . $post_author . '</a></div>';
    $html_output .= '</div>';
}

if( $display_author && $display_last_updated ){
    if( $separator != '' ){
        $html_output .= '<span class="ftm-post-meta-separator">' . $separator . '</span>';
    }
}

if( $display_last_updated ){
    $html_output .= '<div class="ftm-post-meta-lu-block">';
    $html_output .= '<div class="ftm-post-meta-lu-prefix">' . $last_updated_prefix . '</div>';
    $html_output .= '<div class="ftm-post-meta-lu-date">' . get_the_modified_date('F d, Y') . '</div>';
    $html_output .= '</div>';
}

// End the block wrapper
$html_output .= '</div>';
echo $html_output;
