<?php
// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Ftm_Blocks_Base
{

    public function load_css(&$block)
    {

        //If the request is coming from WP Admin NOR is coming from ajax don't even bother on loading/writing any CSS file
        /*
        * $_REQUEST["_locale"] -> This request it's being made by WP
        */
        // if ((!empty($_GET["post"]) && $_GET["action"] == 'edit') || ($_REQUEST["action"] == "acf/ajax/fetch-block") || ($_REQUEST["_locale"] == "user")) {
        //     return;
        // }

        $block_id       = $block["data"]["ftm_block_id"];
        $css_file       = Ftm_Blocks_Helpers::getCSSFolder() . $block_id . ".css";
        $css_file_url   = Ftm_Blocks_Helpers::getCSSFolder("url") . $block_id . ".css";

        if (!empty($_REQUEST["preview_id"])) {
            $block["data"]["ftm_block_id"] = $block["data"]["ftm_block_id"] . '-preview';
            $this->write_css($block);
            $css_file = Ftm_Blocks_Helpers::getCSSFolder() . $block_id . "-preview.css";
            $css_file_url   = Ftm_Blocks_Helpers::getCSSFolder("url") . $block_id . "-preview.css";
            $block_id = $block["data"]["ftm_block_id"] . '-preview';
        }

        if (file_exists($css_file)) {
            wp_enqueue_style('ftm_' . $block_id, $css_file_url);
            if (is_user_logged_in()) {
                add_action('admin_enqueue_scripts', function () use ($block_id, $css_file_url) {
                    wp_enqueue_style('admin_ftm_' . $block_id, $css_file_url);
                });
            }
        }
    }

    public function write_css($attributes)
    {
        if (empty($attributes["data"]["ftm_block_id"])) {
            return;
        }

        $temp = $css_property_closer = "";
        $css_fields = $this->get_css_fields();
        $file_name = Ftm_Blocks_Helpers::getCSSFolder() . $attributes["data"]["ftm_block_id"] . ".css";

        foreach ($css_fields as $field => $key) {

            if ($key["field_type"] == "width-unit") {
                continue;
            }

            if ($key["field_type"] == "color") {
                $css_property = "color:";
            }

            if ($key["field_type"] == "font-size") {
                $css_property = "font-size:";
                $css_property_closer = "px";
            }

            if ($key["field_type"] == "bg-color") {
                $css_property = "background-color:";
            }

            if ($key["field_type"] == "hv-color") {
                $field .= ':hover';
                $css_property = "background-color:";
            }

            if ($key["field_type"] == "bg-url") {
                $css_property = "background:url(";
                $css_property_closer = ")";
            }

            if ($key["field_type"] == "max-width" || $key["field_type"] == "min-width") {
                $css_property = ($key["field_type"] == "max-width") ? "max-width:" : "min-width:";
                if ((!empty($css_fields["box-width-unit"]) && (!empty($attributes["data"][$key["field_name"]])))) {
                    if ($attributes["data"][$css_fields["box-width-unit"]["field_name"]] == "pixels") {
                        $css_property_closer = "px";
                    } else {
                        $css_property_closer = "%";
                    }
                }
            }

            //Only add to the css file if there's a value on the field
            if (!empty($attributes["data"][$key["field_name"]])) {
                //Check if the css should be added to the parent wrapper or not
                if (!empty($key["on_parent_wrapper"]) && $key["on_parent_wrapper"] == "yes") {
                    $temp .= "#" . $attributes["data"]["ftm_block_id"] . "." . $field . "{" . $css_property . $attributes["data"][$key["field_name"]] . $css_property_closer . "}";
                } else {
                    $temp .= "#" . $attributes["data"]["ftm_block_id"] . " ." . $field . "{" . $css_property . $attributes["data"][$key["field_name"]] . $css_property_closer . "}";
                }
                unset($css_property);
                unset($css_property_closer);
            }
        }

        //Get current CSS file
        if (file_exists($file_name)) {

            $latest_file = fopen($file_name, "r");
            $temp_latest = fgets($latest_file);
            fclose($latest_file);
        }

        //Check if there's any difference and write the new css file if it does
        if ($temp_latest != $temp) {

            $css_file = fopen($file_name, "w+");
            fwrite($css_file, $temp);
            fclose($css_file);
        }
    }
}
