<?php
// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class FTM_Pricing_Table extends Ftm_Blocks_Base
{
    private $block_name = 'pricing-table';
    private $block_folder_name = 'ftm-pricing-table';
    private $block_css_manifest_key = 'ftm_pricing_table';
    private $block_title = 'Pricing Table';
    private $block_description = '';
    private $block_icon = 'editor-table';
    private $block_keywords = ['ftm', 'custom', 'pricing', 'table'];
    private $block_mode = 'preview';
    private $block_category = "ftm-blocks";

    /* The property below stores all the necessary customizations for this block and this is what
    *  will be consider to generate the CSS based on the block id
    */
    private $css_generate_fields = [
        'membership-titles'                 => ['field_name' => 'title_section_background_color', 'field_type' => 'bg-color'],
        'membership-title'                  => ['field_name' => 'title_text_color', 'field_type' => 'color'],
        'membership-subtitle'               => ['field_name' => 'title_text_color', 'field_type' => 'color'],
        'btn'                               => ['field_name' => 'button_text_color', 'field_type' => 'color'],
        'btn-bg-color'                      => ['field_name' => 'button_background_color', 'field_type' => 'bg-color'],
        'icon-color'                        => ['field_name' => 'icon_color', 'field_type' => 'color'],
    ];

    public function init()
    {
        $this->register_block();
        $this->register_fields();
    }

    public function get_block_name()
    {
        return $this->block_name;
    }

    public function get_css_fields()
    {
        return $this->css_generate_fields;
    }

    public function load_assets()
    {
        $ftm_blocks_helper = new Ftm_Blocks_Helpers();
        wp_enqueue_style('ftm_pricing_table', $ftm_blocks_helper->webpack($this->block_css_manifest_key . '.css'));
        wp_enqueue_style('ftm_blocks_icons');
    }

    private function register_block()
    {
        if (function_exists('acf_register_block_type')) {
            $ftm_blocks_helper = new Ftm_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => FTMBLOCKS_PLUGIN_DIR . "/blocks/" . $this->block_folder_name . "/render.php",
                'enqueue_assets' => [$this, 'load_assets'],
                'supports' => [
                    'jsx' => true,
                    'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
                'example'  => array(
                    'attributes' => array(
                        'mode' => 'preview',
                        'data' => array(
                            'preview_image_help' => FTMBLOCKS_PLUGIN_URL . "/blocks/" . $this->block_folder_name . "/preview.jpg",
                        )
                    )
                ),
                'class' => $this,
            ]);
        }
    }

    private function register_fields()
    {
        if (function_exists('acf_add_local_field_group')) :

            acf_add_local_field_group(array(
                'key' => 'group_6410efdb58b3b',
                'title' => 'Pricing Table',
                'fields' => array(
                    array(
                        'key' => 'field_64124a6187707',
                        'label' => 'General Settings',
                        'name' => '',
                        'type' => 'tab',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'placement' => 'top',
                        'endpoint' => 0,
                    ),
                    array(
                        'key' => 'field_64121f3d639c5',
                        'label' => 'Button Text Color',
                        'name' => 'button_text_color',
                        'type' => 'color_picker',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '#FFFFFF',
                        'enable_opacity' => 0,
                        'return_format' => 'string',
                    ),
                    array(
                        'key' => 'field_64121f62639c6',
                        'label' => 'Button Background Color',
                        'name' => 'button_background_color',
                        'type' => 'color_picker',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'enable_opacity' => 0,
                        'return_format' => 'string',
                    ),
                    array(
                        'key' => 'field_64124b2c3ede2',
                        'label' => 'Standout Text Background Color',
                        'name' => 'standout_text_background_color',
                        'type' => 'color_picker',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'enable_opacity' => 0,
                        'return_format' => 'string',
                    ),
                    array(
                        'key' => 'field_641a2062011cc',
                        'label' => 'Standout Text Color',
                        'name' => 'standout_text_color',
                        'type' => 'color_picker',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '#FFFFFF',
                        'enable_opacity' => 0,
                        'return_format' => 'string',
                    ),
                    array(
                        'key' => 'field_64124ff9fffc5',
                        'label' => 'Title Section Background Color',
                        'name' => 'title_section_background_color',
                        'type' => 'color_picker',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '#000000',
                        'enable_opacity' => 0,
                        'return_format' => 'string',
                    ),
                    array(
                        'key' => 'field_641a2028011cb',
                        'label' => 'Title Text Color',
                        'name' => 'title_text_color',
                        'type' => 'color_picker',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '#FFFFFF',
                        'enable_opacity' => 0,
                        'return_format' => 'string',
                    ),
                    array(
                        'key' => 'field_641225ad453d2',
                        'label' => 'Icon Color',
                        'name' => 'icon_color',
                        'type' => 'color_picker',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'enable_opacity' => 0,
                        'return_format' => 'string',
                    ),
                    array(
                        'key' => 'field_641222d19b20c',
                        'label' => 'Icon',
                        'name' => 'icon',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'angle-double-right' => 'Angle Double Right',
                            'attention' => 'Attention',
                            'attention-circled' => 'Attention Circled',
                            'attention-alt' => 'Attention Alt',
                            'cancel' => 'Cancel',
                            'cancel-circled' => 'Cancel Circled',
                            'check' => 'Check',
                            'flag' => 'Flag',
                            'heart' => 'Heart',
                            'heart-broken' => 'Heart Broken',
                            'heart-empty' => 'Heart Empty',
                            'help' => 'Help',
                            'help-circled' => 'Help Circled',
                            'lightbulb' => 'Lightbulb',
                            'minus' => 'Minus',
                            'ok-circled' => 'Circle OK',
                            'ok-circled2' => 'Circle OK 2',
                            'plus' => 'Plus',
                            'plus-squared' => 'Plus Squared',
                            'question-circle-o' => 'Circle Question',
                            'right' => 'Right',
                            'right-circled' => 'Right Circled',
                            'star' => 'Star',
                            'star-empty' => 'Star Empty',
                        ),
                        'default_value' => 'right',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_64121f16639c3',
                        'label' => 'Button Text',
                        'name' => 'button_text',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_641b2906dc2e7',
                        'label' => 'Button Rel Attributes',
                        'name' => 'button_rel_attributes',
                        'type' => 'text',
                        'instructions' => 'The value of this field will be used as the rel attribute value',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => 'noopener nofollow noreferrer',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64124a8887708',
                        'label' => 'Memberships',
                        'name' => '',
                        'type' => 'tab',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'placement' => 'top',
                        'endpoint' => 0,
                    ),
                    array(
                        'key' => 'field_6410efdc409fd',
                        'label' => 'Memberships',
                        'name' => 'memberships',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_641217c20e79a',
                                'label' => 'Title',
                                'name' => 'membership_title',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_6410efdc409fd',
                            ),
                            array(
                                'key' => 'field_64121b2e0e79b',
                                'label' => 'Subtitle',
                                'name' => 'membership_subtitle',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_6410efdc409fd',
                            ),
                            array(
                                'key' => 'field_64121b450e79c',
                                'label' => 'Price Tag',
                                'name' => 'membership_price_tag',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_6410efdc409fd',
                            ),
                            array(
                                'key' => 'field_64121b770e79d',
                                'label' => 'Price Tag Detail',
                                'name' => 'membership_price_tag_detail',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_6410efdc409fd',
                            ),
                            array(
                                'key' => 'field_64121b950e79e',
                                'label' => 'Membership Features',
                                'name' => 'membership_features',
                                'type' => 'repeater',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'layout' => 'table',
                                'pagination' => 0,
                                'min' => 0,
                                'max' => 0,
                                'collapsed' => '',
                                'button_label' => 'Add Row',
                                'rows_per_page' => 20,
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_64121bc10e79f',
                                        'label' => 'Feature',
                                        'name' => 'membership_desc_feature',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_64121b950e79e',
                                    ),
                                ),
                                'parent_repeater' => 'field_6410efdc409fd',
                            ),
                            array(
                                'key' => 'field_64121f29639c4',
                                'label' => 'Button Link',
                                'name' => 'button_link',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_6410efdc409fd',
                            ),
                            array(
                                'key' => 'field_64124ac587709',
                                'label' => 'Standout Text',
                                'name' => 'membership_standout_text',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_6410efdc409fd',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/pricing-table',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
                'show_in_rest' => 0,
            ));

        endif;
    }
}

$ftm_blocks_pricing_table_class = new FTM_Pricing_Table();
$ftm_blocks_pricing_table_class->init();

return $ftm_blocks_pricing_table_class;
