<?php
// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class FTM_Blocks_Table_CTA_Detailed extends Ftm_Blocks_Base
{
    private $block_name = 'table-cta-detailed';
    private $block_folder_name = 'table-cta-detailed';
    private $block_css_manifest_key = 'ftm_table_cta_detailed';
    private $block_title = 'Table CTA Detailed';
    private $block_description = '';
    private $block_icon = 'editor-table';
    private $block_keywords = ['ftm', 'custom', 'cta', 'call to action', 'table', 'detail'];
    private $block_mode = 'preview';
    private $block_category = "ftm-blocks";
    protected $block_id             = '';

    /* The property below stores all the necessary customizations for this block and this is what
    *  will be consider to generate the CSS based on the block id
    */
    private $css_generate_fields = [
        'table-bg-color'                => ['field_name' => 'ftm_td_table_ftm_td_header_background_color', 'output_type' => 'variable'],
        'table-txt-color'               => ['field_name' => 'ftm_td_table_ftm_td_header_text_color', 'output_type' => 'variable'],
        'visit-txt-color'               => ['field_name' => 'ftm_td_visit_ftm_td_visit_text_color', 'output_type' => 'variable'],
        'visit-txt-color-hover'         => ['field_name' => 'ftm_td_visit_ftm_td_visit_text_color_hover', 'output_type' => 'variable'],
        'visit-bg-color'                => ['field_name' => 'ftm_td_visit_ftm_td_visit_background_color', 'output_type' => 'variable'],
        'visit-bg-border-color'         => ['field_name' => 'ftm_td_visit_ftm_td_visit_border_bottom_color', 'output_type' => 'variable'],
        'visit-bg-color-hover'          => ['field_name' => 'ftm_td_visit_ftm_td_visit_background_color_hover', 'output_type' => 'variable'],
        'visit-bg-border-color-hover'   => ['field_name' => 'ftm_td_visit_ftm_td_visit_border_bottom_color_hover', 'output_type' => 'variable'],
        'current-tab-bg-color'          => ['field_name' => 'ftm_td_current_tab_group_ftm_td_current_background_color', 'output_type' => 'variable'],
        'current-tab-txt-color'         => ['field_name' => 'ftm_td_current_tab_group_ftm_td_current_txt_color', 'output_type' => 'variable'],
        'tab-bg-color'                  => ['field_name' => 'ftm_td_current_tab_group_ftm_td_tab_background_color', 'output_type' => 'variable'],
        'tab-txt-color'                 => ['field_name' => 'ftm_td_current_tab_group_ftm_td_tab_text_color', 'output_type' => 'variable'],
        'tab-bg-color-hover'            => ['field_name' => 'ftm_td_current_tab_group_ftm_td_tab_background_color_hover', 'output_type' => 'variable'],
        'see-bg-color'                  => ['field_name' => 'ftm_td_see_all_group_ftm_td_see_all_background_color', 'output_type' => 'variable'],
        'see-bg-hv-color'               => ['field_name' => 'ftm_td_see_all_group_ftm_td_see_all_background_color_hover', 'output_type' => 'variable'],
        'see-txt-color'                 => ['field_name' => 'ftm_td_see_all_group_ftm_td_see_all_text_color', 'output_type' => 'variable'],
        'see-txt-color-hover'           => ['field_name' => 'ftm_td_see_all_group_ftm_td_see_all_text_color_hover', 'output_type' => 'variable'],
        'first-txt-color'               => ['field_name' => 'ftm_td_records_ftm_td_first_txt_color', 'output_type' => 'variable'],
        'first-bg-color'                => ['field_name' => 'ftm_td_records_ftm_td_first_bg_color', 'output_type' => 'variable'],
        'records-bg-color'              => ['field_name' => 'ftm_td_records_ftm_td_general_bg_color', 'output_type' => 'variable'],
        'pros-icon-color'               => ['field_name' => 'ftm_td_icons_ftm_td_pros_icon_color', 'output_type' => 'variable'],
        'cons-icon-color'               => ['field_name' => 'ftm_td_icons_ftm_td_cons_icon_color', 'output_type' => 'variable'],
        'how-txt-color'                 => ['field_name' => 'ftm_td_how_rate_ftm_td_how_txt_color', 'output_type' => 'variable'],
        'how-icon-color'                => ['field_name' => 'ftm_td_how_rate_ftm_td_trust_icon_color', 'output_type' => 'variable'],
        'how-icon-color-mobile'         => ['field_name' => 'ftm_td_how_rate_ftm_td_trust_icon_color_mobile', 'output_type' => 'variable'],
        'how-bg-color'                  => ['field_name' => 'ftm_td_how_rate_ftm_td_trust_bg_color', 'output_type' => 'variable'],
        'rank-bg-color'                 => ['field_name' => 'ftm_td_records_ftm_td_rank_general_bg_color', 'output_type' => 'variable'],
        'rank-txt-color'                => ['field_name' => 'ftm_td_records_ftm_td_rank_text_color_general', 'output_type' => 'variable'],
    ];

    public function init()
    {
        $this->register_block();
        $this->register_fields();
        
    }

    public function get_block_name()
    {
        return $this->block_name;
    }

    public function get_css_fields()
    {
        return $this->css_generate_fields;
    }

    public function load_assets()
    {
        $ftm_blocks_helper = new Ftm_Blocks_Helpers();
        wp_enqueue_style('ftm_table-cta-detailed', $ftm_blocks_helper->webpack($this->block_css_manifest_key . '.css'));
        wp_enqueue_script( 'ftm_table-cta-detailed-js', FTMBLOCKS_PLUGIN_URL.'blocks/'.$this->block_folder_name.'/assets/js/ftm-td-custom.js', '', '', true );
        wp_enqueue_style('ftm_blocks_icons');
       
    }

    private function register_block()
    {
        if (function_exists('acf_register_block_type')) {
            $ftm_blocks_helper = new Ftm_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => FTMBLOCKS_PLUGIN_DIR . "/blocks/" . $this->block_folder_name . "/render.php",
                'enqueue_assets' => [$this, 'load_assets'],
                'supports' => [
                    'jsx' => true,
                    'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
                'example'  => array(
                    'attributes' => array(
                        'mode' => 'preview',
                        'data' => array(
                            'preview_image_help' => FTMBLOCKS_PLUGIN_URL . "/blocks/" . $this->block_folder_name . "/preview.jpg",
                        )
                    )
                ),
                'class' => $this,
                'ftm_id' => 'block-' . uniqid()
            ]);
        }
    }

    private function register_fields()
    {
        if ( function_exists('acf_add_local_field_group') ):

            acf_add_local_field_group(array(
                'key' => 'group_643865545ccaa',
                'title' => 'FTM Table CTA Detailed',
                'fields' => array(
                    array(
                        'key' => 'field_6438659c6f3fb',
                        'label' => 'General',
                        'name' => '',
                        'aria-label' => '',
                        'type' => 'tab',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'placement' => 'top',
                        'endpoint' => 0,
                    ),
                    array(
                        'key' => 'field_643865546f3fa',
                        'label' => 'Table Title',
                        'name' => 'ftm_td_title',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_643963dbc08d3',
                        'label' => 'See All Text',
                        'name' => 'ftm_td_see_all_text',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64397064e362b',
                        'label' => 'Review Text',
                        'name' => 'ftm_td_review_text',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_644701fa3b52d',
                        'label' => 'Visit Text',
                        'name' => 'ftm_td_visit_text',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_643963fdc08d4',
                        'label' => 'See All Text Link',
                        'name' => 'ftm_td_see_all_text_link',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_643971d1bac5c',
                        'label' => 'Colors',
                        'name' => '',
                        'aria-label' => '',
                        'type' => 'tab',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'placement' => 'top',
                        'endpoint' => 0,
                    ),
                    array(
                        'key' => 'field_643d8b57fab82',
                        'label' => 'Table',
                        'name' => 'ftm_td_table',
                        'aria-label' => '',
                        'type' => 'group',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_643970e8d823c',
                                'label' => 'Table Header Background Color',
                                'name' => 'ftm_td_header_background_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#1F2D37',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                            ),
                            array(
                                'key' => 'field_6448209af2060',
                                'label' => 'Table Header Text Color',
                                'name' => 'ftm_td_header_text_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#FFFFFF',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_643d8af71e515',
                        'label' => 'Visit Link',
                        'name' => 'ftm_td_visit',
                        'aria-label' => '',
                        'type' => 'group',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_6439644f88625',
                                'label' => 'Visit Text Color',
                                'name' => 'ftm_td_visit_text_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#000000',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                            ),
                            array(
                                'key' => 'field_6446e447107eb',
                                'label' => 'Visit Text Color Hover',
                                'name' => 'ftm_td_visit_text_color_hover',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#FFFFFF',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                            ),
                            array(
                                'key' => 'field_643964a288626',
                                'label' => 'Visit Background Color',
                                'name' => 'ftm_td_visit_background_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#FDCD1A',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                            ),
                            array(
                                'key' => 'field_6447038392f0d',
                                'label' => 'Visit Border Bottom Color',
                                'name' => 'ftm_td_visit_border_bottom_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#d6ae17',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                            ),
                            array(
                                'key' => 'field_6446ef54107ec',
                                'label' => 'Visit Background Color Hover',
                                'name' => 'ftm_td_visit_background_color_hover',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#e35639',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                            ),
                            array(
                                'key' => 'field_6447045cfb5ba',
                                'label' => 'Visit Border Bottom Color Hover',
                                'name' => 'ftm_td_visit_border_bottom_color_hover',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#e35639',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_643d81a3a36f6',
                        'label' => 'Tabs',
                        'name' => 'ftm_td_current_tab_group',
                        'aria-label' => '',
                        'type' => 'group',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_6439715b27231',
                                'label' => 'Current Tab Background Color',
                                'name' => 'ftm_td_current_background_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#EBF5FF',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                            ),
                            array(
                                'key' => 'field_6447fab34d345',
                                'label' => 'Current Tab Text Color',
                                'name' => 'ftm_td_current_txt_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#15365a',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                            ),
                            array(
                                'key' => 'field_64397192c23a4',
                                'label' => 'Tab Background Color',
                                'name' => 'ftm_td_tab_background_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#215791',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                            ),
                            array(
                                'key' => 'field_6447ff97747d3',
                                'label' => 'Tab Text Color',
                                'name' => 'ftm_td_tab_text_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#FFFFFF',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                            ),
                            array(
                                'key' => 'field_6447fb75788fd',
                                'label' => 'Tab Background Color Hover',
                                'name' => 'ftm_td_tab_background_color_hover',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#2c70ba',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_643972f69988e',
                        'label' => 'See All',
                        'name' => 'ftm_td_see_all_group',
                        'aria-label' => '',
                        'type' => 'group',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_64397207c9076',
                                'label' => 'See All Background Color',
                                'name' => 'ftm_td_see_all_background_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#B5DAFF',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                            ),
                            array(
                                'key' => 'field_6439723992b45',
                                'label' => 'See All Background Color Hover',
                                'name' => 'ftm_td_see_all_background_color_hover',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#317fd6',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                            ),
                            array(
                                'key' => 'field_643972806a543',
                                'label' => 'See All Text Color',
                                'name' => 'ftm_td_see_all_text_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#16365A',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                            ),
                            array(
                                'key' => 'field_644822b3814f1',
                                'label' => 'See All Text Color Hover',
                                'name' => 'ftm_td_see_all_text_color_hover',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#FFFFFF',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_6446d39a9dece',
                        'label' => 'Records',
                        'name' => 'ftm_td_records',
                        'aria-label' => '',
                        'type' => 'group',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_6446d5319decf',
                                'label' => 'First Record Border Color',
                                'name' => 'ftm_td_first_bg_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#11DFD2',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                            ),
                            array(
                                'key' => 'field_6447f8d4ebf75',
                                'label' => 'First Record Text Color',
                                'name' => 'ftm_td_first_txt_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#112c4a',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                            ),
                            array(
                                'key' => 'field_6446dd9d19404',
                                'label' => 'Records Border Color General',
                                'name' => 'ftm_td_general_bg_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#0399E5',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                            ),
                            array(
                                'key' => 'field_6447f5280ace4',
                                'label' => 'Records Rank Background Color General',
                                'name' => 'ftm_td_rank_general_bg_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#112c4a',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                            ),
                            array(
                                'key' => 'field_644821cf22fc4',
                                'label' => 'Records Rank Text Color General',
                                'name' => 'ftm_td_rank_text_color_general',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#ffffff',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_6446e3bf1621c',
                        'label' => 'Icons',
                        'name' => 'ftm_td_icons',
                        'aria-label' => '',
                        'type' => 'group',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_6446e3bf1621d',
                                'label' => 'Pros Icon Color',
                                'name' => 'ftm_td_pros_icon_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#4DDBC9',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                            ),
                            array(
                                'key' => 'field_6446e3bf1621e',
                                'label' => 'Cons Icon Color',
                                'name' => 'ftm_td_cons_icon_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#FF2E04',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_6446f895ebd2b',
                        'label' => 'How we rate',
                        'name' => 'ftm_td_how_rate',
                        'aria-label' => '',
                        'type' => 'group',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_6446f895ebd2c',
                                'label' => 'Text Color',
                                'name' => 'ftm_td_how_txt_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#fccd1b',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                            ),
                            array(
                                'key' => 'field_6446f895ebd2d',
                                'label' => 'Trust Factor Icon Color',
                                'name' => 'ftm_td_trust_icon_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#FFFFFF',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                            ),
                            array(
                                'key' => 'field_6453c3b2fea8d',
                                'label' => 'Trust Factor Icon Color Mobile',
                                'name' => 'ftm_td_trust_icon_color_mobile',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#FCCD1C',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                            ),
                            array(
                                'key' => 'field_6446f9c424881',
                                'label' => 'Trust Factor Background Color',
                                'name' => 'ftm_td_trust_bg_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#1d4a7b',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_643865f095ae7',
                        'label' => 'Tab 1',
                        'name' => '',
                        'aria-label' => '',
                        'type' => 'tab',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'placement' => 'top',
                        'endpoint' => 0,
                    ),
                    array(
                        'key' => 'field_6438661495ae8',
                        'label' => 'Title',
                        'name' => 'ftm_td_tab_1_title',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_6438666a95ae9',
                        'label' => 'Sites',
                        'name' => 'ftm_td_tab_1_sites',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_6438669e95aea',
                                'label' => 'Logo',
                                'name' => 'ftm_td_tab_1_sites_logo',
                                'aria-label' => '',
                                'type' => 'image',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'url',
                                'library' => 'all',
                                'min_width' => '',
                                'min_height' => '',
                                'min_size' => '',
                                'max_width' => 160,
                                'max_height' => 80,
                                'max_size' => '',
                                'mime_types' => '',
                                'preview_size' => 'full',
                                'parent_repeater' => 'field_6438666a95ae9',
                            ),
                            array(
                                'key' => 'field_6438715c04480',
                                'label' => 'Pros',
                                'name' => 'ftm_td_tab_1_site_pros',
                                'aria-label' => '',
                                'type' => 'repeater',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'layout' => 'table',
                                'pagination' => 0,
                                'min' => 0,
                                'max' => 0,
                                'collapsed' => '',
                                'button_label' => 'Add Row',
                                'rows_per_page' => 20,
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_6438717e04481',
                                        'label' => 'Pro Description',
                                        'name' => 'ftm_td_tab_1_sites_pro_value',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_6438715c04480',
                                    ),
                                ),
                                'parent_repeater' => 'field_6438666a95ae9',
                            ),
                            array(
                                'key' => 'field_643871ce1506d',
                                'label' => 'Cons',
                                'name' => 'ftm_td_tab_1_site_cons',
                                'aria-label' => '',
                                'type' => 'repeater',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'layout' => 'table',
                                'min' => 0,
                                'max' => 0,
                                'collapsed' => '',
                                'button_label' => 'Add Row',
                                'rows_per_page' => 20,
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_643871ce1506e',
                                        'label' => 'Con Description',
                                        'name' => 'ftm_td_tab_1_sites_con_value',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_643871ce1506d',
                                    ),
                                ),
                                'parent_repeater' => 'field_6438666a95ae9',
                            ),
                            array(
                                'key' => 'field_6438749046aae',
                                'label' => 'Visit Link',
                                'name' => 'ftm_td_tab_1_site_visit_link',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_6438666a95ae9',
                            ),
                            array(
                                'key' => 'field_6438778b214a8',
                                'label' => 'Review Link',
                                'name' => 'ftm_td_tab_1_site_review_link',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_6438666a95ae9',
                            ),
                            array(
                                'key' => 'field_643877a0214a9',
                                'label' => 'Rating',
                                'name' => 'ftm_td_tab_1_site_rating',
                                'aria-label' => '',
                                'type' => 'range',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'min' => 0,
                                'max' => 100,
                                'step' => 5,
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_6438666a95ae9',
                            ),
                            array(
                                'key' => 'field_643877eb214aa',
                                'label' => 'CTA Image',
                                'name' => 'ftm_td_tab_1_site_cta_image',
                                'aria-label' => '',
                                'type' => 'image',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'url',
                                'library' => 'all',
                                'min_width' => '',
                                'min_height' => '',
                                'min_size' => '',
                                'max_width' => '',
                                'max_height' => '',
                                'max_size' => '',
                                'mime_types' => '',
                                'preview_size' => 'medium',
                                'parent_repeater' => 'field_6438666a95ae9',
                            ),
                            array(
                                'key' => 'field_6438aa901ca60',
                                'label' => 'Free Trial Information',
                                'name' => 'ftm_td_tab_1_site_free_trial',
                                'aria-label' => '',
                                'type' => 'wysiwyg',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'tabs' => 'all',
                                'toolbar' => 'full',
                                'media_upload' => 1,
                                'delay' => 1,
                                'parent_repeater' => 'field_6438666a95ae9',
                            ),
                            array(
                                'key' => 'field_6452a172d6b89',
                                'label' => 'Subscription Packages Title Text',
                                'name' => 'ftm_td_tab_1_site_packages_text',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => 'Membership Packages:',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_6438666a95ae9',
                            ),
                            array(
                                'key' => 'field_6438aad01ca61',
                                'label' => 'Subscription Packages',
                                'name' => 'ftm_td_tab_1_site_packages',
                                'aria-label' => '',
                                'type' => 'wysiwyg',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'tabs' => 'all',
                                'toolbar' => 'full',
                                'media_upload' => 1,
                                'delay' => 0,
                                'parent_repeater' => 'field_6438666a95ae9',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_6439631a7203e',
                        'label' => 'Tab 2',
                        'name' => '',
                        'aria-label' => '',
                        'type' => 'tab',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'placement' => 'top',
                        'endpoint' => 0,
                    ),
                    array(
                        'key' => 'field_643963337203f',
                        'label' => 'Title',
                        'name' => 'ftm_td_tab_2_title',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_6439635872040',
                        'label' => 'Sites',
                        'name' => 'ftm_td_tab_2_sites',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_6439635872041',
                                'label' => 'Logo',
                                'name' => 'ftm_td_tab_2_sites_logo',
                                'aria-label' => '',
                                'type' => 'image',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'url',
                                'library' => 'all',
                                'min_width' => '',
                                'min_height' => '',
                                'min_size' => '',
                                'max_width' => 160,
                                'max_height' => 80,
                                'max_size' => '',
                                'mime_types' => '',
                                'preview_size' => 'full',
                                'parent_repeater' => 'field_6439635872040',
                            ),
                            array(
                                'key' => 'field_6439635872042',
                                'label' => 'Pros',
                                'name' => 'ftm_td_tab_2_site_pros',
                                'aria-label' => '',
                                'type' => 'repeater',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'layout' => 'table',
                                'min' => 0,
                                'max' => 0,
                                'collapsed' => '',
                                'button_label' => 'Add Row',
                                'rows_per_page' => 20,
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_6439635872043',
                                        'label' => 'Pro Description',
                                        'name' => 'ftm_td_tab_2_sites_pro_value',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_6439635872042',
                                    ),
                                ),
                                'parent_repeater' => 'field_6439635872040',
                            ),
                            array(
                                'key' => 'field_6439635872044',
                                'label' => 'Cons',
                                'name' => 'ftm_td_tab_2_site_cons',
                                'aria-label' => '',
                                'type' => 'repeater',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'layout' => 'table',
                                'min' => 0,
                                'max' => 0,
                                'collapsed' => '',
                                'button_label' => 'Add Row',
                                'rows_per_page' => 20,
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_6439635872045',
                                        'label' => 'Con Description',
                                        'name' => 'ftm_td_tab_2_sites_con_value',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_6439635872044',
                                    ),
                                ),
                                'parent_repeater' => 'field_6439635872040',
                            ),
                            array(
                                'key' => 'field_6439635872046',
                                'label' => 'Visit Link',
                                'name' => 'ftm_td_tab_2_site_visit_link',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_6439635872040',
                            ),
                            array(
                                'key' => 'field_6439635872047',
                                'label' => 'Review Link',
                                'name' => 'ftm_td_tab_2_site_review_link',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_6439635872040',
                            ),
                            array(
                                'key' => 'field_6439635872048',
                                'label' => 'Rating',
                                'name' => 'ftm_td_tab_2_site_rating',
                                'aria-label' => '',
                                'type' => 'range',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'min' => 0,
                                'max' => 100,
                                'step' => 5,
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_6439635872040',
                            ),
                            array(
                                'key' => 'field_6439635872049',
                                'label' => 'CTA Image',
                                'name' => 'ftm_td_tab_2_site_cta_image',
                                'aria-label' => '',
                                'type' => 'image',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'url',
                                'library' => 'all',
                                'min_width' => '',
                                'min_height' => '',
                                'min_size' => '',
                                'max_width' => '',
                                'max_height' => '',
                                'max_size' => '',
                                'mime_types' => '',
                                'preview_size' => 'medium',
                                'parent_repeater' => 'field_6439635872040',
                            ),
                            array(
                                'key' => 'field_643963587204a',
                                'label' => 'Free Trial Information',
                                'name' => 'ftm_td_tab_2_site_free_trial',
                                'aria-label' => '',
                                'type' => 'wysiwyg',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'tabs' => 'all',
                                'toolbar' => 'full',
                                'media_upload' => 1,
                                'delay' => 1,
                                'parent_repeater' => 'field_6439635872040',
                            ),
                            array(
                                'key' => 'field_6452b2dc51597',
                                'label' => 'Subscription Packages Title Text',
                                'name' => 'ftm_td_tab_2_site_packages_text',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => 'Memberships Plans:',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_6439635872040',
                            ),
                            array(
                                'key' => 'field_643963587204b',
                                'label' => 'Subscription Packages',
                                'name' => 'ftm_td_tab_2_site_packages',
                                'aria-label' => '',
                                'type' => 'wysiwyg',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'tabs' => 'all',
                                'toolbar' => 'full',
                                'media_upload' => 1,
                                'delay' => 0,
                                'parent_repeater' => 'field_6439635872040',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_6452d3b1b4efc',
                        'label' => 'Tab 3',
                        'name' => '',
                        'aria-label' => '',
                        'type' => 'tab',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'placement' => 'top',
                        'endpoint' => 0,
                    ),
                    array(
                        'key' => 'field_6452d3eca51cf',
                        'label' => 'Title',
                        'name' => 'ftm_td_tab_3_title',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_6452d409c2fb6',
                        'label' => 'Sites',
                        'name' => 'ftm_td_tab_3_sites',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_6452d409c2fb7',
                                'label' => 'Logo',
                                'name' => 'ftm_td_tab_3_sites_logo',
                                'aria-label' => '',
                                'type' => 'image',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'url',
                                'library' => 'all',
                                'min_width' => '',
                                'min_height' => '',
                                'min_size' => '',
                                'max_width' => 160,
                                'max_height' => 80,
                                'max_size' => '',
                                'mime_types' => '',
                                'preview_size' => 'full',
                                'parent_repeater' => 'field_6452d409c2fb6',
                            ),
                            array(
                                'key' => 'field_6452d409c2fb8',
                                'label' => 'Pros',
                                'name' => 'ftm_td_tab_3_site_pros',
                                'aria-label' => '',
                                'type' => 'repeater',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'layout' => 'table',
                                'min' => 0,
                                'max' => 0,
                                'collapsed' => '',
                                'button_label' => 'Add Row',
                                'rows_per_page' => 20,
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_6452d409c2fb9',
                                        'label' => 'Pro Description',
                                        'name' => 'ftm_td_tab_3_sites_pro_value',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_6452d409c2fb8',
                                    ),
                                ),
                                'parent_repeater' => 'field_6452d409c2fb6',
                            ),
                            array(
                                'key' => 'field_6452d40ac2fba',
                                'label' => 'Cons',
                                'name' => 'ftm_td_tab_3_site_cons',
                                'aria-label' => '',
                                'type' => 'repeater',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'layout' => 'table',
                                'min' => 0,
                                'max' => 0,
                                'collapsed' => '',
                                'button_label' => 'Add Row',
                                'rows_per_page' => 20,
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_6452d40ac2fbb',
                                        'label' => 'Con Description',
                                        'name' => 'ftm_td_tab_3_sites_con_value',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_6452d40ac2fba',
                                    ),
                                ),
                                'parent_repeater' => 'field_6452d409c2fb6',
                            ),
                            array(
                                'key' => 'field_6452d40ac2fbc',
                                'label' => 'Visit Link',
                                'name' => 'ftm_td_tab_3_site_visit_link',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_6452d409c2fb6',
                            ),
                            array(
                                'key' => 'field_6452d40ac2fbd',
                                'label' => 'Review Link',
                                'name' => 'ftm_td_tab_3_site_review_link',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_6452d409c2fb6',
                            ),
                            array(
                                'key' => 'field_6452d40ac2fbe',
                                'label' => 'Rating',
                                'name' => 'ftm_td_tab_3_site_rating',
                                'aria-label' => '',
                                'type' => 'range',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'min' => 0,
                                'max' => 100,
                                'step' => 5,
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_6452d409c2fb6',
                            ),
                            array(
                                'key' => 'field_6452d40ac2fbf',
                                'label' => 'CTA Image',
                                'name' => 'ftm_td_tab_3_site_cta_image',
                                'aria-label' => '',
                                'type' => 'image',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'url',
                                'library' => 'all',
                                'min_width' => '',
                                'min_height' => '',
                                'min_size' => '',
                                'max_width' => '',
                                'max_height' => '',
                                'max_size' => '',
                                'mime_types' => '',
                                'preview_size' => 'medium',
                                'parent_repeater' => 'field_6452d409c2fb6',
                            ),
                            array(
                                'key' => 'field_6452d40ac2fc0',
                                'label' => 'Free Trial Information',
                                'name' => 'ftm_td_tab_3_site_free_trial',
                                'aria-label' => '',
                                'type' => 'wysiwyg',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'tabs' => 'all',
                                'toolbar' => 'full',
                                'media_upload' => 1,
                                'delay' => 1,
                                'parent_repeater' => 'field_6452d409c2fb6',
                            ),
                            array(
                                'key' => 'field_6452d40ac2fc1',
                                'label' => 'Subscription Packages Title Text',
                                'name' => 'ftm_td_tab_3_site_packages_text',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => 'Memberships Plans:',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_6452d409c2fb6',
                            ),
                            array(
                                'key' => 'field_6452d40ac2fc2',
                                'label' => 'Subscription Packages',
                                'name' => 'ftm_td_tab_3_site_packages',
                                'aria-label' => '',
                                'type' => 'wysiwyg',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'tabs' => 'all',
                                'toolbar' => 'full',
                                'media_upload' => 1,
                                'delay' => 0,
                                'parent_repeater' => 'field_6452d409c2fb6',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_6452d535fda73',
                        'label' => 'Tab 4',
                        'name' => '',
                        'aria-label' => '',
                        'type' => 'tab',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'placement' => 'top',
                        'endpoint' => 0,
                    ),
                    array(
                        'key' => 'field_6452d96d74f01',
                        'label' => 'Title',
                        'name' => 'ftm_td_tab_4_title',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_6452d988b839e',
                        'label' => 'Sites',
                        'name' => 'ftm_td_tab_4_sites',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_6452d988b839f',
                                'label' => 'Logo',
                                'name' => 'ftm_td_tab_4_sites_logo',
                                'aria-label' => '',
                                'type' => 'image',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'url',
                                'library' => 'all',
                                'min_width' => '',
                                'min_height' => '',
                                'min_size' => '',
                                'max_width' => 160,
                                'max_height' => 80,
                                'max_size' => '',
                                'mime_types' => '',
                                'preview_size' => 'full',
                                'parent_repeater' => 'field_6452d988b839e',
                            ),
                            array(
                                'key' => 'field_6452d988b83a0',
                                'label' => 'Pros',
                                'name' => 'ftm_td_tab_4_site_pros',
                                'aria-label' => '',
                                'type' => 'repeater',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'layout' => 'table',
                                'min' => 0,
                                'max' => 0,
                                'collapsed' => '',
                                'button_label' => 'Add Row',
                                'rows_per_page' => 20,
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_6452d988b83a1',
                                        'label' => 'Pro Description',
                                        'name' => 'ftm_td_tab_4_sites_pro_value',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_6452d988b83a0',
                                    ),
                                ),
                                'parent_repeater' => 'field_6452d988b839e',
                            ),
                            array(
                                'key' => 'field_6452d988b83a2',
                                'label' => 'Cons',
                                'name' => 'ftm_td_tab_4_site_cons',
                                'aria-label' => '',
                                'type' => 'repeater',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'layout' => 'table',
                                'min' => 0,
                                'max' => 0,
                                'collapsed' => '',
                                'button_label' => 'Add Row',
                                'rows_per_page' => 20,
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_6452d988b83a3',
                                        'label' => 'Con Description',
                                        'name' => 'ftm_td_tab_4_sites_con_value',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_6452d988b83a2',
                                    ),
                                ),
                                'parent_repeater' => 'field_6452d988b839e',
                            ),
                            array(
                                'key' => 'field_6452d988b83a4',
                                'label' => 'Visit Link',
                                'name' => 'ftm_td_tab_4_site_visit_link',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_6452d988b839e',
                            ),
                            array(
                                'key' => 'field_6452d988b83a5',
                                'label' => 'Review Link',
                                'name' => 'ftm_td_tab_4_site_review_link',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_6452d988b839e',
                            ),
                            array(
                                'key' => 'field_6452d988b83a6',
                                'label' => 'Rating',
                                'name' => 'ftm_td_tab_4_site_rating',
                                'aria-label' => '',
                                'type' => 'range',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'min' => 0,
                                'max' => 100,
                                'step' => 5,
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_6452d988b839e',
                            ),
                            array(
                                'key' => 'field_6452d988b83a7',
                                'label' => 'CTA Image',
                                'name' => 'ftm_td_tab_4_site_cta_image',
                                'aria-label' => '',
                                'type' => 'image',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'url',
                                'library' => 'all',
                                'min_width' => '',
                                'min_height' => '',
                                'min_size' => '',
                                'max_width' => '',
                                'max_height' => '',
                                'max_size' => '',
                                'mime_types' => '',
                                'preview_size' => 'medium',
                                'parent_repeater' => 'field_6452d988b839e',
                            ),
                            array(
                                'key' => 'field_6452d988b83a8',
                                'label' => 'Free Trial Information',
                                'name' => 'ftm_td_tab_4_site_free_trial',
                                'aria-label' => '',
                                'type' => 'wysiwyg',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'tabs' => 'all',
                                'toolbar' => 'full',
                                'media_upload' => 1,
                                'delay' => 1,
                                'parent_repeater' => 'field_6452d988b839e',
                            ),
                            array(
                                'key' => 'field_6452d988b83a9',
                                'label' => 'Subscription Packages Title Text',
                                'name' => 'ftm_td_tab_4_site_packages_text',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => 'Memberships Plans:',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_6452d988b839e',
                            ),
                            array(
                                'key' => 'field_6452d988b83aa',
                                'label' => 'Subscription Packages',
                                'name' => 'ftm_td_tab_4_site_packages',
                                'aria-label' => '',
                                'type' => 'wysiwyg',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'tabs' => 'all',
                                'toolbar' => 'full',
                                'media_upload' => 1,
                                'delay' => 0,
                                'parent_repeater' => 'field_6452d988b839e',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/table-cta-detailed',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
                'show_in_rest' => 0,
            ));
            
        endif;
    }
}

$ftm_blocks_table_cta_detailed_class = new FTM_Blocks_Table_CTA_Detailed();
$ftm_blocks_table_cta_detailed_class->init();

return $ftm_blocks_table_cta_detailed_class;
