<?php

/**
 * Defines the custom field type class.
 */

if (!defined('ABSPATH')) {
	exit;
}

/**
 * ftm_acf_field_ftm_block_id class.
 */
class ftm_acf_field_ftm_block_id extends \acf_field
{
	/**
	 * Controls field type visibilty in REST requests.
	 *
	 * @var bool
	 */
	public $show_in_rest = true;

	/**
	 * Environment values relating to the theme or plugin.
	 *
	 * @var array $env Plugin or theme context such as 'url' and 'version'.
	 */
	private $env;

	/**
	 * Constructor.
	 */
	public function __construct()
	{
		/**
		 * Field type reference used in PHP and JS code.
		 *
		 * No spaces. Underscores allowed.
		 */
		$this->name = 'ftm_block_id';

		/**
		 * Field type label.
		 *
		 * For public-facing UI. May contain spaces.
		 */
		$this->label = __('FTM Block Id', 'ftm-blocks');

		/**
		 * The category the field appears within in the field type picker.
		 */
		$this->category = 'basic'; // basic | content | choice | relational | jquery | layout | CUSTOM GROUP NAME

		/**
		 * Defaults for your custom user-facing settings for this field type.
		 */
		$this->defaults = array(
			//'ftm_id'	=> 'block-' . uniqid(),
		);

		/**
		 * Strings used in JavaScript code.
		 *
		 * Allows JS strings to be translated in PHP and loaded in JS via:
		 *
		 * ```js
		 * const errorMessage = acf._e("ftm_block_id", "error");
		 * ```
		 */
		$this->l10n = array(
			'error'	=> __('Error! Please enter a higher value', 'ftm-blocks'),
		);

		$this->env = array(
			'url'     => home_url(str_replace(WP_CONTENT_DIR, CONTENT_DIR, __DIR__)), // URL to the acf-ftm-block-id directory.
			'version' => '1.0', // Replace this with your theme or plugin version constant.
		);

		parent::__construct();
	}

	/**
	 * Settings to display when users configure a field of this type.
	 *
	 * These settings appear on the ACF “Edit Field Group” admin page when
	 * setting up the field.
	 *
	 * @param array $field
	 * @return void
	 */
	public function render_field_settings($field)
	{
		/*
		 * Repeat for each setting you wish to display for this field type.
		 */
		/*acf_render_field_setting(
			$field,
			array(
				'label'			=> __('FTM Block Id', 'ftm-blocks'),
				'instructions'	=> __('Customise the block id', 'ftm-blocks'),
				'type'			=> 'text',
				'name'			=> 'ftm_id',
			)
		);*/

		// To render field settings on other tabs in ACF 6.0+:
		// https://www.advancedcustomfields.com/resources/adding-custom-settings-fields/#moving-field-setting
	}

	public function load_value($value, $blockID, $block)
	{
		/*echo '<pre> Val1: ';
		print_r($value);
		echo '</pre>';
		echo '<pre> Val2: ';
		print_r($blockID);
		echo '</pre>';
		echo '<pre> Val3:';
		print_r($block);
		echo '</pre>';*/

		if (empty($value)) {
			$value = 'block-' . uniqid();
		}

		return $value;
	}

	/**
	 * HTML content to show when a publisher edits the field on the edit screen.
	 *
	 * @param array $field The field settings and values.
	 * @return void
	 */
	public function render_field($field)
	{

		// Debug output to show what field data is available.
		/*echo '<pre>';
		print_r($field);
		echo '</pre>';*/

?>
		<input id="ftm_block_id<?php echo $field["value"]; ?>" type="text" class="ftm_block_id" name="<?php echo esc_attr($field['name']) ?>" value="<?php echo esc_attr($field["value"]) ?>" />
		<br />
		<button onclick="generate_block_id(this, 'ftm_block_id<?php echo esc_attr($field['value']) ?>');" id="ftm_block_id_generate" class="ftm_blocks_generate_block_id">Generate new block id</button>
<?php
	}

	/**
	 * Enqueues CSS and JavaScript needed by HTML in the render_field() method.
	 *
	 * Callback for admin_enqueue_script.
	 *
	 * @return void
	 */
	public function input_admin_enqueue_scripts()
	{

		$url     = trailingslashit($this->env['url']);
		$version = $this->env['version'];


		wp_register_script(
			'ftm-ftm-block-id',
			"{$url}assets/js/field.js",
			array('acf-input'),
			$version
		);

		wp_register_style(
			'ftm-ftm-block-id',
			"{$url}assets/css/field.css",
			array('acf-input'),
			$version
		);

		wp_localize_script(
			'ftm-ftm-block-id',
			'ftm_block_id',
			array(
				'ajax_url' => "{$url}assets/ajax/generate.php",
			)
		);

		wp_enqueue_script('ftm-ftm-block-id');
		wp_enqueue_style('ftm-ftm-block-id');
	}
}
