<?php
if (isset($block['data']['preview_image_help'])) {    /* rendering in inserter preview  */
    echo '<img src="' . $block['data']['preview_image_help'] . '" style="width:100%; height:auto;">';
} else { 
    $block["class"]->load_css($block); 
    $block_id = (empty($block["data"]["ftm_block_id"])) ? get_field("ftm_block_id") : $block["data"]["ftm_block_id"]; 

    $table_title = get_field('ftm_td_title'); 
    $table_see_all_text = get_field('ftm_td_see_all_text');
    $table_see_all_text_link = get_field('ftm_td_see_all_text_link'); 
    $table_review_text = get_field('ftm_td_review_text');
    $table_visit_text = get_field('ftm_td_visit_text');

    $table_safety_text      = get_field('ftm_td_safety_text');
    $table_free_trial_text  = get_field('ftm_td_free_trial_text');
    $table_features_text    = get_field('ftm_td_features_text');
    $table_membership_text  = get_field('ftm_td_membership_text');

    $tabs_quantity = function(){
        
        $total = 0;
        for($counter = 1; $counter <= 4; $counter++){

            if(!empty(get_field('ftm_td_tab_'.$counter.'_title'))){
                $total++;
            }

        }

        return $total;
    };

?>
<div id="<?php echo $block_id; ?>" class="ftm-td--wrapper">
    <div class="ftm-td--header">
        <h2><?php echo $table_title; ?></h2>
        <button class="ftm-td--trust-toggle icon-question-circle-o" aria-label="Show Trust Information"></button>
        <div class="ftm-td--how-rate show">
            <div class="ftm-td--trust-content">
                <button class="ftm-td--trust-content-hide" aria-label="Close Trust Information"></button>
                <div class="ftm-td--how-text">How We Rate</div>
                <div class="trust-factor"><i class="icon-shield"></i><p><span>Safety & Security</span><?php echo $table_safety_text; ?></p></div>
                <div class="trust-factor"><i class="icon-gauge"></i><p><span>Free Trial</span><?php echo $table_free_trial_text; ?></p></div>
                <div class="trust-factor"><i class="icon-star"></i><p><span>Features</span><?php echo $table_features_text; ?></p></div>
                <div class="trust-factor"><i class="icon-dollar"></i><p><span>Membership Pricing</span><?php echo $table_membership_text; ?></p></div>
            </div>
        </div>
    </div>
    <div class="ftm-td--body-wrapper">
        <div class="ftm-td-body-header">
            <?php
            for($counter = 1; $counter <= $tabs_quantity(); $counter++){
                $tab_text = get_field('ftm_td_tab_'.$counter.'_title');
                if($counter == 1){
                    $class = 'class="active"';
                }
            ?>
            <div <?php echo $class; ?> data-tab="tab<?php echo $counter; ?>"><?php echo $tab_text; ?></div>
            <?php
                unset($class);
            }
            ?>
        </div>
        <div class="ftm-td--sites">
        <?php
            for($counter = 1; $counter <= $tabs_quantity(); $counter++){
                if($counter == 1){
                    $class = ' active';
                }
        ?>
            <div id="tab<?php echo $counter; ?>" class="ftm-td--sites-<?php echo $counter; echo $class;?> ">
                <?php
                if (have_rows('ftm_td_tab_'.$counter.'_sites')){
                    $site_counter = 1;
                    while (have_rows('ftm_td_tab_'.$counter.'_sites')) : the_row();

                    $site_logo = get_sub_field('ftm_td_tab_'.$counter.'_sites_logo');
                    $site_logo_attachment = attachment_url_to_postid( $site_logo );
                    $site_logo_alt_attr = get_post_meta($site_logo_attachment, '_wp_attachment_image_alt', TRUE);

                    $site_certificate = get_sub_field('ftm_td_tab_'.$counter.'_site_cta_image');
                    $site_certificate_attachment = attachment_url_to_postid( $site_certificate );
                    $site_certificate_attr = get_post_meta($site_certificate_attachment, '_wp_attachment_image_alt', TRUE);

                    $site_rating = get_sub_field('ftm_td_tab_'.$counter.'_site_rating');
                    $site_free_trial_text = get_sub_field('ftm_td_tab_'.$counter.'_site_free_trial');
                    $site_subscription_text = get_sub_field('ftm_td_tab_'.$counter.'_site_packages');
                    $site_subscription_text_title = get_sub_field('ftm_td_tab_'.$counter.'_site_packages_text');
                    $site_review_link = get_sub_field('ftm_td_tab_'.$counter.'_site_review_link');
                    $site_visit_link  = get_sub_field('ftm_td_tab_'.$counter.'_site_visit_link');

                ?>
                <div class="ftm-td-site">
                    <a href="<?php echo $site_visit_link; ?>" rel="noopener noreferrer nofollow"> </a>
                    <div class="ftm-td-site--rank">#<?php echo $site_counter; ?></div>
                    <div class="ftm-td-site--logo">
                        <img src="<?php echo $site_logo; ?>" <?php if(!empty($site_logo_alt_attr)){echo 'alt="'. $site_logo_alt_attr .'"';} ?> />
                    </div>
                    <div class="ftm-td-site--free-trial">
                        <?php
                            echo $site_free_trial_text;
                        ?>
                    </div>
                    <div class="ftm-td-site--rating">
                        <div class="ftm-td-site--rating-image">
                            <img src="<?php echo $site_certificate; ?>" <?php if(!empty($site_certificate_attr)){echo 'alt="'. $site_certificate_attr .'"';} ?> width="110" height="85" />
                        </div>
                        <div class="ftm-td-site--rating-star">
                            <div class="rating-star--over" style="width: <?php echo $site_rating; ?>%"></div>
                            <div class="rating-star--under"></div>
                        </div>
                    </div>
                    <div class="ftm-td-site--link-wrapper">
                        <a href="<?php echo $site_visit_link; ?>" rel="noopener noreferrer nofollow" class="ftm-td-site--visit">
                            <?php echo $table_visit_text; ?>
                        </a>
                        <a href="<?php echo $site_review_link; ?>" class="ftm-td-site--visit-review">
                        <?php echo $table_review_text; ?>
                        </a>
                    </div>
                    <div class="ftm-td-site--pros">
                        <?php
                        if (have_rows('ftm_td_tab_'.$counter.'_site_pros')){
                            ?>
                        <ul class="ftm-td-site--pro-list">
                            <?php
                            while (have_rows('ftm_td_tab_'.$counter.'_site_pros')) : the_row();
                                $pro_value = get_sub_field('ftm_td_tab_'.$counter.'_sites_pro_value');
                        ?>
                            <li class="icon-ok-circled"><?php echo $pro_value; ?></li>
                            <?php
                            endwhile;
                            ?>
                        </ul>
                        <?php
                        }
                        ?>
                    </div>
                    <div class="ftm-td-site--cons">
                    <?php
                        if (have_rows('ftm_td_tab_'.$counter.'_site_cons')){
                            ?>
                        <ul class="ftm-td-site--con-list">
                            <?php
                            while (have_rows('ftm_td_tab_'.$counter.'_site_cons')) : the_row();
                                $con_value = get_sub_field('ftm_td_tab_'.$counter.'_sites_con_value');
                        ?>
                            <li class="icon-cancel-circled"><?php echo $con_value; ?></li>
                            <?php
                            endwhile;
                            ?>
                        </ul>
                        <?php
                        }
                        ?>
                    </div>
                    <div class="ftm-td-site--memberships">
                        <p><?php echo $site_subscription_text_title; ?></p>
                        <div class="ftm-td-site--membership-details">
                            <?php echo $site_subscription_text; ?>
                        </div>
                    </div>
                </div>
                <?php
                    $site_counter++;
                endwhile;
                }
                ?>
            </div>
            <?php
            unset($class);
            }
            if(!empty($table_see_all_text) && !empty($table_see_all_text_link)){
            ?>
            <div class="ftm-td--footer">
                <a href="<?php echo $table_see_all_text_link; ?>"><?php echo $table_see_all_text; ?></a>
            </div>
            <?php
            }
            ?>
        </div>
    </div>
</div>
<?php
}
?>