<?php
// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class FTM_Comparison extends Ftm_Blocks_Base
{
    private $block_name = 'ftm-comparison';
    private $block_folder_name = 'ftm-comparison';
    private $block_css_manifest_key = 'ftm_comparison';
    private $block_title = 'Comparison Block';
    private $block_description = '';
    private $block_icon = 'editor-table';
    private $block_keywords = ['ftm', 'custom', 'compare', 'comparison'];
    private $block_mode = 'preview';
    private $block_category = "ftm-blocks";
    protected $block_id             = '';

    /* The property below stores all the necessary customizations for this block and this is what
    *  will be consider to generate the CSS based on the block id
    */
    private $css_generate_fields = [
        
    ];

    public function init()
    {
        $this->register_block();
        //$this->register_fields();
        
    }

    public function get_block_name()
    {
        return $this->block_name;
    }

    public function get_css_fields()
    {
        return $this->css_generate_fields;
    }

    public function load_assets()
    {
        $ftm_blocks_helper = new Ftm_Blocks_Helpers();
        wp_enqueue_style('ftm_comparison-css', $ftm_blocks_helper->webpack($this->block_css_manifest_key . '.css'));
        wp_enqueue_script('ftm_comparison-js', $ftm_blocks_helper->webpack($this->block_css_manifest_key . '.js'), '', '', true);
        /*wp_enqueue_style('ftm_blocks_icons');*/
       
    }

    private function register_block()
    {
        if (function_exists('acf_register_block_type')) {
            $ftm_blocks_helper = new Ftm_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => FTMBLOCKS_PLUGIN_DIR . "/blocks/" . $this->block_folder_name . "/render.php",
                'enqueue_assets' => [$this, 'load_assets'],
                'supports' => [
                    'jsx' => true,
                    'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
                'example'  => array(
                    'attributes' => array(
                        'mode' => 'preview',
                        'data' => array(
                            'preview_image_help' => FTMBLOCKS_PLUGIN_URL . "/blocks/" . $this->block_folder_name . "/preview.jpg",
                        )
                    )
                ),
                'class' => $this,
                'ftm_id' => 'block-' . uniqid()
            ]);
        }
    }

    private function register_fields()
    {
        
            
            
    }
}

$ftm_blocks_comparison_class = new FTM_Comparison();
$ftm_blocks_comparison_class->init();

return $ftm_blocks_comparison_class;
