    // breakpoint where swiper will be destroyed
    // and switches to a dual-column layout
    const ftm_window_width  = window.innerWidth || document.documentElement.clientWidth || document.body.clientWidth;
    
    const breakpoint = window.matchMedia( '(min-width:764px)' );
    // keep track of swiper instances to destroy later
    let ftmct_swiper;
    //////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////
    const breakpointChecker = function() {
    // if larger viewport and multi-row layout needed
    if ( breakpoint.matches === true ) {
        // clean up old instances and inline styles when available
        if ( ftmct_swiper !== undefined ) ftmct_swiper.destroy( true, true );
        // or/and do nothing
        return;
    // else if a small viewport and single column layout needed
    } else if ( breakpoint.matches === false ) {
        // fire small viewport version of swiper
        return enableSwiper();
    }
    };
    //////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////
    const enableSwiper = function() {
        ftmct_swiper = new Swiper('.swiper', {
        slidesPerView: 1,
        direction: 'horizontal',
        loop: false,
        pagination: {
        clickable: true,
        },
        pagination: {
        el: '.swiper-pagination',
        },
        navigation: {
        nextEl: '.swiper-button-next',
        prevEl: '.swiper-button-prev',
        },
    });
    };
    //////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////
    // keep an eye on viewport size changes
    breakpoint.addListener(breakpointChecker);
    // kickstart
    breakpointChecker();    


    function ftm_makeAjaxRequest(data, callbackFunction) {
        
        var endpointUrl = ftm_ajax_url;
        var xhr = new XMLHttpRequest();        
        xhr.open('POST', endpointUrl);
        //xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

        xhr.addEventListener("readystatechange", function() {
            if(this.readyState === 4) {
                callbackFunction(this.response);
            }
        });
        
        xhr.send(data);
    }

    function ftm_render_small_site_item(site_id, site_json){
        var item_html = '';
        item_html += '<div class="__site_item" data-id="' + site_id + '">';
        item_html += '<div class="site-logo">';
        item_html += '<img src="' + site_json.site_logo.url +'" alt="' + site_json.site_name + '"/>';
        item_html += '</div>';
        item_html += '<div class="divider"></div>';
        item_html += '<div class="site-selector">';
        item_html += '<input type="checkbox" class="is-site-selected" />';
        item_html += 'Select to compare';
        item_html += '</div>';
        item_html += '</div> ';

        return item_html;
    }

    function ftm_render_big_site_item(site_id, site_json){
        var memberships = site_json.site_memberships;
        var starting_price = '';
        var memberships_prices = [];
        var cheapest_membership_data = [];

        for (let x in memberships) {
            memberships_prices.push(memberships[x].membership_price);
            cheapest_membership_data[memberships[x].membership_price] = memberships[x];
        }        

        var cheapestMembership = Math.min.apply(null, memberships_prices);        
        var cheapestMembershipText = '';

        if( cheapest_membership_data[cheapestMembership]['membership_name'] != '' )
        {
            if( cheapest_membership_data[cheapestMembership]['membership_name'].toLowerCase() != 'free'){
                cheapestMembershipText = cheapestMembership + '/' + cheapest_membership_data[cheapestMembership]['membership_cicle'];
            }
            else
            {
                cheapestMembershipText = "Free";
            }            
        }

        var item_html = '';

        item_html += '<div class="swiper-slide">';
        item_html += '<div class="__site_item_full">';
        item_html += '<div class="site-logo">';
        item_html += '<img src="' + site_json.site_logo.url +'" alt="' + site_json.site_name + '">';
        item_html += '</div>';
        item_html += '<div class="divider"></div>';
        item_html += '<div class="site-features">';
        item_html += '<div class="__feature">';
        item_html += '<label>Website:</label>';
        item_html += '<span><a href="' + site_json.website_url + '">' + site_json.website_text + '</a></span>';
        item_html += '</div>';
        item_html += '<div class="__feature">';
        item_html += '<label># of Active Members:</label>';
        item_html += '<span>' + site_json.active_members + '</span>';
        item_html += '</div>';
        item_html += '<div class="__feature">';
        item_html += '<label>Monthly Visitors:</label>';
        item_html += '<span>' + site_json.monthly_visitors + '</span>';
        item_html += '</div>';
        item_html += '<div class="__feature">';
        item_html += '<label>Free Trial Period:</label>';
        item_html += '<span>' + site_json.free_trial + '</span>';
        item_html += '</div>';
        item_html += '<div class="__feature">';
        item_html += '<label>Gender Ratio:</label>';
        item_html += '<span>' + site_json.gender_ratio + '</span>';
        item_html += '</div>';
        item_html += '<div class="__feature">';
        item_html += '<label>Best For:</label>';
        item_html += '<span>' + site_json.best_for + '</span>';
        item_html += '</div>';
        item_html += '<div class="__feature __rating">';
        item_html += '<label>Our Overal Rating:</label>';
        item_html += '<span>' + site_json.rating_value + ' / ' + site_json.rating_top + '</span>';
        item_html += '</div>';
        item_html += '</div>';
        item_html += '<div class="divider"></div>';
        item_html += '<div class="site-price">';
        item_html += '<label>Starts at:</label>';
        item_html += '<span>'+cheapestMembershipText+'</span>';
        item_html += '</div>';
        item_html += '<div class="site-review-button">';
        item_html += '<a href="'+ site_json.review_url +'">' + site_json.site_name + ' Review</a>';
        item_html += '</div>';
        item_html += '</div>';
        item_html += '</div>';

        return item_html;
    }    

    function ftm_sites_search(search_control_id){
        var search_control = document.getElementById(search_control_id);
        var search_value = '';

        if (typeof(search_control) != 'undefined' && search_control != null)
        {
            search_value = search_control.value;
        }

        var data = new FormData();
        //data.append("action", "ftm_filter_site_by_name");
        data.append("action", "ftm_search_sites_by_name");
        data.append("search_text", search_value);

        ftm_start_loading();
        ftm_makeAjaxRequest( data, function(response_json){
            var response_html = "";
            var response_data = JSON.parse(response_json);
            Object.entries(response_data).forEach(([siteID, siteData]) => {
                response_html += ftm_render_small_site_item(siteID, siteData);
            });

            if(response_html == ""){
                response_html = '-- No Results for the search term: ' + search_value + ' --';
            }

            document.getElementById('ftm_sites_list_container').innerHTML = response_html;
            ftm_enableCheckboxOnClick();
            ftm_stop_loading();
        });                        
    }

    function get_search_empty_wrapper_html(){

        var result_html = '';
        result_html += '<div class="__header">';
        result_html += '<div class="__title">';
        result_html += '<h2></h2>';
        result_html += '<p></p>';
        result_html += '</div>';
        result_html += '<div class="__action-holder">';
        result_html += '<button id="ftmct-compare-btn" name="ftmct-compare-btn" class="__action_button" onclick="ftm_sites_compare();"><i class="__compare_icon"></i>Compare Dating Sites</button>';
        result_html += '</div>';
        result_html += '</div>';
        result_html += '<div class="__search-wrapper">';
        result_html += '<input id="ftmct-search-value" name="ftmct-search-value" class="__search_textbox" placeholder="Search your Dating Site" />';
        result_html += '<button id="ftmct-search-btn" name="ftmct-search-btn" class="__search_button" onclick="ftm_sites_search(\'ftmct-search-value\');" >Search</button>';
        result_html += '</div>';
        result_html += '<div id="ftm_sites_list_container" class="__sites-list">';
        result_html += '</div>';
        result_html += '<div class="__sites-bottom-divider"></div>';
        result_html += '<div class="__sites-bottom-disclaimer"></div>';
        result_html += '<div class="ftmct_loading"></div>';

        return result_html;
    }

    function get_compare_empty_wrapper_html(){
        var result_html = '';

        result_html += '<div class="__header results">';
        result_html += '<div class="__title">';
        result_html += '<h2></h2>';
        result_html += '<p></p>';
        result_html += '</div>';
        result_html += '</div>';
        result_html += '<div class="swiper">';
        result_html += '<div id="ftm_sites_list_container" class="__sites-list results swiper-wrapper"></div>';
        result_html += '<div class="swiper-pagination"></div>';
        result_html += '<div class="swiper-button-prev"></div>';
        result_html += '<div class="swiper-button-next"></div>';
        result_html += '</div>';
        result_html += '<div class="__sites-bottom-button"><button id="ftmct-reset-btn" name="ftmct-reset-btn" class="__action_button" onclick="ftm_reset_comparison();" ><i class="__compare_icon"></i>Reset Dating Sites</button></div>';
        result_html += '<div class="__sites-bottom-divider"></div>';
        result_html += '<div class="__sites-bottom-disclaimer"></div>';
        result_html += '<div class="ftmct_loading"></div>';

        return result_html;
    }

    function ftm_sites_compare(){
        var selected_sites_list = '';
        var overall_wrapper  = document.getElementsByClassName("ftmct-wrapper");
        var ftmct_selected_sites = document.getElementById('ftmct_selected_sites');
        var siteItems = document.querySelectorAll('.ftmct-wrapper > .__sites-list > .__site_item');

        if( !validate_sites() ){
            return false;
        }

        var data = new FormData();
        data.append("action", "ftm_search_sites_by_ids");        

        siteItems.forEach(function(item) {
            var siteID = item.getAttribute('data-id');
            var checkbox = item.querySelector('input[type="checkbox"]');            
            // Check if the checkbox is checked
            if (checkbox.checked) {
                selected_sites_list +=  siteID + ",";
            } 
        });

        if (selected_sites_list.endsWith(",")) {
            selected_sites_list = selected_sites_list.slice(0, -1);
        }

        overall_wrapper[0].innerHTML = get_compare_empty_wrapper_html();
        ftmct_init_block_values();

        data.append("post_ids", selected_sites_list);

        ftm_start_loading();
        ftm_makeAjaxRequest( data, function(response_json){
            var response_html = "";
            var response_data = JSON.parse(response_json);
            Object.entries(response_data).forEach(([siteID, siteData]) => {
                response_html += ftm_render_big_site_item(siteID, siteData);
            });

            document.getElementById('ftm_sites_list_container').innerHTML = response_html;
            ftm_stop_loading();
            breakpointChecker();
        });  

    }

    function ftmct_init_block_values(){
        var top_title = document.getElementById('ftmct_top_title_value').value;
        var top_text = document.getElementById('ftmct_top_text_value').value;
        var bottom_text = document.getElementById('ftmct_bottom_text_value').value;

        // Assign Values
        var title_element = document.querySelector('.ftmct-wrapper > .__header > .__title > h2');
        if (title_element) {
            title_element.innerHTML = top_title;
        }

        var top_text_element = document.querySelector('.ftmct-wrapper > .__header > .__title > p');
        if (top_text_element) {
            top_text_element.innerHTML = top_text;
        }

        var bottom_text_element = document.querySelector('.ftmct-wrapper > .__sites-bottom-disclaimer');
        if (bottom_text_element) {
            bottom_text_element.innerHTML = "<p>" + bottom_text + "</p>";
        }
    }    

    function ftm_reset_comparison(){
        var overall_wrapper  = document.getElementsByClassName("ftmct-wrapper");
        overall_wrapper[0].innerHTML = get_search_empty_wrapper_html();
        ftmct_init_block_values();
        ftm_sites_search('ftmct-search-value');      
    }

    function ftm_enableCheckboxOnClick() {

        var siteItems = document.querySelectorAll('.__site_item');

        siteItems.forEach(function(siteItem) {
            var checkbox = siteItem.querySelector('input[type="checkbox"]');
            siteItem.addEventListener('click', function() {
                checkbox.checked = !checkbox.checked;
            });
        });
    }

    function ftm_start_loading(){
        var wrapper = document.querySelector('.ftmct-wrapper');
        wrapper.classList.add('loading');
    }

    function ftm_stop_loading(){
        var wrapper = document.querySelector('.ftmct-wrapper');
        wrapper.classList.remove('loading');
    }

    function ftm_add_validation_class(){
        var siteItems = document.querySelectorAll('.__site_item');

        var items_count = 0; 
        siteItems.forEach(function(siteItem) {
            if(items_count < 2){                
                if(items_count == 0){
                    siteItem.classList.add('validate');
                    setTimeout(() => {
                        ftm_remove_validation_class(siteItem);
                    }, 600);
                }
                else
                {
                    var nex_timer = items_count * 500;
                    setTimeout( () => {
                        siteItem.classList.add('validate');
                        setTimeout(() => { ftm_remove_validation_class(siteItem); }, 600);
                    }, nex_timer);    
                }    
                
                items_count++;
            }
            else
            {
                return false;
            }
        });
    }

    function ftm_remove_validation_class(siteItem){
            siteItem.classList.remove('validate');
    }

    function validate_sites(){
        var siteItems = document.querySelectorAll('.__site_item');

        var items_checked = 0; 
        siteItems.forEach(function(siteItem) {
            var checkbox = siteItem.querySelector('input[type="checkbox"]');

            if(checkbox.checked){
                items_checked++;
            }
        });

        if( items_checked == 0 ){
            ftm_add_validation_class();
            return false;
        }
        else{
            return true;
        }
    }

    ftmct_init_block_values();
    ftm_sites_search('ftmct-search-value');  