<?php
// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

include_once ABSPATH . 'wp-admin/includes/plugin.php';

class FTM_COMPARISON_TOOL
{
    private $block_name = 'ftm-comparison-tool';
    private $block_folder_name = 'ftm-comparison-tool';
    private $block_css_manifest_key = 'ftm_comparison_tool';
    private $block_title = 'FTM Comparison Tool';
    private $block_description = '';
    private $block_icon = 'editor-table';
    private $block_keywords = ['ftm', 'custom', 'meta', 'comparison', 'tool'];
    private $block_mode = 'preview';
    private $block_category = "ftm-blocks";

    public function init()
    {        
        if ( is_plugin_active( 'ftm-sites-tracker/ftm-sites-tracker.php' ) ) {
            $this->register_block();
            $this->register_fields();
        }
        else
        {
            add_filter( 'allowed_block_types_all', 'add_block_to_blacklist' );
        }
    }
 
    function add_block_to_blacklist( $allowed_blocks ) {
        // get all the registered blocks
        $blocks = WP_Block_Type_Registry::get_instance()->get_all_registered();

        // then disable some of them
        unset( $blocks[ 'acf/ftm-comparison-tool' ] );

        // return the new list of allowed blocks
        return array_keys( $blocks );
        
    }

    public function get_block_name()
    {
        return $this->block_name;
    }

    private function register_block()
    {
        if (function_exists('acf_register_block_type')) {
            $ftm_blocks_helper = new Ftm_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => FTMBLOCKS_PLUGIN_DIR . "/blocks/" . $this->block_folder_name . "/render.php",
                'enqueue_style' => $ftm_blocks_helper->webpack($this->block_css_manifest_key . '.css'),                
                'supports' => [
                    'jsx' => true,
                    'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
                'example'  => array(
                    'attributes' => array(
                        'mode' => 'preview',
                        'data' => array(
                            'preview_image_help' => FTMBLOCKS_PLUGIN_URL . "/blocks/" . $this->block_folder_name . "/preview.jpg",
                        )
                    )
                )
            ]);
        }
    }

    private function register_fields()
    {
        if( function_exists('acf_add_local_field_group') ):


                acf_add_local_field_group(array(
                    'key' => 'group_642134a98a791',
                    'title' => 'FTM Comparison Tool Block',
                    'fields' => array(
                        array(
                            'key' => 'field_640133e9ae358',
                            'label' => 'Control Title',
                            'name' => 'ftm_comp_tool_title',
                            'aria-label' => '',
                            'type' => 'text',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'maxlength' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                        ),
                        array(
                            'key' => 'field_34013446fe370',
                            'label' => 'Top text',
                            'name' => 'ftm_comp_top_text',
                            'aria-label' => '',
                            'type' => 'text',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'maxlength' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                        ),
                        array(
                            'key' => 'field_12313457b387',
                            'label' => 'Bottom Text',
                            'name' => 'ftm_comp_bottom_text',
                            'aria-label' => '',
                            'type' => 'text',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'maxlength' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                        ),                                                                                             
                    ),
                    'location' => array(
                        array(
                            array(
                                'param' => 'block',
                                'operator' => '==',
                                'value' => 'acf/ftm-comparison-tool',
                            ),
                        ),
                    ),
                    'menu_order' => 0,
                    'position' => 'normal',
                    'style' => 'default',
                    'label_placement' => 'top',
                    'instruction_placement' => 'label',
                    'hide_on_screen' => '',
                    'active' => true,
                    'description' => '',
                    'show_in_rest' => 0,
                ));
                
                endif;				        	
    }
}

$ftm_blocks_post_meta_class = new FTM_COMPARISON_TOOL();
$ftm_blocks_post_meta_class->init();

return $ftm_blocks_post_meta_class;
