<?php
if (isset($block['data']['preview_image_help'])) {    /* rendering in inserter preview  */
    echo '<img src="' . $block['data']['preview_image_help'] . '" style="width:100%; height:auto;">';
} else {

    $title              = (!empty(get_field('title'))) ? '<div class="ftm--list-posts-title">' . get_field('title') . '</div>' : '';
    $post_type          = get_field('post_type');
    $show               = get_field('show');
    $category_criteria  = (get_field('category_criteria') == 'include') ? 'category_in' : 'category__not_in';
    $category_include   = get_field('category_include');
    $category_exclude   = get_field('category_exclude');
    $quantity           = get_field('quantity');
    $layout             = get_field('layout');

    $args = array(
        'post_type'      => $post_type,
        'post_status'    => 'publish',
        'posts_per_page' => $quantity,
        'orderby'        => 'date',
        'order'          => 'DESC',
    );

    if (!empty($category_include)) {
        $args[$category_criteria] = $category_include;
    }
    if (!empty($category_exclude)) {
        $args[$category_criteria] = $category_exclude;
    }

    $query = new WP_Query($args);
    global $post;
?>

    <div class="ftm-latest-posts narrow <?php echo $layout; ?>" id="latest_post_wrapper">
        <?php echo $title; ?>
        <?php
        if ($query->have_posts()) :
            while ($query->have_posts()) : $query->the_post(); ?>
                <article>
                    <?php
                    if (has_post_thumbnail()) :
                    ?>
                        <div class="post-thumbnail">
                            <a href="<?php the_permalink(); ?>">
                                <?php the_post_thumbnail($post->ID, 'small'); ?>
                            </a>
                        </div>
                    <?php
                    endif;
                    ?>
                    <div class="ftm--list-post-title"><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></div>
                    <div class="post_meta">
                        <span class="post-date"><?php the_modified_date(); ?></span>
                        <?php ftm_get_estimated_time_to_read(get_the_content()) ?>
                    </div>
                </article>
        <?php
            endwhile;
            wp_reset_postdata();
        endif
        ?>
    </div>
<?php
}
?>