<?php
if (isset($block['data']['preview_image_help'])) {    /* rendering in inserter preview  */
    echo '<img src="' . $block['data']['preview_image_help'] . '" style="width:100%; height:auto;">';
} else 
{    
    $box_title                    = get_field('title');
    $boc_title_tag                = get_field('title_tag');
    $title_font_size              = get_field('title_font_size');
    $title_text_color             = get_field('title_text_color');
    $box_minimum_width            = get_field('box_minimum_width');
    $box_min_width_unit           = get_field('box_min_width_unit');
    $list_items_icon              = get_field('list_items_icon');
    $cta_button_text              = get_field('cta_button_text');
    $cta_button_text_color        = get_field('cta_button_text_color');
    $cta_button_url               = get_field('cta_button_url');
    $cta_button_background_color  = get_field('cta_button_background_color');
    $cta_button_hover_color       = get_field('cta_button_hover_color');
    $cta_button_unique_id         = "ftm-informative-cta_button_" . $block["id"];

    
    $box_css = "";
    $box_background_css = "";
    if ( have_rows('box_background') ){
        while (have_rows('box_background')) : the_row();
            $box_bacground_type   = get_sub_field('box_bacground_type');
            $box_background_color = get_sub_field('box_background_color');
            $box_background_image = get_sub_field('box_background_image');

            switch ( $box_bacground_type ){
                case "solid":
                    $box_background_css = 'background-color:' . $box_background_color . '; ';
                    break;
                case "image":
                    $box_background_css = 'background:url(' . $box_background_image . '); ';
                    break;
                case "default":                    
                    $box_background_css  = 'background: rgb(57,167,240);';
                    $box_background_css .= 'background: -moz-linear-gradient(45deg,  rgba(57,167,240,1) 0%, rgba(41,137,216,1) 37%, rgba(22,217,207,1) 100%);';
                    $box_background_css .= 'background: -webkit-linear-gradient(45deg,  rgba(57,167,240,1) 0%,rgba(41,137,216,1) 37%,rgba(22,217,207,1) 100%);';
                    $box_background_css .= 'background: linear-gradient(45deg,  rgba(57,167,240,1) 0%,rgba(41,137,216,1) 37%,rgba(22,217,207,1) 100%);';
                    $box_background_css .= "filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#39a7f0', endColorstr='#16d9cf',GradientType=1 );";
                    break;
            }            
        endwhile;     
        
        $box_css .= $box_background_css;
    }


    
    if( !empty( $box_minimum_width ) ){
        if( $box_min_width_unit == "pixels" ){
            $box_css .= 'min-width:' . $box_minimum_width .  'px;';
        }
        else
        {
            $box_css .= 'min-width:' . $box_minimum_width . '%;';
        }        
    }    

    if( !empty( $box_css ) ){
        $box_css = ' style="' . $box_css . '"';
    }

?>

<div class="ftm_informative_cta" <?php echo $box_css ?>>
    <?php
    //TITLE
    if( !empty( $box_title ) ){
        $title_css = "";
        if( !empty( $title_font_size ) ){
            $title_css .= "font-size:" . $title_font_size . "px; ";
        }

        if( !empty( $title_text_color ) ){
            $title_css .= "color:" . $title_text_color . "; ";
        }

        if( !empty( $title_css )){
            $title_css = 'style="'.$title_css.'"';
        }

        if( !empty( $boc_title_tag ) ){
            $title_html = '<'.$boc_title_tag.' '.$title_css.'  class="ftm_informative_cta_title" >'. $box_title .'</'.$boc_title_tag.'>';
            echo $title_html;
        }
        else
        {
            $title_html = '<h2 '.$title_css.' class="ftm_informative_cta_title" >'. $box_title .'</h2>';
            echo $title_html;
        }                
    }
    ?>
    <?php //BOX CONTENT ?>
    <?php 
            if (have_rows('list_items')) {
        ?>
    <ul>
        <?php
                while (have_rows('list_items')) : the_row();
                    $item_content  = get_sub_field('item_content');
            ?>
        <li>
            <i class="icon-ok-circled" style="color:#FFFF;"></i>
            <?php echo $item_content ?>
        </li>
        <?php
                endwhile; 
            ?>
    </ul>
    <?php
            }
        ?>
    <?php //CTA BUTTON 
    if( !empty( $cta_button_text ) ){
        $cta_html = '<a id="'.$cta_button_unique_id.'" class="ftm_informative_cta_button" ';

        if( !empty( $cta_button_url ) ){
            $cta_html .= 'href="' . $cta_button_url . '" ';
        }

        $cta_button_css = "";
        if( !empty( $cta_button_text_color ) ){
            $cta_button_css .= 'color:' . $cta_button_text_color . '; ';
        }

        if( !empty( $cta_button_background_color ) ){
            $cta_button_css .= 'background-color:' . $cta_button_background_color . '; ';
        }

        if( !empty( $cta_button_css ) ){
            $cta_html .= 'style="'.$cta_button_css.'"  >' . $cta_button_text . '</a>';
        }
        else
        {
            $cta_html .= '>' . $cta_button_text . '</a>';
        }   
        
        if( $cta_button_hover_color != $cta_button_background_color ){
            $cta_html .= '<style type="text/css">  #'.$cta_button_unique_id.':hover{ background-color:'. $cta_button_hover_color .'!important; } </style> ';
        }

        echo $cta_html;
    }
    ?>
</div>

<?php
}
?>