<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

/**
 * HELPER COMMENT START
 * 
 * This class is used to bring your plugin to life. 
 * All the other registered classed bring features which are
 * controlled and managed by this class.
 * 
 * Within the add_hooks() function, you can register all of 
 * your WordPress related actions and filters as followed:
 * 
 * add_action( 'my_action_hook_to_call', array( $this, 'the_action_hook_callback', 10, 1 ) );
 * or
 * add_filter( 'my_filter_hook_to_call', array( $this, 'the_filter_hook_callback', 10, 1 ) );
 * or
 * add_shortcode( 'my_shortcode_tag', array( $this, 'the_shortcode_callback', 10 ) );
 * 
 * Once added, you can create the callback function, within this class, as followed: 
 * 
 * public function the_action_hook_callback( $some_variable ){}
 * or
 * public function the_filter_hook_callback( $some_variable ){}
 * or
 * public function the_shortcode_callback( $attributes = array(), $content = '' ){}
 * 
 * 
 * HELPER COMMENT END
 */

/**
 * Class Ftm_Blocks_Run
 *
 * Thats where we bring the plugin to life
 *
 * @package		FTMBLOCKS
 * @subpackage	Classes/Ftm_Blocks_Run
 * @author		IT
 * @since		1.0.0
 */
class Ftm_Blocks_Run
{

	/**
	 * Our Ftm_Blocks_Run constructor 
	 * to run the plugin logic.
	 *
	 * @since 1.0.0
	 */
	function __construct()
	{
		$this->add_hooks();
		//$this->register_scripts_and_styles();
	}

	/**
	 * ######################
	 * ###
	 * #### WORDPRESS HOOKS
	 * ###
	 * ######################
	 */

	/**
	 * Registers all WordPress and plugin related hooks
	 *
	 * @access	private
	 * @since	1.0.0
	 * @return	void
	 */
	private function add_hooks()
	{
		//Register CSS and JS files

		add_action('plugin_action_links_' . FTMBLOCKS_PLUGIN_BASE, array($this, 'add_plugin_action_link'), 20);
		add_shortcode('my_shortcode_tag', array($this, 'add_shortcode_callback'));
		add_action('admin_enqueue_scripts', array($this, 'enqueue_backend_scripts_and_styles'), 20);
		add_action('wp_dashboard_setup', array($this, 'manage_dashboard_widgets'), 20);
		add_action('wp_loaded', array($this, 'register_scripts_and_styles'), 20);
		register_activation_hook(FTMBLOCKS_PLUGIN_FILE, array($this, 'activation_hook_callback'));
	}

	/**
	 * ######################
	 * ###
	 * #### WORDPRESS HOOK CALLBACKS
	 * ###
	 * ######################
	 */

	/**
	 * Adds action links to the plugin list table
	 *
	 * @access	public
	 * @since	1.0.0
	 *
	 * @param	array	$links An array of plugin action links.
	 *
	 * @return	array	An array of plugin action links.
	 */
	public function add_plugin_action_link($links)
	{

		$links['our_shop'] = sprintf('<a href="%s" title="Custom Link" style="font-weight:700;">%s</a>', 'https://test.test', __('Custom Link', 'ftm-blocks'));

		return $links;
	}

	/**
	 * Add the shortcode callback for [my_shortcode_tag]
	 *
	 * @access	public
	 * @since	1.0.0
	 *
	 * @param	array	$attr		Additional attributes you have added within the shortcode tag.
	 * @param	string	$content	The content you added between an opening and closing shortcode tag.
	 *
	 * @return	string	The customized content by the shortcode.
	 */
	public function add_shortcode_callback($attr = array(), $content = '')
	{

		$content .= ' this content is added by the add_shortcode_callback() function';

		return $content;
	}

	/**
	 * Enqueue the backend related scripts and styles for this plugin.
	 * All of the added scripts andstyles will be available on every page within the backend.
	 *
	 * @access	public
	 * @since	1.0.0
	 *
	 * @return	void
	 */
	public function enqueue_backend_scripts_and_styles()
	{
		wp_enqueue_style('ftmblocks-backend-styles', FTMBLOCKS_PLUGIN_URL . 'core/includes/assets/css/backend-styles.css', array(), FTMBLOCKS_VERSION, 'all');
	}

	public function register_scripts_and_styles()
	{
		//Register CSS and JS files
		wp_register_style("ftm_blocks_icons", FTMBLOCKS_PLUGIN_URL . "assets/icons/ftm-icons.css");
	}


	/**
	 * Adds all plugin related dashboard widgets
	 *
	 * @access	public
	 * @since	1.0.0
	 *
	 * @return	void
	 */
	public function manage_dashboard_widgets()
	{

		wp_add_dashboard_widget('demo_widget', __('Demo Widget', 'ftm-blocks'), array($this, 'demo_widget_callback'), null, array());
	}

	/**
	 * The callback for the "Demo Widget" widget
	 *
	 * @access	public
	 * @since	1.0.0
	 *
	 * @param	object	$object	Often this is the object that's the focus of the current screen, for example a WP_Post or WP_Comment object.
	 * @param	array	$args	Data that should be set as the $args property of the widget array (which is the fifth parameter passed to the wp_add_dashboard_widget function call)
	 *
	 * @return	void
	 */
	public function demo_widget_callback($object, $args)
	{
?>
		<p>This is some custom demo text.</p>
<?php
	}

	/**
	 * ####################
	 * ### Activation/Deactivation hooks
	 * ####################
	 */

	/*
	 * This function is called on activation of the plugin
	 *
	 * @access	public
	 * @since	1.0.0
	 *
	 * @return	void
	 */
	public function activation_hook_callback()
	{

		//Your code
	}
}
