<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

/**
 * HELPER COMMENT START
 * 
 * This class contains all of the plugin related settings.
 * Everything that is relevant data and used multiple times throughout 
 * the plugin.
 * 
 * To define the actual values, we recommend adding them as shown above
 * within the __construct() function as a class-wide variable. 
 * This variable is then used by the callable functions down below. 
 * These callable functions can be called everywhere within the plugin 
 * as followed using the get_plugin_name() as an example: 
 * 
 * FTMBLOCKS->settings->get_plugin_name();
 * 
 * HELPER COMMENT END
 */

/**
 * Class Ftm_Blocks_Settings
 *
 * This class contains all of the plugin settings.
 * Here you can configure the whole plugin data.
 *
 * @package		FTMBLOCKS
 * @subpackage	Classes/Ftm_Blocks_Settings
 * @author		IT
 * @since		1.0.0
 */
class Ftm_Blocks_Settings
{

	/**
	 * The plugin name
	 *
	 * @var		string
	 * @since   1.0.0
	 */
	private $plugin_name;

	private $block_list;



	/**
	 * Our Ftm_Blocks_Settings constructor 
	 * to run the plugin logic.
	 *
	 * @since 1.0.0
	 */
	function __construct()
	{

		$this->plugin_name = FTMBLOCKS_NAME;
		$this->block_list = $this->blocks_load();
	}

	/**
	 * ######################
	 * ###
	 * #### CALLABLE FUNCTIONS
	 * ###
	 * ######################
	 */

	/**
	 * Return the plugin name
	 *
	 * @access	public
	 * @since	1.0.0
	 * @return	string The plugin name
	 */
	public function get_plugin_name()
	{
		return apply_filters('FTMBLOCKS/settings/get_plugin_name', $this->plugin_name);
	}

	private function blocks_load()
	{
		add_filter('block_categories_all', [$this, 'custom_blocks'], 10, 2);

		$block_classes = [];
		foreach (glob(FTMBLOCKS_PLUGIN_DIR . "/blocks/*/main.php") as $block_file) {
			$block = include $block_file;
			$block_classes[$block->get_block_name()] = $block;
		}

		return $block_classes;
	}

	public function get_blocks()
	{
		return $this->block_list;
	}

	public function get_block($block = null)
	{
		if ($block !== null && isset($this->block_list[$block])) {
			return $this->block_list[$block];
		}

		return null;
	}

	public function custom_blocks($categories)
	{
		return array_merge(
			$categories,
			array(
				array(
					'slug' => 'ftm-blocks',
					'title' => __('FTM Blocks', 'ftm-blocks'),
				),
			)
		);
	}
}
