<?php
// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class FTM_Blocks_Information_Element
{
    private $block_name = 'information-element';
    private $block_folder_name = 'information-element';
    private $block_css_manifest_key = 'ftm_information_element';
    private $block_title = 'Information Element';
    private $block_description = '';
    private $block_icon = 'editor-table';
    private $block_keywords = ['ftm', 'custom', 'cta', 'call to action', 'information', 'vertical', 'line'];
    private $block_mode = 'preview';
    private $block_category = "ftm-blocks";

    public function init()
    {
        $this->register_block();
        $this->register_fields();
    }

    public function get_block_name()
    {
        return $this->block_name;
    }

    public function load_assets()
    {
        $ftm_blocks_helper = new Ftm_Blocks_Helpers();
        wp_enqueue_style('ftm_information_element', $ftm_blocks_helper->webpack($this->block_css_manifest_key . '.css'));
        wp_enqueue_style('ftm_blocks_icons');
    } 

    private function register_block()
    {
        if (function_exists('acf_register_block_type')) {
            $ftm_blocks_helper = new Ftm_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => FTMBLOCKS_PLUGIN_DIR . "/blocks/" . $this->block_folder_name . "/render.php",
                'enqueue_assets' => array($this, 'load_assets'),
                'supports' => [
                    'jsx' => true,
                    'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
                'example'  => array(
                    'attributes' => array(
                        'mode' => 'preview',
                        'data' => array(
                            'preview_image_help' => FTMBLOCKS_PLUGIN_URL . "/blocks/" . $this->block_folder_name . "/preview.jpg",
                        )
                    )
                )
            ]);
        }
    }

    private function register_fields()
    {
        if( function_exists('acf_add_local_field_group') ):

            acf_add_local_field_group(array(
                'key' => 'group_63a33e43f31c2',
                'title' => 'FTM Information Element',
                'fields' => array(
                    array(
                        'key' => 'field_63a33e44c0a62',
                        'label' => 'Show Title',
                        'name' => 'ftm_ie_show_title',
                        'type' => 'true_false',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'message' => 'Display Title',
                        'default_value' => 1,
                        'ui_on_text' => '',
                        'ui_off_text' => '',
                        'ui' => 0,
                    ),
                    array(
                        'key' => 'field_63a33efdc0a63',
                        'label' => 'Title Tag',
                        'name' => 'ftm_ie_title_tag',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'h1' => 'H1',
                            'h2' => 'H2',
                            'h3' => 'H3',
                            'h4' => 'H4',
                            'div' => 'Div',
                            'span' => 'Span',
                        ),
                        'default_value' => 'h3',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_63a33fa5c0a64',
                        'label' => 'Title',
                        'name' => 'ftm_ie_title',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_63a33fbec0a65',
                        'label' => 'Box Content',
                        'name' => 'ftm_ie_box_content',
                        'type' => 'wysiwyg',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'delay' => 1,
                        'tabs' => 'all',
                        'toolbar' => 'full',
                        'media_upload' => 1,
                    ),
                    array(
                        'key' => 'field_63a33ff0c0a66',
                        'label' => 'Vertical Bar Color',
                        'name' => 'ftm_ie_vertical_bar_color',
                        'type' => 'color_picker',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '#084AF3',
                        'enable_opacity' => 0,
                        'return_format' => 'string',
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/information-element',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
                'show_in_rest' => 0,
            ));
            
            endif;		
    }
}

$ftm_blocks_information_element_class = new FTM_Blocks_Information_Element();
$ftm_blocks_information_element_class->init();

return $ftm_blocks_information_element_class;