<?php
// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

class FTM_Blocks_Odds_Calculator
{
    private $block_name = 'ftm-odds-calculator';
    private $block_folder_name = 'ftm-odds-calculator';
    private $block_css_manifest_key = 'ftm_odds_calculator';
    private $block_title = 'FTM Odds Calculator';
    private $block_description = '';
    private $block_icon = 'editor-table';
    private $block_keywords = ['ftm', 'custom', 'cta', 'call to action', 'information', 'vertical', 'line'];
    private $block_mode = 'preview';
    private $block_category = "ftm-blocks";

    public function init()
    {
        $this->register_block();
        $this->register_fields();
    }

    public function get_block_name()
    {
        return $this->block_name;
    }

    public function load_assets()
    {
        $ftm_blocks_helper = new Ftm_Blocks_Helpers();
        wp_enqueue_style('ftm_odds_calculator-css', $ftm_blocks_helper->webpack($this->block_css_manifest_key . '.css'));
        //wp_enqueue_script('ftm_odds_calculator-js', $ftm_blocks_helper->webpack($this->block_css_manifest_key . '.js'));
        wp_enqueue_script('ftm_odds_calculator-js', plugin_dir_url(__FILE__) . 'assets/js/odds-converter.js');
    }

    private function register_block()
    {
        if (function_exists('acf_register_block_type')) {
            $ftm_blocks_helper = new Ftm_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => FTMBLOCKS_PLUGIN_DIR . "/blocks/" . $this->block_folder_name . "/render.php",
                'enqueue_assets' => array($this, 'load_assets'),
                'supports' => [
                    'jsx' => true,
                    'color' => [
                        'background' => false,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
                'example'  => array(
                    'attributes' => array(
                        'mode' => 'preview',
                        'data' => array(
                            'preview_image_help' => FTMBLOCKS_PLUGIN_URL . "/blocks/" . $this->block_folder_name . "/preview.jpg",
                        )
                    )
                )
            ]);
        }
    }

    private function register_fields()
    {
        add_action('acf/include_fields', function () {
            if (! function_exists('acf_add_local_field_group')) {
                return;
            }
        
            acf_add_local_field_group(array(
                'key' => 'group_661f86592a99d',
                'title' => 'FTM Odds Calculator',
                'fields' => array(
                    array(
                        'key' => 'field_661f865943aad',
                        'label' => 'FTM OC Box BG Color',
                        'name' => 'ftm_oc_box_bg_color',
                        'aria-label' => '',
                        'type' => 'color_picker',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'enable_opacity' => 1,
                        'return_format' => 'string',
                    ),                                     
                    array(
                        'key' => 'field_661f936443aaf',
                        'label' => 'FTM OC Reset Button BG Color',
                        'name' => 'ftm_oc_reset_button_bg_color',
                        'aria-label' => '',
                        'type' => 'color_picker',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '#d8d8d8',
                        'enable_opacity' => 0,
                        'return_format' => 'string',
                    ),
                    array(
                        'key' => 'field_6621d77388830',
                        'label' => 'FTM OC Reset Button Font Color',
                        'name' => 'ftm_oc_reset_button_font_color',
                        'aria-label' => '',
                        'type' => 'color_picker',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '#444',
                        'enable_opacity' => 0,
                        'return_format' => 'string',
                    ),
                    array(
                        'key' => 'field_661f8ce943aae',
                        'label' => 'FTM OC Reset Hover BG Color',
                        'name' => 'ftm_oc_reset_hover_bg_color',
                        'aria-label' => '',
                        'type' => 'color_picker',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '#fd4f00',
                        'enable_opacity' => 0,
                        'return_format' => 'string',
                    ),
                    array(
                        'key' => 'field_561f4ce512eca',
                        'label' => 'FTM OC Reset Hover Color',
                        'name' => 'ftm_oc_reset_hover_color',
                        'aria-label' => '',
                        'type' => 'color_picker',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '#fd4f00',
                        'enable_opacity' => 0,
                        'return_format' => 'string',
                    ),
                    array(
                        'key' => 'field_661f938d43ab0',
                        'label' => 'FTM OC Total Results BG Color',
                        'name' => 'ftm_oc_total_results_bg_color',
                        'aria-label' => '',
                        'type' => 'color_picker',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'enable_opacity' => 0,
                        'return_format' => 'string',
                    ),
                    array(
                        'key' => 'field_6621d79588831',
                        'label' => 'FTM OC Total Results Font Color',
                        'name' => 'ftm_oc_total_results_font_color',
                        'aria-label' => '',
                        'type' => 'color_picker',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '#FFFFFF',
                        'enable_opacity' => 0,
                        'return_format' => 'string',
                    ),
                    array(
                        'key' => 'field_6621d67b8882d',
                        'label' => 'FTM OC Labels Color',
                        'name' => 'ftm_oc_labels_color',
                        'aria-label' => '',
                        'type' => 'color_picker',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '#000000',
                        'enable_opacity' => 0,
                        'return_format' => 'string',
                    ),
                    array(
                        'key' => 'field_6621d6b78882e',
                        'label' => 'FTM OC Font Color',
                        'name' => 'ftm_oc_font_color',
                        'aria-label' => '',
                        'type' => 'color_picker',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '#000000',
                        'enable_opacity' => 0,
                        'return_format' => 'string',
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/ftm-odds-calculator',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
                'show_in_rest' => 0,
            ));
        });
    }
}

$ftm_blocks_odds_calculator_class = new FTM_Blocks_Odds_Calculator();
$ftm_blocks_odds_calculator_class->init();

return $ftm_blocks_odds_calculator_class;
