<?php
// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class FTM_Blocks_Table extends Ftm_Blocks_Base
{
    private $block_name = 'ftm-table';
    private $block_folder_name = 'ftm-table';
    private $block_css_manifest_key = 'ftm_table';
    private $block_title = 'FTM Table';
    private $block_description = '';
    private $block_icon = 'editor-table';
    private $block_keywords = ['ftm', 'custom', 'table'];
    private $block_mode = 'preview';
    private $block_category = "ftm-blocks";
    protected $block_id             = '';

    /* The property below stores all the necessary customizations for this block and this is what
    *  will be consider to generate the CSS based on the block id
    */

    public $css_generate_fields = [
        'ftm-table-2-h-bg-color'          => ['field_name' => 'header_color', 'output_type' => 'variable'],
        'ftm-table-2-h-text-color'        => ['field_name' => 'header_text_color', 'output_type' => 'variable'],
        'ftm-table-2-h-width'             => ['field_name' => 'header_width', 'output_type' => 'variable', 'type' => 'dynamic'],
        'ftm-table-2-c-align'             => ['field_name' => 'column_align', 'output_type' => 'variable', 'type' => 'dynamic'],
    ];

    public function init()
    {
        $this->register_block();
        $this->register_fields();
    }

    public function get_block_name()
    {
        return $this->block_name;
    }

    public function get_css_fields()
    {
        return $this->css_generate_fields;
    }

    public function load_assets()
    {
        $ftm_blocks_helper = new Ftm_Blocks_Helpers();
        wp_enqueue_style('ftm_table', $ftm_blocks_helper->webpack($this->block_css_manifest_key . '.css'));
    }

    private function register_block()
    {
        if (function_exists('acf_register_block_type')) {
            $ftm_blocks_helper = new Ftm_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => FTMBLOCKS_PLUGIN_DIR . "/blocks/" . $this->block_folder_name . "/render.php",
                'enqueue_style' => $ftm_blocks_helper->webpack($this->block_css_manifest_key . '.css'),
                'supports' => [
                    'jsx' => true,
                    'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
                'example'  => array(
                    'attributes' => array(
                        'mode' => 'preview',
                        'data' => array(
                            'preview_image_help' => FTMBLOCKS_PLUGIN_URL . "/blocks/" . $this->block_folder_name . "/preview.jpg",
                        )
                    )
                ),
                'class' => $this,
                'ftm_id' => 'block-' . uniqid(),
            ]);
        }
    }

    private function register_fields()
    {
        if (function_exists('acf_add_local_field_group')) :

            acf_add_local_field_group(array(
                'key' => 'group_html_table',
                'title' => 'FTM Table',
                'fields' => array(
                    array(
                        'key' => 'field_63f85a39c2415',
                        'label' => 'Header Color',
                        'name' => 'header_color',
                        'aria-label' => '',
                        'type' => 'color_picker',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '#ffffff',
                        'enable_opacity' => 0,
                        'return_format' => '',
                    ),
                    array(
                        'key' => 'field_63f85a7dc2416',
                        'label' => 'Header Text Color',
                        'name' => 'header_text_color',
                        'aria-label' => '',
                        'type' => 'color_picker',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '#000000',
                        'enable_opacity' => 0,
                        'return_format' => '',
                    ),
                    array(
                        'key' => 'field_63f949b424836',
                        'label' => 'Responsive Behavior',
                        'name' => 'responsive_behavior',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'scroll' => 'Scroll',
                            'vertical' => 'Switch to Vertical',
                        ),
                        'default_value' => 'scroll',
                        'return_format' => '',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_table_blocks',
                        'label' => 'Table Blocks',
                        'name' => 'table_blocks',
                        'aria-label' => '',
                        'type' => 'flexible_content',
                        'instructions' => '',
                        'required' => false,
                        'conditional_logic' => false,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'button_label' => 'Add Block',
                        'layouts' => array(
                            array(
                                'key' => 'layout_table_header',
                                'name' => 'table_header',
                                'label' => 'Table Header',
                                'display' => 'block',
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_63f8347c6a865',
                                        'label' => 'Header Name',
                                        'name' => 'header_name',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                    ),
                                    array(
                                        'key' => 'field_63f8348b6a866',
                                        'label' => 'Header Width',
                                        'name' => 'header_width',
                                        'aria-label' => '',
                                        'type' => 'number',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => 50,
                                        'min' => 1,
                                        'max' => 100,
                                        'placeholder' => 'Width Percentage',
                                        'step' => 1,
                                        'prepend' => '',
                                        'append' => '',
                                    ),
                                ),
                                'min' => '',
                                'max' => '',
                            ),
                            array(
                                'key' => 'layout_table_row',
                                'name' => 'table_row',
                                'label' => 'Table Row',
                                'display' => 'block',
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_row_data',
                                        'label' => 'Row Data',
                                        'name' => 'row_data',
                                        'aria-label' => '',
                                        'type' => 'repeater',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'layout' => 'block',
                                        'min' => 0,
                                        'max' => 0,
                                        'collapsed' => '',
                                        'button_label' => 'Add Column',
                                        'rows_per_page' => 20,
                                        'sub_fields' => array(
                                            array(
                                                'key' => 'field_63f941f2f52d2',
                                                'label' => 'Align',
                                                'name' => 'column_align',
                                                'aria-label' => '',
                                                'type' => 'select',
                                                'instructions' => '',
                                                'required' => 0,
                                                'conditional_logic' => 0,
                                                'wrapper' => array(
                                                    'width' => '',
                                                    'class' => '',
                                                    'id' => '',
                                                ),
                                                'choices' => array(
                                                    'left' => 'Left',
                                                    'center' => 'Center',
                                                    'right' => 'Right',
                                                ),
                                                'default_value' => 'center',
                                                'return_format' => 'value',
                                                'multiple' => 0,
                                                'allow_null' => 0,
                                                'ui' => 0,
                                                'ajax' => 0,
                                                'placeholder' => '',
                                                'parent_repeater' => 'field_row_data',
                                            ),
                                            array(
                                                'key' => 'field_column_value',
                                                'label' => 'Column Value',
                                                'name' => 'column_value',
                                                'aria-label' => '',
                                                'type' => 'wysiwyg',
                                                'instructions' => '',
                                                'required' => 0,
                                                'conditional_logic' => 0,
                                                'wrapper' => array(
                                                    'width' => '',
                                                    'class' => '',
                                                    'id' => '',
                                                ),
                                                'default_value' => '',
                                                'tabs' => 'all',
                                                'toolbar' => 'full',
                                                'media_upload' => 1,
                                                'delay' => 0,
                                                'parent_repeater' => 'field_row_data',
                                            ),
                                        ),
                                    ),
                                ),
                                'min' => '',
                                'max' => '',
                            ),
                        ),
                        'min' => '',
                        'max' => '',
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/ftm-table',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
                'show_in_rest' => 0,
            ));

        endif;
    }
}

$ftm_blocks_table_class = new FTM_Blocks_Table();
$ftm_blocks_table_class->init();

return $ftm_blocks_table_class;
