<?php

$block["class"]->load_css($block);
$block_id = (empty($block["data"]["ftm_block_id"])) ? get_field("ftm_block_id") : $block["data"]["ftm_block_id"];

$header_background_color    = (!empty(get_field('header_color'))) ? get_field('header_color') : acf_get_field('header_color')['default_value'];
$header_text_color          = (!empty(get_field('header_text_color'))) ? get_field('header_text_color') : acf_get_field('header_text_color')['default_value'];

$data = array(
    'table_blocks'          => get_field('table_blocks'),
    'header_color'          => $header_background_color,
    'header_text_color'     => $header_text_color,
    'responsive_behavior'   => get_field('responsive_behavior'),
    'table_class'           => 'ftm-table'
);

// Get the flexible content field data from the ACF group
$table_blocks = $data['table_blocks'];
$header_bg_color = ($data['header_color'] ? $data['header_color'] : '');
$header_text_color = ($data['header_text_color'] ? $data['header_text_color'] : '');
$data['responsive_behavior']  = ($data['responsive_behavior']  ? $data['responsive_behavior'] : 'scroll');
$header_style = "";

$html_output = "";

// Start outputting the HTML table
$html_output    = '<style>:root{--data-bg:' . get_field('header_color') . '; --data-txt-color:' . get_field('header_text_color') . ';}</style>';
$html_output   .= '<div id="' . $block_id . '" class="ftm-table ' . $data['responsive_behavior'] . '">';
$html_output   .= '<table>';
$theader_output = "";
$tbody_output   = "";

// Loop through each block in the flexible content field
if ($table_blocks) {
    $header_count = 1;
    $headers = [];
    foreach ($table_blocks as $table_block) {
        // Check the block type and output the corresponding HTML
        switch ($table_block['acf_fc_layout']) {
            case 'table_header':
                // Output a table header row with the specified column name
                $header_width = ($table_block['header_width'] ? 'width:' . $table_block['header_width'] . '%;' : '');

                $theader_output .= '<th ' . $header_style . '>' . $table_block['header_name'] . '</th>';
                $headers[$header_count] = $table_block['header_name'];
                $header_count++;
                break;
            case 'table_row':
                // Output a table row with the specified column names and values
                $tbody_output .= '<tr>';
                if ($table_block['row_data']) {
                    $colum_count = 1;
                    foreach ($table_block['row_data'] as $row) {
                        $cell_align = $row['column_align'];
                        if (isset($cell_align)) {
                            $cell_align = '--txt-align:' . $cell_align . ';';
                        }
                        if ($data['responsive_behavior'] == "scroll") {
                            $tbody_output .= '<td>' . $row['column_value'] . '</td>';
                        } else {
                            $tbody_output .= '<td data-header="' . $headers[$colum_count] . '" >' . $row['column_value'] . '</td>';
                        }
                        $colum_count++;
                    }
                }
                $tbody_output .= '</tr>';
                break;
        }
    }
}

//Open THEAD block
$html_output .= '<thead><tr>';
$html_output .= $theader_output;
//Close the table head
$html_output .= '</tr></thead>';

//Open BODY block
$html_output .= '<tbody>';
$html_output .= $tbody_output;
//Close the table body
$html_output .= '</tbody>';

// End the HTML table
$html_output .= '</table>';
$html_output .= '</div>';
echo $html_output;
