<?php
if (isset($block['data']['preview_image_help'])) {    /* rendering in inserter preview  */
    echo '<img src="' . $block['data']['preview_image_help'] . '" style="width:100%; height:auto;">';
} else {

    //LOAD THE AUTO GENERATED CSS
    $block["class"]->load_css($block);
    //GET THE BLOCK ID
    $block_id = (empty($block["data"]["ftm_block_id"])) ? get_field("ftm_block_id") : $block["data"]["ftm_block_id"];

    //LOAD VALUES WE WILL NEED
    $icon                              = get_field('icon');
    $btn_text                          = get_field('button_text');
    $btn_link_rel_attributes            = (empty(get_field('button_rel_attributes'))) ? '' : 'rel="' . get_field('button_rel_attributes') . '"';

?>
    <div id="<?php echo $block_id; ?>" class="ftm_pricing_table">
        <?php
        if (have_rows('memberships')) {
            while (have_rows('memberships')) : the_row();
                $membership_title               = get_sub_field('membership_title');
                $membership_subtitle            = get_sub_field('membership_subtitle');
                $membership_price_tag           = get_sub_field('membership_price_tag');
                $membership_price_tag_detail    = get_sub_field('membership_price_tag_detail');
                $membership_standout_text       = get_sub_field('membership_standout_text');
                $btn_link                       = get_sub_field('button_link');
                $membership_price_currency      = (get_sub_field('membership_price_currency')? get_sub_field('membership_price_currency'):'$');
                preg_match('/(\$)?(\d+)\.(\d+)/s', $membership_price_tag, $matches);

        ?>

                <div class="membership">
                    <div class="membership-wrapper">
                        <?php
                        if (!empty($membership_standout_text)) {
                        ?>
                            <div class="membership-ribbon">
                                <?php echo $membership_standout_text; ?>
                            </div>
                        <?php
                        }
                        ?>
                        <div class="membership-titles">
                            <span class="membership-title">
                                <?php echo $membership_title; ?>
                            </span>
                            <span class="membership-subtitle">
                                <?php echo $membership_subtitle; ?>
                            </span>
                        </div>
                        <span class="membership-price">
                            <?php
                            if (!empty($matches)) {
                                echo $membership_price_currency . $matches[2];
                                echo '<span>' . $matches[3] . '</span>';
                            } else {
                                echo $membership_price_currency . $membership_price_tag;
                            }
                            ?>
                        </span>
                        <span class="membership-price-detail">
                            <?php echo $membership_price_tag_detail; ?>
                        </span>
                        <?php
                        if (have_rows('membership_features')) {
                        ?>
                            <ul>
                                <?php
                                while (have_rows('membership_features')) : the_row();

                                    $membership_feature    = get_sub_field('membership_desc_feature');
                                ?>
                                    <li>
                                        <i class="icon-<?php echo $icon; ?> icon-color"></i>
                                        <?php echo $membership_feature; ?>
                                    </li>
                            <?php
                                endwhile;
                            }
                            ?>
                            </ul>
                            <a class="btn btn-bg-color btn-bg-color-hover btn-text-color-hover" target="_blank" href="<?php echo $btn_link; ?>" <?php echo $btn_link_rel_attributes; ?>><?php echo $btn_text; ?></a>
                    </div>
                </div>
    <?php
            endwhile;
        }
    }
    ?>
    </div>