<?php

$data = array(
    'display_author'        => get_field('ftm_post_meta_display_author'),
    'display_author_avatar' => get_field('ftm_post_meta_display_author_avatar'),
    'rounded_avatar'        => get_field('ftm_post_meta_round_image'),
    'display_last_updated'  => get_field('ftm_post_meta_display_last_update'),
    'author_prefix'         => get_field('ftm_post_meta_author_prefix'),
    'last_updated_prefix'   => get_field('ftm_post_meta_last_update_prefix'),
    'separator'             => get_field('ftm_post_meta_separator'),
    'display_border'        => get_field('ftm_post_meta_display_border'),
    'wrapper_class'         => 'ftm-post-meta',
    'border_class'          => 'show-border'
);

// Get the flexible content field data from the ACF group
$wrapper_class         = $data['wrapper_class'];
$display_author        = ($data['display_author'] ? $data['display_author'] : false);
$display_author_avatar = ($data['display_author_avatar'] ? $data['display_author_avatar'] : false);
$rounded_avatar        = ($data['rounded_avatar'] ? $data['rounded_avatar'] : false);
$display_last_updated  = ($data['display_last_updated'] ? $data['display_last_updated'] : false);
$author_prefix         = ($data['author_prefix']  ? $data['author_prefix'] : __('By: ', 'ftm-blocks'));
$last_updated_prefix   = ($data['last_updated_prefix']  ? $data['last_updated_prefix'] : __('Last Updated: ', 'ftm-blocks'));
$separator             = ($data['separator']  ? $data['separator'] : '');
$display_border        = ($data['display_border'] ? $data['display_border'] : false);
$post_author = get_the_author();

$html_output = "";

$border_class_output   = "";
if ($display_border == true) {
    $border_class_output = ' ' . $data['border_class'];
}

// Start outputting the HTML table
$html_output  = '<div class="' . $wrapper_class . ' ' . $border_class_output . '">';

if ($display_author_avatar) {

    if ($rounded_avatar == true) {
        $html_output .= '<div class="ftm-post-meta-autor-avatar rounded-avatar">';
        $html_output .= get_avatar(get_the_author_meta('ID'), $size = '60', $default = '', $alt = '', null);
        $html_output .= '</div>';
    } else {
        $html_output .= '<div class="ftm-post-meta-autor-avatar">';
        $html_output .= get_avatar(get_the_author_meta('ID'), $size = '60', $default = '', $alt = '', null);
        $html_output .= '</div>';
    }
}

if ($display_author) {
    $html_output .= '<div class="ftm-post-meta-autor-block">';
    $html_output .= '<div class="ftm-post-meta-author-prefix">' . $author_prefix . '</div>';
    $html_output .= '<div class="ftm-post-meta-author-name"><a href="' . user_trailingslashit(get_author_posts_url(get_the_author_meta('ID'))) . '"> ' . $post_author . '</a></div>';
    $html_output .= '</div>';
}

if ($display_author && $display_last_updated) {
    if ($separator != '') {
        $html_output .= '<span class="ftm-post-meta-separator">' . $separator . '</span>';
    }
}

if ($display_last_updated) {
    $html_output .= '<div class="ftm-post-meta-lu-block">';
    $html_output .= '<div class="ftm-post-meta-lu-prefix">' . $last_updated_prefix . '</div>';
    $html_output .= '<div class="ftm-post-meta-lu-date">' . get_the_modified_date('F d, Y') . '</div>';
    $html_output .= '</div>';
}

// End the block wrapper
$html_output .= '</div>';
echo $html_output;
