document.addEventListener('DOMContentLoaded', function () {
    const accordions = document.querySelectorAll('.ftm-accordion');

    accordions.forEach(accordion => {
        const accordionItems = accordion.querySelectorAll('.accordion-item');

        accordionItems.forEach(item => {
            const title = item.querySelector('.accordion-title');
            const content = item.querySelector('.accordion-content');
            const icon = item.querySelector('.icon');

            title.addEventListener('click', () => {
                const isActive = title.classList.contains('active');

                if (isActive) {
                    // Collapse the panel
                    title.classList.remove('active');
                    content.style.maxHeight = null;
                    //icon.textContent = '+';
                } else {
                    // Expand the panel
                    title.classList.add('active');
                    content.style.maxHeight = content.scrollHeight + 'px';
                    //icon.textContent = '-';
                }
            });
        });
    });
});
